"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListChannelsAssociatedWithChannelFlow = void 0;
const ChimeSDKMessagingClient_1 = require("../ChimeSDKMessagingClient");
const ListChannelsAssociatedWithChannelFlowCommand_1 = require("../commands/ListChannelsAssociatedWithChannelFlowCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListChannelsAssociatedWithChannelFlowCommand_1.ListChannelsAssociatedWithChannelFlowCommand(input), ...args);
};
async function* paginateListChannelsAssociatedWithChannelFlow(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKMessagingClient_1.ChimeSDKMessagingClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKMessaging | ChimeSDKMessagingClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListChannelsAssociatedWithChannelFlow = paginateListChannelsAssociatedWithChannelFlow;
