import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMessagingClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMessagingClient";
import { AssociateChannelFlowRequest } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link AssociateChannelFlowCommand}.
 */
export interface AssociateChannelFlowCommandInput extends AssociateChannelFlowRequest {
}
/**
 * @public
 *
 * The output of {@link AssociateChannelFlowCommand}.
 */
export interface AssociateChannelFlowCommandOutput extends __MetadataBearer {
}
/**
 * @public
 * <p>Associates a channel flow with a channel. Once associated, all messages to that channel go through channel flow processors. To stop processing, use the
 *          <code>DisassociateChannelFlow</code> API.</p>
 *          <note>
 *             <p>Only administrators or channel moderators can associate a channel flow. The
 *          <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the
 *          <code>AppInstanceUser</code> or <code>AppInstanceBot</code>
 *          that makes the API call as the value in the header.</p>
 *          </note>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMessagingClient, AssociateChannelFlowCommand } from "@aws-sdk/client-chime-sdk-messaging"; // ES Modules import
 * // const { ChimeSDKMessagingClient, AssociateChannelFlowCommand } = require("@aws-sdk/client-chime-sdk-messaging"); // CommonJS import
 * const client = new ChimeSDKMessagingClient(config);
 * const input = { // AssociateChannelFlowRequest
 *   ChannelArn: "STRING_VALUE", // required
 *   ChannelFlowArn: "STRING_VALUE", // required
 *   ChimeBearer: "STRING_VALUE", // required
 * };
 * const command = new AssociateChannelFlowCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param AssociateChannelFlowCommandInput - {@link AssociateChannelFlowCommandInput}
 * @returns {@link AssociateChannelFlowCommandOutput}
 * @see {@link AssociateChannelFlowCommandInput} for command's `input` shape.
 * @see {@link AssociateChannelFlowCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMessagingClientResolvedConfig | config} for ChimeSDKMessagingClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ConflictException} (client fault)
 *  <p>The request could not be processed because of conflict in the current state of the
 *          resource.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link NotFoundException} (client fault)
 *  <p>One or more of the resources in the request does not exist in the system.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class AssociateChannelFlowCommand extends $Command<AssociateChannelFlowCommandInput, AssociateChannelFlowCommandOutput, ChimeSDKMessagingClientResolvedConfig> {
    readonly input: AssociateChannelFlowCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: AssociateChannelFlowCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMessagingClientResolvedConfig, options?: __HttpHandlerOptions): Handler<AssociateChannelFlowCommandInput, AssociateChannelFlowCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
