import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMessagingClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMessagingClient";
import { ListChannelFlowsRequest, ListChannelFlowsResponse } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link ListChannelFlowsCommand}.
 */
export interface ListChannelFlowsCommandInput extends ListChannelFlowsRequest {
}
/**
 * @public
 *
 * The output of {@link ListChannelFlowsCommand}.
 */
export interface ListChannelFlowsCommandOutput extends ListChannelFlowsResponse, __MetadataBearer {
}
/**
 * @public
 * <p>Returns a paginated lists of all the channel flows created under a single Chime. This is a developer API.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMessagingClient, ListChannelFlowsCommand } from "@aws-sdk/client-chime-sdk-messaging"; // ES Modules import
 * // const { ChimeSDKMessagingClient, ListChannelFlowsCommand } = require("@aws-sdk/client-chime-sdk-messaging"); // CommonJS import
 * const client = new ChimeSDKMessagingClient(config);
 * const input = { // ListChannelFlowsRequest
 *   AppInstanceArn: "STRING_VALUE", // required
 *   MaxResults: Number("int"),
 *   NextToken: "STRING_VALUE",
 * };
 * const command = new ListChannelFlowsCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param ListChannelFlowsCommandInput - {@link ListChannelFlowsCommandInput}
 * @returns {@link ListChannelFlowsCommandOutput}
 * @see {@link ListChannelFlowsCommandInput} for command's `input` shape.
 * @see {@link ListChannelFlowsCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMessagingClientResolvedConfig | config} for ChimeSDKMessagingClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class ListChannelFlowsCommand extends $Command<ListChannelFlowsCommandInput, ListChannelFlowsCommandOutput, ChimeSDKMessagingClientResolvedConfig> {
    readonly input: ListChannelFlowsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: ListChannelFlowsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMessagingClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ListChannelFlowsCommandInput, ListChannelFlowsCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
