"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateSearchAvailablePhoneNumbers = void 0;
const ChimeSDKVoiceClient_1 = require("../ChimeSDKVoiceClient");
const SearchAvailablePhoneNumbersCommand_1 = require("../commands/SearchAvailablePhoneNumbersCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new SearchAvailablePhoneNumbersCommand_1.SearchAvailablePhoneNumbersCommand(input), ...args);
};
async function* paginateSearchAvailablePhoneNumbers(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKVoiceClient_1.ChimeSDKVoiceClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKVoice | ChimeSDKVoiceClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateSearchAvailablePhoneNumbers = paginateSearchAvailablePhoneNumbers;
