import { ChimeSDKVoiceClient } from "./ChimeSDKVoiceClient";
import { AssociatePhoneNumbersWithVoiceConnectorCommand, } from "./commands/AssociatePhoneNumbersWithVoiceConnectorCommand";
import { AssociatePhoneNumbersWithVoiceConnectorGroupCommand, } from "./commands/AssociatePhoneNumbersWithVoiceConnectorGroupCommand";
import { BatchDeletePhoneNumberCommand, } from "./commands/BatchDeletePhoneNumberCommand";
import { BatchUpdatePhoneNumberCommand, } from "./commands/BatchUpdatePhoneNumberCommand";
import { CreatePhoneNumberOrderCommand, } from "./commands/CreatePhoneNumberOrderCommand";
import { CreateProxySessionCommand, } from "./commands/CreateProxySessionCommand";
import { CreateSipMediaApplicationCallCommand, } from "./commands/CreateSipMediaApplicationCallCommand";
import { CreateSipMediaApplicationCommand, } from "./commands/CreateSipMediaApplicationCommand";
import { CreateSipRuleCommand, } from "./commands/CreateSipRuleCommand";
import { CreateVoiceConnectorCommand, } from "./commands/CreateVoiceConnectorCommand";
import { CreateVoiceConnectorGroupCommand, } from "./commands/CreateVoiceConnectorGroupCommand";
import { CreateVoiceProfileCommand, } from "./commands/CreateVoiceProfileCommand";
import { CreateVoiceProfileDomainCommand, } from "./commands/CreateVoiceProfileDomainCommand";
import { DeletePhoneNumberCommand, } from "./commands/DeletePhoneNumberCommand";
import { DeleteProxySessionCommand, } from "./commands/DeleteProxySessionCommand";
import { DeleteSipMediaApplicationCommand, } from "./commands/DeleteSipMediaApplicationCommand";
import { DeleteSipRuleCommand, } from "./commands/DeleteSipRuleCommand";
import { DeleteVoiceConnectorCommand, } from "./commands/DeleteVoiceConnectorCommand";
import { DeleteVoiceConnectorEmergencyCallingConfigurationCommand, } from "./commands/DeleteVoiceConnectorEmergencyCallingConfigurationCommand";
import { DeleteVoiceConnectorGroupCommand, } from "./commands/DeleteVoiceConnectorGroupCommand";
import { DeleteVoiceConnectorOriginationCommand, } from "./commands/DeleteVoiceConnectorOriginationCommand";
import { DeleteVoiceConnectorProxyCommand, } from "./commands/DeleteVoiceConnectorProxyCommand";
import { DeleteVoiceConnectorStreamingConfigurationCommand, } from "./commands/DeleteVoiceConnectorStreamingConfigurationCommand";
import { DeleteVoiceConnectorTerminationCommand, } from "./commands/DeleteVoiceConnectorTerminationCommand";
import { DeleteVoiceConnectorTerminationCredentialsCommand, } from "./commands/DeleteVoiceConnectorTerminationCredentialsCommand";
import { DeleteVoiceProfileCommand, } from "./commands/DeleteVoiceProfileCommand";
import { DeleteVoiceProfileDomainCommand, } from "./commands/DeleteVoiceProfileDomainCommand";
import { DisassociatePhoneNumbersFromVoiceConnectorCommand, } from "./commands/DisassociatePhoneNumbersFromVoiceConnectorCommand";
import { DisassociatePhoneNumbersFromVoiceConnectorGroupCommand, } from "./commands/DisassociatePhoneNumbersFromVoiceConnectorGroupCommand";
import { GetGlobalSettingsCommand, } from "./commands/GetGlobalSettingsCommand";
import { GetPhoneNumberCommand, } from "./commands/GetPhoneNumberCommand";
import { GetPhoneNumberOrderCommand, } from "./commands/GetPhoneNumberOrderCommand";
import { GetPhoneNumberSettingsCommand, } from "./commands/GetPhoneNumberSettingsCommand";
import { GetProxySessionCommand, } from "./commands/GetProxySessionCommand";
import { GetSipMediaApplicationAlexaSkillConfigurationCommand, } from "./commands/GetSipMediaApplicationAlexaSkillConfigurationCommand";
import { GetSipMediaApplicationCommand, } from "./commands/GetSipMediaApplicationCommand";
import { GetSipMediaApplicationLoggingConfigurationCommand, } from "./commands/GetSipMediaApplicationLoggingConfigurationCommand";
import { GetSipRuleCommand } from "./commands/GetSipRuleCommand";
import { GetSpeakerSearchTaskCommand, } from "./commands/GetSpeakerSearchTaskCommand";
import { GetVoiceConnectorCommand, } from "./commands/GetVoiceConnectorCommand";
import { GetVoiceConnectorEmergencyCallingConfigurationCommand, } from "./commands/GetVoiceConnectorEmergencyCallingConfigurationCommand";
import { GetVoiceConnectorGroupCommand, } from "./commands/GetVoiceConnectorGroupCommand";
import { GetVoiceConnectorLoggingConfigurationCommand, } from "./commands/GetVoiceConnectorLoggingConfigurationCommand";
import { GetVoiceConnectorOriginationCommand, } from "./commands/GetVoiceConnectorOriginationCommand";
import { GetVoiceConnectorProxyCommand, } from "./commands/GetVoiceConnectorProxyCommand";
import { GetVoiceConnectorStreamingConfigurationCommand, } from "./commands/GetVoiceConnectorStreamingConfigurationCommand";
import { GetVoiceConnectorTerminationCommand, } from "./commands/GetVoiceConnectorTerminationCommand";
import { GetVoiceConnectorTerminationHealthCommand, } from "./commands/GetVoiceConnectorTerminationHealthCommand";
import { GetVoiceProfileCommand, } from "./commands/GetVoiceProfileCommand";
import { GetVoiceProfileDomainCommand, } from "./commands/GetVoiceProfileDomainCommand";
import { GetVoiceToneAnalysisTaskCommand, } from "./commands/GetVoiceToneAnalysisTaskCommand";
import { ListAvailableVoiceConnectorRegionsCommand, } from "./commands/ListAvailableVoiceConnectorRegionsCommand";
import { ListPhoneNumberOrdersCommand, } from "./commands/ListPhoneNumberOrdersCommand";
import { ListPhoneNumbersCommand, } from "./commands/ListPhoneNumbersCommand";
import { ListProxySessionsCommand, } from "./commands/ListProxySessionsCommand";
import { ListSipMediaApplicationsCommand, } from "./commands/ListSipMediaApplicationsCommand";
import { ListSipRulesCommand, } from "./commands/ListSipRulesCommand";
import { ListSupportedPhoneNumberCountriesCommand, } from "./commands/ListSupportedPhoneNumberCountriesCommand";
import { ListTagsForResourceCommand, } from "./commands/ListTagsForResourceCommand";
import { ListVoiceConnectorGroupsCommand, } from "./commands/ListVoiceConnectorGroupsCommand";
import { ListVoiceConnectorsCommand, } from "./commands/ListVoiceConnectorsCommand";
import { ListVoiceConnectorTerminationCredentialsCommand, } from "./commands/ListVoiceConnectorTerminationCredentialsCommand";
import { ListVoiceProfileDomainsCommand, } from "./commands/ListVoiceProfileDomainsCommand";
import { ListVoiceProfilesCommand, } from "./commands/ListVoiceProfilesCommand";
import { PutSipMediaApplicationAlexaSkillConfigurationCommand, } from "./commands/PutSipMediaApplicationAlexaSkillConfigurationCommand";
import { PutSipMediaApplicationLoggingConfigurationCommand, } from "./commands/PutSipMediaApplicationLoggingConfigurationCommand";
import { PutVoiceConnectorEmergencyCallingConfigurationCommand, } from "./commands/PutVoiceConnectorEmergencyCallingConfigurationCommand";
import { PutVoiceConnectorLoggingConfigurationCommand, } from "./commands/PutVoiceConnectorLoggingConfigurationCommand";
import { PutVoiceConnectorOriginationCommand, } from "./commands/PutVoiceConnectorOriginationCommand";
import { PutVoiceConnectorProxyCommand, } from "./commands/PutVoiceConnectorProxyCommand";
import { PutVoiceConnectorStreamingConfigurationCommand, } from "./commands/PutVoiceConnectorStreamingConfigurationCommand";
import { PutVoiceConnectorTerminationCommand, } from "./commands/PutVoiceConnectorTerminationCommand";
import { PutVoiceConnectorTerminationCredentialsCommand, } from "./commands/PutVoiceConnectorTerminationCredentialsCommand";
import { RestorePhoneNumberCommand, } from "./commands/RestorePhoneNumberCommand";
import { SearchAvailablePhoneNumbersCommand, } from "./commands/SearchAvailablePhoneNumbersCommand";
import { StartSpeakerSearchTaskCommand, } from "./commands/StartSpeakerSearchTaskCommand";
import { StartVoiceToneAnalysisTaskCommand, } from "./commands/StartVoiceToneAnalysisTaskCommand";
import { StopSpeakerSearchTaskCommand, } from "./commands/StopSpeakerSearchTaskCommand";
import { StopVoiceToneAnalysisTaskCommand, } from "./commands/StopVoiceToneAnalysisTaskCommand";
import { TagResourceCommand } from "./commands/TagResourceCommand";
import { UntagResourceCommand, } from "./commands/UntagResourceCommand";
import { UpdateGlobalSettingsCommand, } from "./commands/UpdateGlobalSettingsCommand";
import { UpdatePhoneNumberCommand, } from "./commands/UpdatePhoneNumberCommand";
import { UpdatePhoneNumberSettingsCommand, } from "./commands/UpdatePhoneNumberSettingsCommand";
import { UpdateProxySessionCommand, } from "./commands/UpdateProxySessionCommand";
import { UpdateSipMediaApplicationCallCommand, } from "./commands/UpdateSipMediaApplicationCallCommand";
import { UpdateSipMediaApplicationCommand, } from "./commands/UpdateSipMediaApplicationCommand";
import { UpdateSipRuleCommand, } from "./commands/UpdateSipRuleCommand";
import { UpdateVoiceConnectorCommand, } from "./commands/UpdateVoiceConnectorCommand";
import { UpdateVoiceConnectorGroupCommand, } from "./commands/UpdateVoiceConnectorGroupCommand";
import { UpdateVoiceProfileCommand, } from "./commands/UpdateVoiceProfileCommand";
import { UpdateVoiceProfileDomainCommand, } from "./commands/UpdateVoiceProfileDomainCommand";
import { ValidateE911AddressCommand, } from "./commands/ValidateE911AddressCommand";
export class ChimeSDKVoice extends ChimeSDKVoiceClient {
    associatePhoneNumbersWithVoiceConnector(args, optionsOrCb, cb) {
        const command = new AssociatePhoneNumbersWithVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    associatePhoneNumbersWithVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new AssociatePhoneNumbersWithVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchDeletePhoneNumber(args, optionsOrCb, cb) {
        const command = new BatchDeletePhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    batchUpdatePhoneNumber(args, optionsOrCb, cb) {
        const command = new BatchUpdatePhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createPhoneNumberOrder(args, optionsOrCb, cb) {
        const command = new CreatePhoneNumberOrderCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createProxySession(args, optionsOrCb, cb) {
        const command = new CreateProxySessionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createSipMediaApplication(args, optionsOrCb, cb) {
        const command = new CreateSipMediaApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createSipMediaApplicationCall(args, optionsOrCb, cb) {
        const command = new CreateSipMediaApplicationCallCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createSipRule(args, optionsOrCb, cb) {
        const command = new CreateSipRuleCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createVoiceConnector(args, optionsOrCb, cb) {
        const command = new CreateVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new CreateVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createVoiceProfile(args, optionsOrCb, cb) {
        const command = new CreateVoiceProfileCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    createVoiceProfileDomain(args, optionsOrCb, cb) {
        const command = new CreateVoiceProfileDomainCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deletePhoneNumber(args, optionsOrCb, cb) {
        const command = new DeletePhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteProxySession(args, optionsOrCb, cb) {
        const command = new DeleteProxySessionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteSipMediaApplication(args, optionsOrCb, cb) {
        const command = new DeleteSipMediaApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteSipRule(args, optionsOrCb, cb) {
        const command = new DeleteSipRuleCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnector(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorEmergencyCallingConfiguration(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorEmergencyCallingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorOrigination(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorOriginationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorProxy(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorProxyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorStreamingConfiguration(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorStreamingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorTermination(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorTerminationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceConnectorTerminationCredentials(args, optionsOrCb, cb) {
        const command = new DeleteVoiceConnectorTerminationCredentialsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceProfile(args, optionsOrCb, cb) {
        const command = new DeleteVoiceProfileCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    deleteVoiceProfileDomain(args, optionsOrCb, cb) {
        const command = new DeleteVoiceProfileDomainCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    disassociatePhoneNumbersFromVoiceConnector(args, optionsOrCb, cb) {
        const command = new DisassociatePhoneNumbersFromVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    disassociatePhoneNumbersFromVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new DisassociatePhoneNumbersFromVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getGlobalSettings(args, optionsOrCb, cb) {
        const command = new GetGlobalSettingsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getPhoneNumber(args, optionsOrCb, cb) {
        const command = new GetPhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getPhoneNumberOrder(args, optionsOrCb, cb) {
        const command = new GetPhoneNumberOrderCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getPhoneNumberSettings(args, optionsOrCb, cb) {
        const command = new GetPhoneNumberSettingsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getProxySession(args, optionsOrCb, cb) {
        const command = new GetProxySessionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getSipMediaApplication(args, optionsOrCb, cb) {
        const command = new GetSipMediaApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getSipMediaApplicationAlexaSkillConfiguration(args, optionsOrCb, cb) {
        const command = new GetSipMediaApplicationAlexaSkillConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getSipMediaApplicationLoggingConfiguration(args, optionsOrCb, cb) {
        const command = new GetSipMediaApplicationLoggingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getSipRule(args, optionsOrCb, cb) {
        const command = new GetSipRuleCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getSpeakerSearchTask(args, optionsOrCb, cb) {
        const command = new GetSpeakerSearchTaskCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnector(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorEmergencyCallingConfiguration(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorEmergencyCallingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorLoggingConfiguration(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorLoggingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorOrigination(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorOriginationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorProxy(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorProxyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorStreamingConfiguration(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorStreamingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorTermination(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorTerminationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceConnectorTerminationHealth(args, optionsOrCb, cb) {
        const command = new GetVoiceConnectorTerminationHealthCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceProfile(args, optionsOrCb, cb) {
        const command = new GetVoiceProfileCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceProfileDomain(args, optionsOrCb, cb) {
        const command = new GetVoiceProfileDomainCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    getVoiceToneAnalysisTask(args, optionsOrCb, cb) {
        const command = new GetVoiceToneAnalysisTaskCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listAvailableVoiceConnectorRegions(args, optionsOrCb, cb) {
        const command = new ListAvailableVoiceConnectorRegionsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listPhoneNumberOrders(args, optionsOrCb, cb) {
        const command = new ListPhoneNumberOrdersCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listPhoneNumbers(args, optionsOrCb, cb) {
        const command = new ListPhoneNumbersCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listProxySessions(args, optionsOrCb, cb) {
        const command = new ListProxySessionsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listSipMediaApplications(args, optionsOrCb, cb) {
        const command = new ListSipMediaApplicationsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listSipRules(args, optionsOrCb, cb) {
        const command = new ListSipRulesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listSupportedPhoneNumberCountries(args, optionsOrCb, cb) {
        const command = new ListSupportedPhoneNumberCountriesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listTagsForResource(args, optionsOrCb, cb) {
        const command = new ListTagsForResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listVoiceConnectorGroups(args, optionsOrCb, cb) {
        const command = new ListVoiceConnectorGroupsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listVoiceConnectors(args, optionsOrCb, cb) {
        const command = new ListVoiceConnectorsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listVoiceConnectorTerminationCredentials(args, optionsOrCb, cb) {
        const command = new ListVoiceConnectorTerminationCredentialsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listVoiceProfileDomains(args, optionsOrCb, cb) {
        const command = new ListVoiceProfileDomainsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    listVoiceProfiles(args, optionsOrCb, cb) {
        const command = new ListVoiceProfilesCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putSipMediaApplicationAlexaSkillConfiguration(args, optionsOrCb, cb) {
        const command = new PutSipMediaApplicationAlexaSkillConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putSipMediaApplicationLoggingConfiguration(args, optionsOrCb, cb) {
        const command = new PutSipMediaApplicationLoggingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorEmergencyCallingConfiguration(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorEmergencyCallingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorLoggingConfiguration(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorLoggingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorOrigination(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorOriginationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorProxy(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorProxyCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorStreamingConfiguration(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorStreamingConfigurationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorTermination(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorTerminationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    putVoiceConnectorTerminationCredentials(args, optionsOrCb, cb) {
        const command = new PutVoiceConnectorTerminationCredentialsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    restorePhoneNumber(args, optionsOrCb, cb) {
        const command = new RestorePhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    searchAvailablePhoneNumbers(args, optionsOrCb, cb) {
        const command = new SearchAvailablePhoneNumbersCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    startSpeakerSearchTask(args, optionsOrCb, cb) {
        const command = new StartSpeakerSearchTaskCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    startVoiceToneAnalysisTask(args, optionsOrCb, cb) {
        const command = new StartVoiceToneAnalysisTaskCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    stopSpeakerSearchTask(args, optionsOrCb, cb) {
        const command = new StopSpeakerSearchTaskCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    stopVoiceToneAnalysisTask(args, optionsOrCb, cb) {
        const command = new StopVoiceToneAnalysisTaskCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    tagResource(args, optionsOrCb, cb) {
        const command = new TagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    untagResource(args, optionsOrCb, cb) {
        const command = new UntagResourceCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateGlobalSettings(args, optionsOrCb, cb) {
        const command = new UpdateGlobalSettingsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updatePhoneNumber(args, optionsOrCb, cb) {
        const command = new UpdatePhoneNumberCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updatePhoneNumberSettings(args, optionsOrCb, cb) {
        const command = new UpdatePhoneNumberSettingsCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateProxySession(args, optionsOrCb, cb) {
        const command = new UpdateProxySessionCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateSipMediaApplication(args, optionsOrCb, cb) {
        const command = new UpdateSipMediaApplicationCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateSipMediaApplicationCall(args, optionsOrCb, cb) {
        const command = new UpdateSipMediaApplicationCallCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateSipRule(args, optionsOrCb, cb) {
        const command = new UpdateSipRuleCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateVoiceConnector(args, optionsOrCb, cb) {
        const command = new UpdateVoiceConnectorCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateVoiceConnectorGroup(args, optionsOrCb, cb) {
        const command = new UpdateVoiceConnectorGroupCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateVoiceProfile(args, optionsOrCb, cb) {
        const command = new UpdateVoiceProfileCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    updateVoiceProfileDomain(args, optionsOrCb, cb) {
        const command = new UpdateVoiceProfileDomainCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
    validateE911Address(args, optionsOrCb, cb) {
        const command = new ValidateE911AddressCommand(args);
        if (typeof optionsOrCb === "function") {
            this.send(command, optionsOrCb);
        }
        else if (typeof cb === "function") {
            if (typeof optionsOrCb !== "object")
                throw new Error(`Expect http options but get ${typeof optionsOrCb}`);
            this.send(command, optionsOrCb || {}, cb);
        }
        else {
            return this.send(command, optionsOrCb);
        }
    }
}
