import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { UpdateSipMediaApplicationCallRequestFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_restJson1UpdateSipMediaApplicationCallCommand, serializeAws_restJson1UpdateSipMediaApplicationCallCommand, } from "../protocols/Aws_restJson1";
export class UpdateSipMediaApplicationCallCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, UpdateSipMediaApplicationCallCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "ChimeSDKVoiceClient";
        const commandName = "UpdateSipMediaApplicationCallCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: UpdateSipMediaApplicationCallRequestFilterSensitiveLog,
            outputFilterSensitiveLog: (_) => _,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_restJson1UpdateSipMediaApplicationCallCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_restJson1UpdateSipMediaApplicationCallCommand(output, context);
    }
}
