import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKVoiceClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKVoiceClient";
import { DeleteVoiceProfileRequest } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link DeleteVoiceProfileCommand}.
 */
export interface DeleteVoiceProfileCommandInput extends DeleteVoiceProfileRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteVoiceProfileCommand}.
 */
export interface DeleteVoiceProfileCommandOutput extends __MetadataBearer {
}
/**
 * @public
 * <p>Deletes a voice profile, including its voice print and enrollment data. WARNING: This action is not reversible.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKVoiceClient, DeleteVoiceProfileCommand } from "@aws-sdk/client-chime-sdk-voice"; // ES Modules import
 * // const { ChimeSDKVoiceClient, DeleteVoiceProfileCommand } = require("@aws-sdk/client-chime-sdk-voice"); // CommonJS import
 * const client = new ChimeSDKVoiceClient(config);
 * const input = { // DeleteVoiceProfileRequest
 *   VoiceProfileId: "STRING_VALUE", // required
 * };
 * const command = new DeleteVoiceProfileCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param DeleteVoiceProfileCommandInput - {@link DeleteVoiceProfileCommandInput}
 * @returns {@link DeleteVoiceProfileCommandOutput}
 * @see {@link DeleteVoiceProfileCommandInput} for command's `input` shape.
 * @see {@link DeleteVoiceProfileCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKVoiceClientResolvedConfig | config} for ChimeSDKVoiceClient's `config` shape.
 *
 * @throws {@link AccessDeniedException} (client fault)
 *  <p>You don't have the permissions needed to run this action.</p>
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ConflictException} (client fault)
 *  <p>Multiple instances of the same request were made simultaneously.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link NotFoundException} (client fault)
 *  <p>The requested resource couldn't be found.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The number of customer requests exceeds the request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client isn't authorized to request a resource.</p>
 *
 *
 */
export declare class DeleteVoiceProfileCommand extends $Command<DeleteVoiceProfileCommandInput, DeleteVoiceProfileCommandOutput, ChimeSDKVoiceClientResolvedConfig> {
    readonly input: DeleteVoiceProfileCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: DeleteVoiceProfileCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKVoiceClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteVoiceProfileCommandInput, DeleteVoiceProfileCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
