import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { ChimeServiceException as __BaseException } from "./ChimeServiceException";
export const ErrorCode = {
    AccessDenied: "AccessDenied",
    BadRequest: "BadRequest",
    Conflict: "Conflict",
    Forbidden: "Forbidden",
    NotFound: "NotFound",
    PhoneNumberAssociationsExist: "PhoneNumberAssociationsExist",
    PreconditionFailed: "PreconditionFailed",
    ResourceLimitExceeded: "ResourceLimitExceeded",
    ServiceFailure: "ServiceFailure",
    ServiceUnavailable: "ServiceUnavailable",
    Throttled: "Throttled",
    Throttling: "Throttling",
    Unauthorized: "Unauthorized",
    Unprocessable: "Unprocessable",
    VoiceConnectorGroupAssociationsExist: "VoiceConnectorGroupAssociationsExist",
};
export class AccessDeniedException extends __BaseException {
    constructor(opts) {
        super({
            name: "AccessDeniedException",
            $fault: "client",
            ...opts,
        });
        this.name = "AccessDeniedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AccessDeniedException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export const AccountStatus = {
    Active: "Active",
    Suspended: "Suspended",
};
export const AccountType = {
    EnterpriseDirectory: "EnterpriseDirectory",
    EnterpriseLWA: "EnterpriseLWA",
    EnterpriseOIDC: "EnterpriseOIDC",
    Team: "Team",
};
export const License = {
    Basic: "Basic",
    Plus: "Plus",
    Pro: "Pro",
    ProTrial: "ProTrial",
};
export const AppInstanceDataType = {
    Channel: "Channel",
    ChannelMessage: "ChannelMessage",
};
export const ChannelMembershipType = {
    DEFAULT: "DEFAULT",
    HIDDEN: "HIDDEN",
};
export const AudioMuxType = {
    AudioOnly: "AudioOnly",
    AudioWithActiveSpeakerVideo: "AudioWithActiveSpeakerVideo",
};
export const ContentMuxType = {
    ContentOnly: "ContentOnly",
};
export const ArtifactsState = {
    Disabled: "Disabled",
    Enabled: "Enabled",
};
export const VideoMuxType = {
    VideoOnly: "VideoOnly",
};
export class BadRequestException extends __BaseException {
    constructor(opts) {
        super({
            name: "BadRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "BadRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, BadRequestException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ForbiddenException extends __BaseException {
    constructor(opts) {
        super({
            name: "ForbiddenException",
            $fault: "client",
            ...opts,
        });
        this.name = "ForbiddenException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ForbiddenException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class NotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "NotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "NotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, NotFoundException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ServiceFailureException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceFailureException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceFailureException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceFailureException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ServiceUnavailableException extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceUnavailableException",
            $fault: "server",
            ...opts,
        });
        this.name = "ServiceUnavailableException";
        this.$fault = "server";
        Object.setPrototypeOf(this, ServiceUnavailableException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ThrottledClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "ThrottledClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "ThrottledClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ThrottledClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class UnauthorizedClientException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnauthorizedClientException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnauthorizedClientException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnauthorizedClientException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export class ResourceLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export const RoomMembershipRole = {
    Administrator: "Administrator",
    Member: "Member",
};
export const PhoneNumberProductType = {
    BusinessCalling: "BusinessCalling",
    SipMediaApplicationDialIn: "SipMediaApplicationDialIn",
    VoiceConnector: "VoiceConnector",
};
export const UserType = {
    PrivateUser: "PrivateUser",
    SharedDevice: "SharedDevice",
};
export const BotType = {
    ChatBot: "ChatBot",
};
export const CallingNameStatus = {
    Unassigned: "Unassigned",
    UpdateFailed: "UpdateFailed",
    UpdateInProgress: "UpdateInProgress",
    UpdateSucceeded: "UpdateSucceeded",
};
export const Capability = {
    SMS: "SMS",
    Voice: "Voice",
};
export const ChannelMode = {
    RESTRICTED: "RESTRICTED",
    UNRESTRICTED: "UNRESTRICTED",
};
export const ChannelPrivacy = {
    PRIVATE: "PRIVATE",
    PUBLIC: "PUBLIC",
};
export const ChannelMessagePersistenceType = {
    NON_PERSISTENT: "NON_PERSISTENT",
    PERSISTENT: "PERSISTENT",
};
export const ChannelMessageType = {
    CONTROL: "CONTROL",
    STANDARD: "STANDARD",
};
export class ConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "ConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ConflictException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export const MediaPipelineSinkType = {
    S3Bucket: "S3Bucket",
};
export const MediaPipelineSourceType = {
    ChimeSdkMeeting: "ChimeSdkMeeting",
};
export const MediaPipelineStatus = {
    Failed: "Failed",
    InProgress: "InProgress",
    Initializing: "Initializing",
    Stopped: "Stopped",
    Stopping: "Stopping",
};
export const OrderedPhoneNumberStatus = {
    Acquired: "Acquired",
    Failed: "Failed",
    Processing: "Processing",
};
export const PhoneNumberOrderStatus = {
    Failed: "Failed",
    Partial: "Partial",
    Processing: "Processing",
    Successful: "Successful",
};
export const GeoMatchLevel = {
    AreaCode: "AreaCode",
    Country: "Country",
};
export const NumberSelectionBehavior = {
    AvoidSticky: "AvoidSticky",
    PreferSticky: "PreferSticky",
};
export const ProxySessionStatus = {
    Closed: "Closed",
    InProgress: "InProgress",
    Open: "Open",
};
export const MemberType = {
    Bot: "Bot",
    User: "User",
    Webhook: "Webhook",
};
export const SipRuleTriggerType = {
    RequestUriHostname: "RequestUriHostname",
    ToPhoneNumber: "ToPhoneNumber",
};
export const InviteStatus = {
    Accepted: "Accepted",
    Failed: "Failed",
    Pending: "Pending",
};
export const RegistrationStatus = {
    Registered: "Registered",
    Suspended: "Suspended",
    Unregistered: "Unregistered",
};
export const VoiceConnectorAwsRegion = {
    US_EAST_1: "us-east-1",
    US_WEST_2: "us-west-2",
};
export class UnprocessableEntityException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnprocessableEntityException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnprocessableEntityException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnprocessableEntityException.prototype);
        this.Code = opts.Code;
        this.Message = opts.Message;
    }
}
export const EmailStatus = {
    Failed: "Failed",
    NotSent: "NotSent",
    Sent: "Sent",
};
export const TranscribeMedicalContentIdentificationType = {
    PHI: "PHI",
};
export const TranscribeMedicalLanguageCode = {
    EN_US: "en-US",
};
export const TranscribeMedicalRegion = {
    AP_SOUTHEAST_2: "ap-southeast-2",
    AUTO: "auto",
    CA_CENTRAL_1: "ca-central-1",
    EU_WEST_1: "eu-west-1",
    US_EAST_1: "us-east-1",
    US_EAST_2: "us-east-2",
    US_WEST_2: "us-west-2",
};
export const TranscribeMedicalSpecialty = {
    Cardiology: "CARDIOLOGY",
    Neurology: "NEUROLOGY",
    Oncology: "ONCOLOGY",
    PrimaryCare: "PRIMARYCARE",
    Radiology: "RADIOLOGY",
    Urology: "UROLOGY",
};
export const TranscribeMedicalType = {
    Conversation: "CONVERSATION",
    Dictation: "DICTATION",
};
export const TranscribeContentIdentificationType = {
    PII: "PII",
};
export const TranscribeContentRedactionType = {
    PII: "PII",
};
export const TranscribeLanguageCode = {
    DE_DE: "de-DE",
    EN_AU: "en-AU",
    EN_GB: "en-GB",
    EN_US: "en-US",
    ES_US: "es-US",
    FR_CA: "fr-CA",
    FR_FR: "fr-FR",
    IT_IT: "it-IT",
    JA_JP: "ja-JP",
    KO_KR: "ko-KR",
    PT_BR: "pt-BR",
    ZH_CN: "zh-CN",
};
export const TranscribePartialResultsStability = {
    HIGH: "high",
    LOW: "low",
    MEDIUM: "medium",
};
export const TranscribeRegion = {
    AP_NORTHEAST_1: "ap-northeast-1",
    AP_NORTHEAST_2: "ap-northeast-2",
    AP_SOUTHEAST_2: "ap-southeast-2",
    AUTO: "auto",
    CA_CENTRAL_1: "ca-central-1",
    EU_CENTRAL_1: "eu-central-1",
    EU_WEST_1: "eu-west-1",
    EU_WEST_2: "eu-west-2",
    SA_EAST_1: "sa-east-1",
    US_EAST_1: "us-east-1",
    US_EAST_2: "us-east-2",
    US_WEST_2: "us-west-2",
};
export const TranscribeVocabularyFilterMethod = {
    Mask: "mask",
    Remove: "remove",
    Tag: "tag",
};
export const PhoneNumberAssociationName = {
    AccountId: "AccountId",
    SipRuleId: "SipRuleId",
    UserId: "UserId",
    VoiceConnectorGroupId: "VoiceConnectorGroupId",
    VoiceConnectorId: "VoiceConnectorId",
};
export const PhoneNumberStatus = {
    AcquireFailed: "AcquireFailed",
    AcquireInProgress: "AcquireInProgress",
    Assigned: "Assigned",
    DeleteFailed: "DeleteFailed",
    DeleteInProgress: "DeleteInProgress",
    ReleaseFailed: "ReleaseFailed",
    ReleaseInProgress: "ReleaseInProgress",
    Unassigned: "Unassigned",
};
export const PhoneNumberType = {
    Local: "Local",
    TollFree: "TollFree",
};
export const AddressFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.streetName && { streetName: SENSITIVE_STRING }),
    ...(obj.streetSuffix && { streetSuffix: SENSITIVE_STRING }),
    ...(obj.postDirectional && { postDirectional: SENSITIVE_STRING }),
    ...(obj.preDirectional && { preDirectional: SENSITIVE_STRING }),
    ...(obj.streetNumber && { streetNumber: SENSITIVE_STRING }),
    ...(obj.city && { city: SENSITIVE_STRING }),
    ...(obj.state && { state: SENSITIVE_STRING }),
    ...(obj.postalCode && { postalCode: SENSITIVE_STRING }),
    ...(obj.postalCodePlus4 && { postalCodePlus4: SENSITIVE_STRING }),
    ...(obj.country && { country: SENSITIVE_STRING }),
});
export const AlexaForBusinessMetadataFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AlexaForBusinessRoomArn && { AlexaForBusinessRoomArn: SENSITIVE_STRING }),
});
export const AppInstanceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const IdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
export const AppInstanceAdminFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Admin && { Admin: IdentityFilterSensitiveLog(obj.Admin) }),
});
export const AppInstanceAdminSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Admin && { Admin: IdentityFilterSensitiveLog(obj.Admin) }),
});
export const AppInstanceSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const AppInstanceStreamingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ResourceArn && { ResourceArn: SENSITIVE_STRING }),
});
export const AppInstanceUserFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const AppInstanceUserSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const AssociatePhoneNumberWithUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumber && { E164PhoneNumber: SENSITIVE_STRING }),
});
export const AttendeeFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: SENSITIVE_STRING }),
    ...(obj.JoinToken && { JoinToken: SENSITIVE_STRING }),
});
export const TagFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Key && { Key: SENSITIVE_STRING }),
    ...(obj.Value && { Value: SENSITIVE_STRING }),
});
export const BatchChannelMembershipsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InvitedBy && { InvitedBy: IdentityFilterSensitiveLog(obj.InvitedBy) }),
    ...(obj.Members && { Members: obj.Members.map((item) => IdentityFilterSensitiveLog(item)) }),
});
export const CreateAttendeeRequestItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const BatchCreateAttendeeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => CreateAttendeeRequestItemFilterSensitiveLog(item)) }),
});
export const CreateAttendeeErrorFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: SENSITIVE_STRING }),
});
export const BatchCreateAttendeeResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => AttendeeFilterSensitiveLog(item)) }),
    ...(obj.Errors && { Errors: obj.Errors.map((item) => CreateAttendeeErrorFilterSensitiveLog(item)) }),
});
export const BatchCreateChannelMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.BatchChannelMemberships && {
        BatchChannelMemberships: BatchChannelMembershipsFilterSensitiveLog(obj.BatchChannelMemberships),
    }),
});
export const UpdatePhoneNumberRequestItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const BatchUpdatePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UpdatePhoneNumberRequestItems && {
        UpdatePhoneNumberRequestItems: obj.UpdatePhoneNumberRequestItems.map((item) => UpdatePhoneNumberRequestItemFilterSensitiveLog(item)),
    }),
});
export const UpdateUserRequestItemFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AlexaForBusinessMetadata && {
        AlexaForBusinessMetadata: AlexaForBusinessMetadataFilterSensitiveLog(obj.AlexaForBusinessMetadata),
    }),
});
export const BatchUpdateUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UpdateUserRequestItems && {
        UpdateUserRequestItems: obj.UpdateUserRequestItems.map((item) => UpdateUserRequestItemFilterSensitiveLog(item)),
    }),
});
export const BotFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DisplayName && { DisplayName: SENSITIVE_STRING }),
    ...(obj.BotEmail && { BotEmail: SENSITIVE_STRING }),
    ...(obj.SecurityToken && { SecurityToken: SENSITIVE_STRING }),
});
export const CandidateAddressFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.streetInfo && { streetInfo: SENSITIVE_STRING }),
    ...(obj.streetNumber && { streetNumber: SENSITIVE_STRING }),
    ...(obj.city && { city: SENSITIVE_STRING }),
    ...(obj.state && { state: SENSITIVE_STRING }),
    ...(obj.postalCode && { postalCode: SENSITIVE_STRING }),
    ...(obj.postalCodePlus4 && { postalCodePlus4: SENSITIVE_STRING }),
    ...(obj.country && { country: SENSITIVE_STRING }),
});
export const ChannelFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.CreatedBy && { CreatedBy: IdentityFilterSensitiveLog(obj.CreatedBy) }),
});
export const ChannelBanFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
    ...(obj.CreatedBy && { CreatedBy: IdentityFilterSensitiveLog(obj.CreatedBy) }),
});
export const ChannelBanSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
});
export const ChannelMembershipFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InvitedBy && { InvitedBy: IdentityFilterSensitiveLog(obj.InvitedBy) }),
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
});
export const ChannelSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelSummary && { ChannelSummary: ChannelSummaryFilterSensitiveLog(obj.ChannelSummary) }),
});
export const ChannelMembershipSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
});
export const ChannelMessageFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Content && { Content: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.Sender && { Sender: IdentityFilterSensitiveLog(obj.Sender) }),
});
export const ChannelMessageSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Content && { Content: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.Sender && { Sender: IdentityFilterSensitiveLog(obj.Sender) }),
});
export const ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelSummary && { ChannelSummary: ChannelSummaryFilterSensitiveLog(obj.ChannelSummary) }),
});
export const ChannelModeratorFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Moderator && { Moderator: IdentityFilterSensitiveLog(obj.Moderator) }),
    ...(obj.CreatedBy && { CreatedBy: IdentityFilterSensitiveLog(obj.CreatedBy) }),
});
export const ChannelModeratorSummaryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Moderator && { Moderator: IdentityFilterSensitiveLog(obj.Moderator) }),
});
export const SelectedVideoStreamsFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserIds && { ExternalUserIds: SENSITIVE_STRING }),
});
export const SourceConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SelectedVideoStreams && {
        SelectedVideoStreams: SelectedVideoStreamsFilterSensitiveLog(obj.SelectedVideoStreams),
    }),
});
export const ChimeSdkMeetingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceConfiguration && {
        SourceConfiguration: SourceConfigurationFilterSensitiveLog(obj.SourceConfiguration),
    }),
});
export const CreateAppInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const CreateAppInstanceAdminResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceAdmin && { AppInstanceAdmin: IdentityFilterSensitiveLog(obj.AppInstanceAdmin) }),
});
export const CreateAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUserId && { AppInstanceUserId: SENSITIVE_STRING }),
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const CreateAttendeeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalUserId && { ExternalUserId: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const CreateAttendeeResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendee && { Attendee: AttendeeFilterSensitiveLog(obj.Attendee) }),
});
export const CreateBotRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DisplayName && { DisplayName: SENSITIVE_STRING }),
});
export const CreateBotResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Bot && { Bot: BotFilterSensitiveLog(obj.Bot) }),
});
export const CreateChannelRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const CreateChannelBanResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
});
export const CreateChannelMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: IdentityFilterSensitiveLog(obj.Member) }),
});
export const CreateChannelModeratorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelModerator && { ChannelModerator: IdentityFilterSensitiveLog(obj.ChannelModerator) }),
});
export const CreateMediaCapturePipelineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceArn && { SourceArn: SENSITIVE_STRING }),
    ...(obj.SinkArn && { SinkArn: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.ChimeSdkMeetingConfiguration && {
        ChimeSdkMeetingConfiguration: ChimeSdkMeetingConfigurationFilterSensitiveLog(obj.ChimeSdkMeetingConfiguration),
    }),
});
export const MediaCapturePipelineFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SourceArn && { SourceArn: SENSITIVE_STRING }),
    ...(obj.SinkArn && { SinkArn: SENSITIVE_STRING }),
    ...(obj.ChimeSdkMeetingConfiguration && {
        ChimeSdkMeetingConfiguration: ChimeSdkMeetingConfigurationFilterSensitiveLog(obj.ChimeSdkMeetingConfiguration),
    }),
});
export const CreateMediaCapturePipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: MediaCapturePipelineFilterSensitiveLog(obj.MediaCapturePipeline),
    }),
});
export const MeetingNotificationConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SnsTopicArn && { SnsTopicArn: SENSITIVE_STRING }),
    ...(obj.SqsQueueArn && { SqsQueueArn: SENSITIVE_STRING }),
});
export const CreateMeetingRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.ExternalMeetingId && { ExternalMeetingId: SENSITIVE_STRING }),
    ...(obj.MeetingHostId && { MeetingHostId: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
    ...(obj.NotificationsConfiguration && {
        NotificationsConfiguration: MeetingNotificationConfigurationFilterSensitiveLog(obj.NotificationsConfiguration),
    }),
});
export const MeetingFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ExternalMeetingId && { ExternalMeetingId: SENSITIVE_STRING }),
});
export const CreateMeetingResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Meeting && { Meeting: MeetingFilterSensitiveLog(obj.Meeting) }),
});
export const CreateMeetingDialOutRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FromPhoneNumber && { FromPhoneNumber: SENSITIVE_STRING }),
    ...(obj.ToPhoneNumber && { ToPhoneNumber: SENSITIVE_STRING }),
    ...(obj.JoinToken && { JoinToken: SENSITIVE_STRING }),
});
export const CreateMeetingWithAttendeesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
    ...(obj.ExternalMeetingId && { ExternalMeetingId: SENSITIVE_STRING }),
    ...(obj.MeetingHostId && { MeetingHostId: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
    ...(obj.NotificationsConfiguration && {
        NotificationsConfiguration: MeetingNotificationConfigurationFilterSensitiveLog(obj.NotificationsConfiguration),
    }),
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => CreateAttendeeRequestItemFilterSensitiveLog(item)) }),
});
export const CreateMeetingWithAttendeesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Meeting && { Meeting: MeetingFilterSensitiveLog(obj.Meeting) }),
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => AttendeeFilterSensitiveLog(item)) }),
    ...(obj.Errors && { Errors: obj.Errors.map((item) => CreateAttendeeErrorFilterSensitiveLog(item)) }),
});
export const CreatePhoneNumberOrderRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const OrderedPhoneNumberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumber && { E164PhoneNumber: SENSITIVE_STRING }),
});
export const PhoneNumberOrderFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OrderedPhoneNumbers && {
        OrderedPhoneNumbers: obj.OrderedPhoneNumbers.map((item) => OrderedPhoneNumberFilterSensitiveLog(item)),
    }),
});
export const CreatePhoneNumberOrderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberOrder && { PhoneNumberOrder: PhoneNumberOrderFilterSensitiveLog(obj.PhoneNumberOrder) }),
});
export const CreateProxySessionRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ParticipantPhoneNumbers && { ParticipantPhoneNumbers: SENSITIVE_STRING }),
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
export const ParticipantFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: SENSITIVE_STRING }),
    ...(obj.ProxyPhoneNumber && { ProxyPhoneNumber: SENSITIVE_STRING }),
});
export const ProxySessionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Participants && { Participants: obj.Participants.map((item) => ParticipantFilterSensitiveLog(item)) }),
});
export const CreateProxySessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ProxySession && { ProxySession: ProxySessionFilterSensitiveLog(obj.ProxySession) }),
});
export const CreateRoomRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
});
export const RoomFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
export const CreateRoomResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Room && { Room: RoomFilterSensitiveLog(obj.Room) }),
});
export const MemberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Email && { Email: SENSITIVE_STRING }),
    ...(obj.FullName && { FullName: SENSITIVE_STRING }),
});
export const RoomMembershipFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Member && { Member: MemberFilterSensitiveLog(obj.Member) }),
});
export const CreateRoomMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RoomMembership && { RoomMembership: RoomMembershipFilterSensitiveLog(obj.RoomMembership) }),
});
export const SipMediaApplicationEndpointFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.LambdaArn && { LambdaArn: SENSITIVE_STRING }),
});
export const CreateSipMediaApplicationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Endpoints && { Endpoints: obj.Endpoints.map((item) => SipMediaApplicationEndpointFilterSensitiveLog(item)) }),
});
export const SipMediaApplicationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Endpoints && { Endpoints: obj.Endpoints.map((item) => SipMediaApplicationEndpointFilterSensitiveLog(item)) }),
});
export const CreateSipMediaApplicationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplication && {
        SipMediaApplication: SipMediaApplicationFilterSensitiveLog(obj.SipMediaApplication),
    }),
});
export const CreateSipMediaApplicationCallRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FromPhoneNumber && { FromPhoneNumber: SENSITIVE_STRING }),
    ...(obj.ToPhoneNumber && { ToPhoneNumber: SENSITIVE_STRING }),
    ...(obj.SipHeaders && { SipHeaders: SENSITIVE_STRING }),
});
export const CreateUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Email && { Email: SENSITIVE_STRING }),
});
export const UserFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PrimaryEmail && { PrimaryEmail: SENSITIVE_STRING }),
    ...(obj.PrimaryProvisionedNumber && { PrimaryProvisionedNumber: SENSITIVE_STRING }),
    ...(obj.DisplayName && { DisplayName: SENSITIVE_STRING }),
    ...(obj.AlexaForBusinessMetadata && {
        AlexaForBusinessMetadata: AlexaForBusinessMetadataFilterSensitiveLog(obj.AlexaForBusinessMetadata),
    }),
});
export const CreateUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.User && { User: UserFilterSensitiveLog(obj.User) }),
});
export const CredentialFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Username && { Username: SENSITIVE_STRING }),
    ...(obj.Password && { Password: SENSITIVE_STRING }),
});
export const DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Usernames && { Usernames: SENSITIVE_STRING }),
});
export const DescribeAppInstanceResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstance && { AppInstance: AppInstanceFilterSensitiveLog(obj.AppInstance) }),
});
export const DescribeAppInstanceAdminResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceAdmin && { AppInstanceAdmin: AppInstanceAdminFilterSensitiveLog(obj.AppInstanceAdmin) }),
});
export const DescribeAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUser && { AppInstanceUser: AppInstanceUserFilterSensitiveLog(obj.AppInstanceUser) }),
});
export const DescribeChannelResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Channel && { Channel: ChannelFilterSensitiveLog(obj.Channel) }),
});
export const DescribeChannelBanResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelBan && { ChannelBan: ChannelBanFilterSensitiveLog(obj.ChannelBan) }),
});
export const DescribeChannelMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMembership && { ChannelMembership: ChannelMembershipFilterSensitiveLog(obj.ChannelMembership) }),
});
export const DescribeChannelMembershipForAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMembership && {
        ChannelMembership: ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog(obj.ChannelMembership),
    }),
});
export const DescribeChannelModeratedByAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Channel && { Channel: ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog(obj.Channel) }),
});
export const DescribeChannelModeratorResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelModerator && { ChannelModerator: ChannelModeratorFilterSensitiveLog(obj.ChannelModerator) }),
});
export const DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const DNISEmergencyCallingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmergencyPhoneNumber && { EmergencyPhoneNumber: SENSITIVE_STRING }),
    ...(obj.TestPhoneNumber && { TestPhoneNumber: SENSITIVE_STRING }),
});
export const EmergencyCallingConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DNIS && { DNIS: obj.DNIS.map((item) => DNISEmergencyCallingConfigurationFilterSensitiveLog(item)) }),
});
export const EventsConfigurationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OutboundEventsHTTPSEndpoint && { OutboundEventsHTTPSEndpoint: SENSITIVE_STRING }),
    ...(obj.LambdaFunctionArn && { LambdaFunctionArn: SENSITIVE_STRING }),
});
export const GetAppInstanceStreamingConfigurationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceStreamingConfigurations && {
        AppInstanceStreamingConfigurations: obj.AppInstanceStreamingConfigurations.map((item) => AppInstanceStreamingConfigurationFilterSensitiveLog(item)),
    }),
});
export const GetAttendeeResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendee && { Attendee: AttendeeFilterSensitiveLog(obj.Attendee) }),
});
export const GetBotResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Bot && { Bot: BotFilterSensitiveLog(obj.Bot) }),
});
export const GetChannelMessageResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMessage && { ChannelMessage: ChannelMessageFilterSensitiveLog(obj.ChannelMessage) }),
});
export const GetEventsConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EventsConfiguration && {
        EventsConfiguration: EventsConfigurationFilterSensitiveLog(obj.EventsConfiguration),
    }),
});
export const GetMediaCapturePipelineResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipeline && {
        MediaCapturePipeline: MediaCapturePipelineFilterSensitiveLog(obj.MediaCapturePipeline),
    }),
});
export const GetMeetingResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Meeting && { Meeting: MeetingFilterSensitiveLog(obj.Meeting) }),
});
export const PhoneNumberFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumber && { E164PhoneNumber: SENSITIVE_STRING }),
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const GetPhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: PhoneNumberFilterSensitiveLog(obj.PhoneNumber) }),
});
export const GetPhoneNumberOrderResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumberOrder && { PhoneNumberOrder: PhoneNumberOrderFilterSensitiveLog(obj.PhoneNumberOrder) }),
});
export const GetPhoneNumberSettingsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const GetProxySessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ProxySession && { ProxySession: ProxySessionFilterSensitiveLog(obj.ProxySession) }),
});
