import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeClient";
import { StartMeetingTranscriptionRequest, StartMeetingTranscriptionResponse } from "../models/models_1";
/**
 * @public
 *
 * The input for {@link StartMeetingTranscriptionCommand}.
 */
export interface StartMeetingTranscriptionCommandInput extends StartMeetingTranscriptionRequest {
}
/**
 * @public
 *
 * The output of {@link StartMeetingTranscriptionCommand}.
 */
export interface StartMeetingTranscriptionCommandOutput extends StartMeetingTranscriptionResponse, __MetadataBearer {
}
/**
 * @public
 * <p>Starts transcription for the specified <code>meetingId</code>. </p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeClient, StartMeetingTranscriptionCommand } from "@aws-sdk/client-chime"; // ES Modules import
 * // const { ChimeClient, StartMeetingTranscriptionCommand } = require("@aws-sdk/client-chime"); // CommonJS import
 * const client = new ChimeClient(config);
 * const input = { // StartMeetingTranscriptionRequest
 *   MeetingId: "STRING_VALUE", // required
 *   TranscriptionConfiguration: { // TranscriptionConfiguration
 *     EngineTranscribeSettings: { // EngineTranscribeSettings
 *       LanguageCode: "STRING_VALUE", // required
 *       VocabularyFilterMethod: "STRING_VALUE",
 *       VocabularyFilterName: "STRING_VALUE",
 *       VocabularyName: "STRING_VALUE",
 *       Region: "STRING_VALUE",
 *       EnablePartialResultsStabilization: true || false,
 *       PartialResultsStability: "STRING_VALUE",
 *       ContentIdentificationType: "STRING_VALUE",
 *       ContentRedactionType: "STRING_VALUE",
 *       PiiEntityTypes: "STRING_VALUE",
 *       LanguageModelName: "STRING_VALUE",
 *     },
 *     EngineTranscribeMedicalSettings: { // EngineTranscribeMedicalSettings
 *       LanguageCode: "STRING_VALUE", // required
 *       Specialty: "STRING_VALUE", // required
 *       Type: "STRING_VALUE", // required
 *       VocabularyName: "STRING_VALUE",
 *       Region: "STRING_VALUE",
 *       ContentIdentificationType: "STRING_VALUE",
 *     },
 *   },
 * };
 * const command = new StartMeetingTranscriptionCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param StartMeetingTranscriptionCommandInput - {@link StartMeetingTranscriptionCommandInput}
 * @returns {@link StartMeetingTranscriptionCommandOutput}
 * @see {@link StartMeetingTranscriptionCommandInput} for command's `input` shape.
 * @see {@link StartMeetingTranscriptionCommandOutput} for command's `response` shape.
 * @see {@link ChimeClientResolvedConfig | config} for ChimeClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link NotFoundException} (client fault)
 *  <p>One or more of the resources in the request does not exist in the system.</p>
 *
 * @throws {@link ResourceLimitExceededException} (client fault)
 *  <p>The request exceeds the resource limit.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 * @throws {@link UnprocessableEntityException} (client fault)
 *  <p>The request was well-formed but was unable to be followed due to semantic errors.</p>
 *
 *
 */
export declare class StartMeetingTranscriptionCommand extends $Command<StartMeetingTranscriptionCommandInput, StartMeetingTranscriptionCommandOutput, ChimeClientResolvedConfig> {
    readonly input: StartMeetingTranscriptionCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: StartMeetingTranscriptionCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeClientResolvedConfig, options?: __HttpHandlerOptions): Handler<StartMeetingTranscriptionCommandInput, StartMeetingTranscriptionCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
