import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@aws-sdk/types";
import {
  ChimeClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../ChimeClient";
import {
  RestorePhoneNumberRequest,
  RestorePhoneNumberResponse,
} from "../models/models_1";
export interface RestorePhoneNumberCommandInput
  extends RestorePhoneNumberRequest {}
export interface RestorePhoneNumberCommandOutput
  extends RestorePhoneNumberResponse,
    __MetadataBearer {}
export declare class RestorePhoneNumberCommand extends $Command<
  RestorePhoneNumberCommandInput,
  RestorePhoneNumberCommandOutput,
  ChimeClientResolvedConfig
> {
  readonly input: RestorePhoneNumberCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: RestorePhoneNumberCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: ChimeClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<RestorePhoneNumberCommandInput, RestorePhoneNumberCommandOutput>;
  private serialize;
  private deserialize;
}
