import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export const ResourceTypeForTagging = {
    ASSOCIATION: "Association",
    AUTOMATION: "Automation",
    DOCUMENT: "Document",
    MAINTENANCE_WINDOW: "MaintenanceWindow",
    MANAGED_INSTANCE: "ManagedInstance",
    OPSMETADATA: "OpsMetadata",
    OPS_ITEM: "OpsItem",
    PARAMETER: "Parameter",
    PATCH_BASELINE: "PatchBaseline",
};
export class InternalServerError extends __BaseException {
    constructor(opts) {
        super({
            name: "InternalServerError",
            $fault: "server",
            ...opts,
        });
        this.name = "InternalServerError";
        this.$fault = "server";
        Object.setPrototypeOf(this, InternalServerError.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidResourceId extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidResourceId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResourceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResourceId.prototype);
    }
}
export class InvalidResourceType extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidResourceType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResourceType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResourceType.prototype);
    }
}
export class TooManyTagsError extends __BaseException {
    constructor(opts) {
        super({
            name: "TooManyTagsError",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyTagsError";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyTagsError.prototype);
    }
}
export class TooManyUpdates extends __BaseException {
    constructor(opts) {
        super({
            name: "TooManyUpdates",
            $fault: "client",
            ...opts,
        });
        this.name = "TooManyUpdates";
        this.$fault = "client";
        Object.setPrototypeOf(this, TooManyUpdates.prototype);
        this.Message = opts.Message;
    }
}
export const ExternalAlarmState = {
    ALARM: "ALARM",
    UNKNOWN: "UNKNOWN",
};
export class AlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "AlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "AlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
export class OpsItemInvalidParameterException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemInvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemInvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemInvalidParameterException.prototype);
        this.ParameterNames = opts.ParameterNames;
        this.Message = opts.Message;
    }
}
export class OpsItemLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemLimitExceededException.prototype);
        this.ResourceTypes = opts.ResourceTypes;
        this.Limit = opts.Limit;
        this.LimitType = opts.LimitType;
        this.Message = opts.Message;
    }
}
export class OpsItemNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class OpsItemRelatedItemAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemRelatedItemAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemRelatedItemAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemRelatedItemAlreadyExistsException.prototype);
        this.Message = opts.Message;
        this.ResourceUri = opts.ResourceUri;
        this.OpsItemId = opts.OpsItemId;
    }
}
export class DuplicateInstanceId extends __BaseException {
    constructor(opts) {
        super({
            name: "DuplicateInstanceId",
            $fault: "client",
            ...opts,
        });
        this.name = "DuplicateInstanceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, DuplicateInstanceId.prototype);
    }
}
export class InvalidCommandId extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidCommandId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidCommandId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidCommandId.prototype);
    }
}
export class InvalidInstanceId extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInstanceId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceId.prototype);
        this.Message = opts.Message;
    }
}
export class DoesNotExistException extends __BaseException {
    constructor(opts) {
        super({
            name: "DoesNotExistException",
            $fault: "client",
            ...opts,
        });
        this.name = "DoesNotExistException";
        this.$fault = "client";
        Object.setPrototypeOf(this, DoesNotExistException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidParameters extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidParameters",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidParameters";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidParameters.prototype);
        this.Message = opts.Message;
    }
}
export class AssociationAlreadyExists extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociationAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationAlreadyExists.prototype);
    }
}
export class AssociationLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociationLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationLimitExceeded.prototype);
    }
}
export const AssociationComplianceSeverity = {
    Critical: "CRITICAL",
    High: "HIGH",
    Low: "LOW",
    Medium: "MEDIUM",
    Unspecified: "UNSPECIFIED",
};
export const AssociationSyncCompliance = {
    Auto: "AUTO",
    Manual: "MANUAL",
};
export const AssociationStatusName = {
    Failed: "Failed",
    Pending: "Pending",
    Success: "Success",
};
export class InvalidDocument extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocument",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocument";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocument.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidDocumentVersion extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocumentVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentVersion.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidOutputLocation extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidOutputLocation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOutputLocation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOutputLocation.prototype);
    }
}
export class InvalidSchedule extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidSchedule",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidSchedule";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidSchedule.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidTag extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTag",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTag";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTag.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidTarget extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTarget",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTarget";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTarget.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidTargetMaps extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTargetMaps",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTargetMaps";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTargetMaps.prototype);
        this.Message = opts.Message;
    }
}
export class UnsupportedPlatformType extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedPlatformType",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedPlatformType";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedPlatformType.prototype);
        this.Message = opts.Message;
    }
}
export const Fault = {
    Client: "Client",
    Server: "Server",
    Unknown: "Unknown",
};
export const AttachmentsSourceKey = {
    AttachmentReference: "AttachmentReference",
    S3FileUrl: "S3FileUrl",
    SourceUrl: "SourceUrl",
};
export const DocumentFormat = {
    JSON: "JSON",
    TEXT: "TEXT",
    YAML: "YAML",
};
export const DocumentType = {
    ApplicationConfiguration: "ApplicationConfiguration",
    ApplicationConfigurationSchema: "ApplicationConfigurationSchema",
    Automation: "Automation",
    ChangeCalendar: "ChangeCalendar",
    ChangeTemplate: "Automation.ChangeTemplate",
    CloudFormation: "CloudFormation",
    Command: "Command",
    ConformancePackTemplate: "ConformancePackTemplate",
    DeploymentStrategy: "DeploymentStrategy",
    Package: "Package",
    Policy: "Policy",
    ProblemAnalysis: "ProblemAnalysis",
    ProblemAnalysisTemplate: "ProblemAnalysisTemplate",
    QuickSetup: "QuickSetup",
    Session: "Session",
};
export const DocumentHashType = {
    SHA1: "Sha1",
    SHA256: "Sha256",
};
export const DocumentParameterType = {
    String: "String",
    StringList: "StringList",
};
export const PlatformType = {
    LINUX: "Linux",
    MACOS: "MacOS",
    WINDOWS: "Windows",
};
export const ReviewStatus = {
    APPROVED: "APPROVED",
    NOT_REVIEWED: "NOT_REVIEWED",
    PENDING: "PENDING",
    REJECTED: "REJECTED",
};
export const DocumentStatus = {
    Active: "Active",
    Creating: "Creating",
    Deleting: "Deleting",
    Failed: "Failed",
    Updating: "Updating",
};
export class DocumentAlreadyExists extends __BaseException {
    constructor(opts) {
        super({
            name: "DocumentAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentAlreadyExists.prototype);
        this.Message = opts.Message;
    }
}
export class DocumentLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "DocumentLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentLimitExceeded.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidDocumentContent extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocumentContent",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentContent";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentContent.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidDocumentSchemaVersion extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocumentSchemaVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentSchemaVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentSchemaVersion.prototype);
        this.Message = opts.Message;
    }
}
export class MaxDocumentSizeExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "MaxDocumentSizeExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "MaxDocumentSizeExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, MaxDocumentSizeExceeded.prototype);
        this.Message = opts.Message;
    }
}
export class IdempotentParameterMismatch extends __BaseException {
    constructor(opts) {
        super({
            name: "IdempotentParameterMismatch",
            $fault: "client",
            ...opts,
        });
        this.name = "IdempotentParameterMismatch";
        this.$fault = "client";
        Object.setPrototypeOf(this, IdempotentParameterMismatch.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export const OpsItemDataType = {
    SEARCHABLE_STRING: "SearchableString",
    STRING: "String",
};
export class OpsItemAccessDeniedException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemAccessDeniedException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemAccessDeniedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemAccessDeniedException.prototype);
        this.Message = opts.Message;
    }
}
export class OpsItemAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemAlreadyExistsException.prototype);
        this.Message = opts.Message;
        this.OpsItemId = opts.OpsItemId;
    }
}
export class OpsMetadataAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsMetadataAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataAlreadyExistsException.prototype);
    }
}
export class OpsMetadataInvalidArgumentException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsMetadataInvalidArgumentException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataInvalidArgumentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataInvalidArgumentException.prototype);
    }
}
export class OpsMetadataLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsMetadataLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataLimitExceededException.prototype);
    }
}
export class OpsMetadataTooManyUpdatesException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsMetadataTooManyUpdatesException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataTooManyUpdatesException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataTooManyUpdatesException.prototype);
    }
}
export const PatchComplianceLevel = {
    Critical: "CRITICAL",
    High: "HIGH",
    Informational: "INFORMATIONAL",
    Low: "LOW",
    Medium: "MEDIUM",
    Unspecified: "UNSPECIFIED",
};
export const PatchFilterKey = {
    AdvisoryId: "ADVISORY_ID",
    Arch: "ARCH",
    BugzillaId: "BUGZILLA_ID",
    CVEId: "CVE_ID",
    Classification: "CLASSIFICATION",
    Epoch: "EPOCH",
    MsrcSeverity: "MSRC_SEVERITY",
    Name: "NAME",
    PatchId: "PATCH_ID",
    PatchSet: "PATCH_SET",
    Priority: "PRIORITY",
    Product: "PRODUCT",
    ProductFamily: "PRODUCT_FAMILY",
    Release: "RELEASE",
    Repository: "REPOSITORY",
    Section: "SECTION",
    Security: "SECURITY",
    Severity: "SEVERITY",
    Version: "VERSION",
};
export const OperatingSystem = {
    AlmaLinux: "ALMA_LINUX",
    AmazonLinux: "AMAZON_LINUX",
    AmazonLinux2: "AMAZON_LINUX_2",
    AmazonLinux2022: "AMAZON_LINUX_2022",
    AmazonLinux2023: "AMAZON_LINUX_2023",
    CentOS: "CENTOS",
    Debian: "DEBIAN",
    MacOS: "MACOS",
    OracleLinux: "ORACLE_LINUX",
    Raspbian: "RASPBIAN",
    RedhatEnterpriseLinux: "REDHAT_ENTERPRISE_LINUX",
    Rocky_Linux: "ROCKY_LINUX",
    Suse: "SUSE",
    Ubuntu: "UBUNTU",
    Windows: "WINDOWS",
};
export const PatchAction = {
    AllowAsDependency: "ALLOW_AS_DEPENDENCY",
    Block: "BLOCK",
};
export const ResourceDataSyncS3Format = {
    JSON_SERDE: "JsonSerDe",
};
export class ResourceDataSyncAlreadyExistsException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncAlreadyExistsException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncAlreadyExistsException.prototype);
        this.SyncName = opts.SyncName;
    }
}
export class ResourceDataSyncCountExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncCountExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncCountExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncCountExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceDataSyncInvalidConfigurationException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncInvalidConfigurationException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncInvalidConfigurationException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncInvalidConfigurationException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidActivation extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidActivation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidActivation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidActivation.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidActivationId extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidActivationId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidActivationId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidActivationId.prototype);
        this.Message = opts.Message;
    }
}
export class AssociationDoesNotExist extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociationDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationDoesNotExist.prototype);
        this.Message = opts.Message;
    }
}
export class AssociatedInstances extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociatedInstances",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociatedInstances";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociatedInstances.prototype);
    }
}
export class InvalidDocumentOperation extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocumentOperation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentOperation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentOperation.prototype);
        this.Message = opts.Message;
    }
}
export const InventorySchemaDeleteOption = {
    DELETE_SCHEMA: "DeleteSchema",
    DISABLE_SCHEMA: "DisableSchema",
};
export class InvalidDeleteInventoryParametersException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeleteInventoryParametersException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeleteInventoryParametersException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeleteInventoryParametersException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidInventoryRequestException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInventoryRequestException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryRequestException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryRequestException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidOptionException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidOptionException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOptionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOptionException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidTypeNameException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidTypeNameException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidTypeNameException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidTypeNameException.prototype);
        this.Message = opts.Message;
    }
}
export class OpsMetadataNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsMetadataNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsMetadataNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsMetadataNotFoundException.prototype);
    }
}
export class ParameterNotFound extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterNotFound.prototype);
    }
}
export class ResourceInUseException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceInUseException.prototype);
        this.Message = opts.Message;
    }
}
export class ResourceDataSyncNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourceDataSyncNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourceDataSyncNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourceDataSyncNotFoundException.prototype);
        this.SyncName = opts.SyncName;
        this.SyncType = opts.SyncType;
        this.Message = opts.Message;
    }
}
export class ResourcePolicyConflictException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourcePolicyConflictException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyConflictException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyConflictException.prototype);
        this.Message = opts.Message;
    }
}
export class ResourcePolicyInvalidParameterException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourcePolicyInvalidParameterException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyInvalidParameterException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyInvalidParameterException.prototype);
        this.ParameterNames = opts.ParameterNames;
        this.Message = opts.Message;
    }
}
export class TargetInUseException extends __BaseException {
    constructor(opts) {
        super({
            name: "TargetInUseException",
            $fault: "client",
            ...opts,
        });
        this.name = "TargetInUseException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TargetInUseException.prototype);
        this.Message = opts.Message;
    }
}
export const DescribeActivationsFilterKeys = {
    ACTIVATION_IDS: "ActivationIds",
    DEFAULT_INSTANCE_NAME: "DefaultInstanceName",
    IAM_ROLE: "IamRole",
};
export class InvalidFilter extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidFilter",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilter";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilter.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidNextToken extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidNextToken",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNextToken";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNextToken.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidAssociationVersion extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAssociationVersion",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAssociationVersion";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAssociationVersion.prototype);
        this.Message = opts.Message;
    }
}
export const AssociationExecutionFilterKey = {
    CreatedTime: "CreatedTime",
    ExecutionId: "ExecutionId",
    Status: "Status",
};
export const AssociationFilterOperatorType = {
    Equal: "EQUAL",
    GreaterThan: "GREATER_THAN",
    LessThan: "LESS_THAN",
};
export class AssociationExecutionDoesNotExist extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociationExecutionDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationExecutionDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationExecutionDoesNotExist.prototype);
        this.Message = opts.Message;
    }
}
export const AssociationExecutionTargetsFilterKey = {
    ResourceId: "ResourceId",
    ResourceType: "ResourceType",
    Status: "Status",
};
export const AutomationExecutionFilterKey = {
    AUTOMATION_SUBTYPE: "AutomationSubtype",
    AUTOMATION_TYPE: "AutomationType",
    CURRENT_ACTION: "CurrentAction",
    DOCUMENT_NAME_PREFIX: "DocumentNamePrefix",
    EXECUTION_ID: "ExecutionId",
    EXECUTION_STATUS: "ExecutionStatus",
    OPS_ITEM_ID: "OpsItemId",
    PARENT_EXECUTION_ID: "ParentExecutionId",
    START_TIME_AFTER: "StartTimeAfter",
    START_TIME_BEFORE: "StartTimeBefore",
    TAG_KEY: "TagKey",
    TARGET_RESOURCE_GROUP: "TargetResourceGroup",
};
export const AutomationExecutionStatus = {
    APPROVED: "Approved",
    CANCELLED: "Cancelled",
    CANCELLING: "Cancelling",
    CHANGE_CALENDAR_OVERRIDE_APPROVED: "ChangeCalendarOverrideApproved",
    CHANGE_CALENDAR_OVERRIDE_REJECTED: "ChangeCalendarOverrideRejected",
    COMPLETED_WITH_FAILURE: "CompletedWithFailure",
    COMPLETED_WITH_SUCCESS: "CompletedWithSuccess",
    FAILED: "Failed",
    INPROGRESS: "InProgress",
    PENDING: "Pending",
    PENDING_APPROVAL: "PendingApproval",
    PENDING_CHANGE_CALENDAR_OVERRIDE: "PendingChangeCalendarOverride",
    REJECTED: "Rejected",
    RUNBOOK_INPROGRESS: "RunbookInProgress",
    SCHEDULED: "Scheduled",
    SUCCESS: "Success",
    TIMEDOUT: "TimedOut",
    WAITING: "Waiting",
};
export const AutomationSubtype = {
    ChangeRequest: "ChangeRequest",
};
export const AutomationType = {
    CrossAccount: "CrossAccount",
    Local: "Local",
};
export const ExecutionMode = {
    Auto: "Auto",
    Interactive: "Interactive",
};
export class InvalidFilterKey extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidFilterKey",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterKey";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterKey.prototype);
    }
}
export class InvalidFilterValue extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidFilterValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterValue.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationExecutionNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationExecutionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationExecutionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationExecutionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const StepExecutionFilterKey = {
    ACTION: "Action",
    START_TIME_AFTER: "StartTimeAfter",
    START_TIME_BEFORE: "StartTimeBefore",
    STEP_EXECUTION_ID: "StepExecutionId",
    STEP_EXECUTION_STATUS: "StepExecutionStatus",
    STEP_NAME: "StepName",
};
export const DocumentPermissionType = {
    SHARE: "Share",
};
export class InvalidPermissionType extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidPermissionType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPermissionType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPermissionType.prototype);
        this.Message = opts.Message;
    }
}
export const PatchDeploymentStatus = {
    Approved: "APPROVED",
    ExplicitApproved: "EXPLICIT_APPROVED",
    ExplicitRejected: "EXPLICIT_REJECTED",
    PendingApproval: "PENDING_APPROVAL",
};
export class UnsupportedOperatingSystem extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedOperatingSystem",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedOperatingSystem";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedOperatingSystem.prototype);
        this.Message = opts.Message;
    }
}
export const InstanceInformationFilterKey = {
    ACTIVATION_IDS: "ActivationIds",
    AGENT_VERSION: "AgentVersion",
    ASSOCIATION_STATUS: "AssociationStatus",
    IAM_ROLE: "IamRole",
    INSTANCE_IDS: "InstanceIds",
    PING_STATUS: "PingStatus",
    PLATFORM_TYPES: "PlatformTypes",
    RESOURCE_TYPE: "ResourceType",
};
export const PingStatus = {
    CONNECTION_LOST: "ConnectionLost",
    INACTIVE: "Inactive",
    ONLINE: "Online",
};
export const ResourceType = {
    DOCUMENT: "Document",
    EC2_INSTANCE: "EC2Instance",
    MANAGED_INSTANCE: "ManagedInstance",
};
export const SourceType = {
    AWS_EC2_INSTANCE: "AWS::EC2::Instance",
    AWS_IOT_THING: "AWS::IoT::Thing",
    AWS_SSM_MANAGEDINSTANCE: "AWS::SSM::ManagedInstance",
};
export class InvalidInstanceInformationFilterValue extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInstanceInformationFilterValue",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInstanceInformationFilterValue";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInstanceInformationFilterValue.prototype);
    }
}
export const PatchComplianceDataState = {
    Failed: "FAILED",
    Installed: "INSTALLED",
    InstalledOther: "INSTALLED_OTHER",
    InstalledPendingReboot: "INSTALLED_PENDING_REBOOT",
    InstalledRejected: "INSTALLED_REJECTED",
    Missing: "MISSING",
    NotApplicable: "NOT_APPLICABLE",
};
export const PatchOperationType = {
    INSTALL: "Install",
    SCAN: "Scan",
};
export const RebootOption = {
    NO_REBOOT: "NoReboot",
    REBOOT_IF_NEEDED: "RebootIfNeeded",
};
export const InstancePatchStateOperatorType = {
    EQUAL: "Equal",
    GREATER_THAN: "GreaterThan",
    LESS_THAN: "LessThan",
    NOT_EQUAL: "NotEqual",
};
export const InventoryDeletionStatus = {
    COMPLETE: "Complete",
    IN_PROGRESS: "InProgress",
};
export class InvalidDeletionIdException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDeletionIdException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDeletionIdException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDeletionIdException.prototype);
        this.Message = opts.Message;
    }
}
export const MaintenanceWindowExecutionStatus = {
    Cancelled: "CANCELLED",
    Cancelling: "CANCELLING",
    Failed: "FAILED",
    InProgress: "IN_PROGRESS",
    Pending: "PENDING",
    SkippedOverlapping: "SKIPPED_OVERLAPPING",
    Success: "SUCCESS",
    TimedOut: "TIMED_OUT",
};
export const MaintenanceWindowTaskType = {
    Automation: "AUTOMATION",
    Lambda: "LAMBDA",
    RunCommand: "RUN_COMMAND",
    StepFunctions: "STEP_FUNCTIONS",
};
export const MaintenanceWindowResourceType = {
    Instance: "INSTANCE",
    ResourceGroup: "RESOURCE_GROUP",
};
export const MaintenanceWindowTaskCutoffBehavior = {
    CancelTask: "CANCEL_TASK",
    ContinueTask: "CONTINUE_TASK",
};
export const OpsItemFilterKey = {
    ACCOUNT_ID: "AccountId",
    ACTUAL_END_TIME: "ActualEndTime",
    ACTUAL_START_TIME: "ActualStartTime",
    AUTOMATION_ID: "AutomationId",
    CATEGORY: "Category",
    CHANGE_REQUEST_APPROVER_ARN: "ChangeRequestByApproverArn",
    CHANGE_REQUEST_APPROVER_NAME: "ChangeRequestByApproverName",
    CHANGE_REQUEST_REQUESTER_ARN: "ChangeRequestByRequesterArn",
    CHANGE_REQUEST_REQUESTER_NAME: "ChangeRequestByRequesterName",
    CHANGE_REQUEST_TARGETS_RESOURCE_GROUP: "ChangeRequestByTargetsResourceGroup",
    CHANGE_REQUEST_TEMPLATE: "ChangeRequestByTemplate",
    CREATED_BY: "CreatedBy",
    CREATED_TIME: "CreatedTime",
    INSIGHT_TYPE: "InsightByType",
    LAST_MODIFIED_TIME: "LastModifiedTime",
    OPERATIONAL_DATA: "OperationalData",
    OPERATIONAL_DATA_KEY: "OperationalDataKey",
    OPERATIONAL_DATA_VALUE: "OperationalDataValue",
    OPSITEM_ID: "OpsItemId",
    OPSITEM_TYPE: "OpsItemType",
    PLANNED_END_TIME: "PlannedEndTime",
    PLANNED_START_TIME: "PlannedStartTime",
    PRIORITY: "Priority",
    RESOURCE_ID: "ResourceId",
    SEVERITY: "Severity",
    SOURCE: "Source",
    STATUS: "Status",
    TITLE: "Title",
};
export const OpsItemFilterOperator = {
    CONTAINS: "Contains",
    EQUAL: "Equal",
    GREATER_THAN: "GreaterThan",
    LESS_THAN: "LessThan",
};
export const CreateAssociationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const AssociationDescriptionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const CreateAssociationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationDescription && {
        AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription),
    }),
});
export const CreateAssociationBatchRequestEntryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const CreateAssociationBatchRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Entries && {
        Entries: obj.Entries.map((item) => CreateAssociationBatchRequestEntryFilterSensitiveLog(item)),
    }),
});
export const FailedCreateAssociationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Entry && { Entry: CreateAssociationBatchRequestEntryFilterSensitiveLog(obj.Entry) }),
});
export const CreateAssociationBatchResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Successful && { Successful: obj.Successful.map((item) => AssociationDescriptionFilterSensitiveLog(item)) }),
    ...(obj.Failed && { Failed: obj.Failed.map((item) => FailedCreateAssociationFilterSensitiveLog(item)) }),
});
export const CreateMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const PatchSourceFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Configuration && { Configuration: SENSITIVE_STRING }),
});
export const CreatePatchBaselineRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }),
});
export const DescribeAssociationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationDescription && {
        AssociationDescription: AssociationDescriptionFilterSensitiveLog(obj.AssociationDescription),
    }),
});
export const InstancePatchStateFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }),
});
export const DescribeInstancePatchStatesResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InstancePatchStates && {
        InstancePatchStates: obj.InstancePatchStates.map((item) => InstancePatchStateFilterSensitiveLog(item)),
    }),
});
export const DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.InstancePatchStates && {
        InstancePatchStates: obj.InstancePatchStates.map((item) => InstancePatchStateFilterSensitiveLog(item)),
    }),
});
export const MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
    ...(obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }),
});
export const DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.WindowExecutionTaskInvocationIdentities && {
        WindowExecutionTaskInvocationIdentities: obj.WindowExecutionTaskInvocationIdentities.map((item) => MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog(item)),
    }),
});
export const MaintenanceWindowIdentityFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const DescribeMaintenanceWindowsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.WindowIdentities && {
        WindowIdentities: obj.WindowIdentities.map((item) => MaintenanceWindowIdentityFilterSensitiveLog(item)),
    }),
});
export const MaintenanceWindowTargetFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }),
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const DescribeMaintenanceWindowTargetsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Targets && { Targets: obj.Targets.map((item) => MaintenanceWindowTargetFilterSensitiveLog(item)) }),
});
export const MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Values && { Values: SENSITIVE_STRING }),
});
export const MaintenanceWindowTaskFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: SENSITIVE_STRING }),
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const DescribeMaintenanceWindowTasksResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tasks && { Tasks: obj.Tasks.map((item) => MaintenanceWindowTaskFilterSensitiveLog(item)) }),
});
