import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { PatchSourceFilterSensitiveLog, } from "./models_0";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export const OpsItemStatus = {
    APPROVED: "Approved",
    CANCELLED: "Cancelled",
    CANCELLING: "Cancelling",
    CHANGE_CALENDAR_OVERRIDE_APPROVED: "ChangeCalendarOverrideApproved",
    CHANGE_CALENDAR_OVERRIDE_REJECTED: "ChangeCalendarOverrideRejected",
    CLOSED: "Closed",
    COMPLETED_WITH_FAILURE: "CompletedWithFailure",
    COMPLETED_WITH_SUCCESS: "CompletedWithSuccess",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    OPEN: "Open",
    PENDING: "Pending",
    PENDING_APPROVAL: "PendingApproval",
    PENDING_CHANGE_CALENDAR_OVERRIDE: "PendingChangeCalendarOverride",
    REJECTED: "Rejected",
    RESOLVED: "Resolved",
    RUNBOOK_IN_PROGRESS: "RunbookInProgress",
    SCHEDULED: "Scheduled",
    TIMED_OUT: "TimedOut",
};
export const ParametersFilterKey = {
    KEY_ID: "KeyId",
    NAME: "Name",
    TYPE: "Type",
};
export const ParameterTier = {
    ADVANCED: "Advanced",
    INTELLIGENT_TIERING: "Intelligent-Tiering",
    STANDARD: "Standard",
};
export const ParameterType = {
    SECURE_STRING: "SecureString",
    STRING: "String",
    STRING_LIST: "StringList",
};
export class InvalidFilterOption extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidFilterOption",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidFilterOption";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidFilterOption.prototype);
    }
}
export const PatchSet = {
    Application: "APPLICATION",
    Os: "OS",
};
export const PatchProperty = {
    PatchClassification: "CLASSIFICATION",
    PatchMsrcSeverity: "MSRC_SEVERITY",
    PatchPriority: "PRIORITY",
    PatchProductFamily: "PRODUCT_FAMILY",
    PatchSeverity: "SEVERITY",
    Product: "PRODUCT",
};
export const SessionFilterKey = {
    INVOKED_AFTER: "InvokedAfter",
    INVOKED_BEFORE: "InvokedBefore",
    OWNER: "Owner",
    SESSION_ID: "SessionId",
    STATUS: "Status",
    TARGET_ID: "Target",
};
export const SessionState = {
    ACTIVE: "Active",
    HISTORY: "History",
};
export const SessionStatus = {
    CONNECTED: "Connected",
    CONNECTING: "Connecting",
    DISCONNECTED: "Disconnected",
    FAILED: "Failed",
    TERMINATED: "Terminated",
    TERMINATING: "Terminating",
};
export class OpsItemRelatedItemAssociationNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "OpsItemRelatedItemAssociationNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "OpsItemRelatedItemAssociationNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, OpsItemRelatedItemAssociationNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const CalendarState = {
    CLOSED: "CLOSED",
    OPEN: "OPEN",
};
export class InvalidDocumentType extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidDocumentType",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidDocumentType";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidDocumentType.prototype);
        this.Message = opts.Message;
    }
}
export class UnsupportedCalendarException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedCalendarException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedCalendarException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedCalendarException.prototype);
        this.Message = opts.Message;
    }
}
export const CommandInvocationStatus = {
    CANCELLED: "Cancelled",
    CANCELLING: "Cancelling",
    DELAYED: "Delayed",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    SUCCESS: "Success",
    TIMED_OUT: "TimedOut",
};
export class InvalidPluginName extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidPluginName",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPluginName";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPluginName.prototype);
    }
}
export class InvocationDoesNotExist extends __BaseException {
    constructor(opts) {
        super({
            name: "InvocationDoesNotExist",
            $fault: "client",
            ...opts,
        });
        this.name = "InvocationDoesNotExist";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvocationDoesNotExist.prototype);
    }
}
export const ConnectionStatus = {
    CONNECTED: "Connected",
    NOT_CONNECTED: "NotConnected",
};
export class UnsupportedFeatureRequiredException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedFeatureRequiredException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedFeatureRequiredException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedFeatureRequiredException.prototype);
        this.Message = opts.Message;
    }
}
export const AttachmentHashType = {
    SHA256: "Sha256",
};
export const InventoryQueryOperatorType = {
    BEGIN_WITH: "BeginWith",
    EQUAL: "Equal",
    EXISTS: "Exists",
    GREATER_THAN: "GreaterThan",
    LESS_THAN: "LessThan",
    NOT_EQUAL: "NotEqual",
};
export class InvalidAggregatorException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAggregatorException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAggregatorException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAggregatorException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidInventoryGroupException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInventoryGroupException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryGroupException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryGroupException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidResultAttributeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidResultAttributeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidResultAttributeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidResultAttributeException.prototype);
        this.Message = opts.Message;
    }
}
export const InventoryAttributeDataType = {
    NUMBER: "number",
    STRING: "string",
};
export const NotificationEvent = {
    ALL: "All",
    CANCELLED: "Cancelled",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    SUCCESS: "Success",
    TIMED_OUT: "TimedOut",
};
export const NotificationType = {
    Command: "Command",
    Invocation: "Invocation",
};
export const OpsFilterOperatorType = {
    BEGIN_WITH: "BeginWith",
    EQUAL: "Equal",
    EXISTS: "Exists",
    GREATER_THAN: "GreaterThan",
    LESS_THAN: "LessThan",
    NOT_EQUAL: "NotEqual",
};
export class InvalidKeyId extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidKeyId",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidKeyId";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidKeyId.prototype);
    }
}
export class ParameterVersionNotFound extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterVersionNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterVersionNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterVersionNotFound.prototype);
    }
}
export class ServiceSettingNotFound extends __BaseException {
    constructor(opts) {
        super({
            name: "ServiceSettingNotFound",
            $fault: "client",
            ...opts,
        });
        this.name = "ServiceSettingNotFound";
        this.$fault = "client";
        Object.setPrototypeOf(this, ServiceSettingNotFound.prototype);
        this.Message = opts.Message;
    }
}
export class ParameterVersionLabelLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterVersionLabelLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterVersionLabelLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterVersionLabelLimitExceeded.prototype);
    }
}
export const AssociationFilterKey = {
    AssociationId: "AssociationId",
    AssociationName: "AssociationName",
    InstanceId: "InstanceId",
    LastExecutedAfter: "LastExecutedAfter",
    LastExecutedBefore: "LastExecutedBefore",
    Name: "Name",
    ResourceGroupName: "ResourceGroupName",
    Status: "AssociationStatusName",
};
export const CommandFilterKey = {
    DOCUMENT_NAME: "DocumentName",
    EXECUTION_STAGE: "ExecutionStage",
    INVOKED_AFTER: "InvokedAfter",
    INVOKED_BEFORE: "InvokedBefore",
    STATUS: "Status",
};
export const CommandPluginStatus = {
    CANCELLED: "Cancelled",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    SUCCESS: "Success",
    TIMED_OUT: "TimedOut",
};
export const CommandStatus = {
    CANCELLED: "Cancelled",
    CANCELLING: "Cancelling",
    FAILED: "Failed",
    IN_PROGRESS: "InProgress",
    PENDING: "Pending",
    SUCCESS: "Success",
    TIMED_OUT: "TimedOut",
};
export const ComplianceQueryOperatorType = {
    BeginWith: "BEGIN_WITH",
    Equal: "EQUAL",
    GreaterThan: "GREATER_THAN",
    LessThan: "LESS_THAN",
    NotEqual: "NOT_EQUAL",
};
export const ComplianceSeverity = {
    Critical: "CRITICAL",
    High: "HIGH",
    Informational: "INFORMATIONAL",
    Low: "LOW",
    Medium: "MEDIUM",
    Unspecified: "UNSPECIFIED",
};
export const ComplianceStatus = {
    Compliant: "COMPLIANT",
    NonCompliant: "NON_COMPLIANT",
};
export const DocumentMetadataEnum = {
    DocumentReviews: "DocumentReviews",
};
export const DocumentReviewCommentType = {
    Comment: "Comment",
};
export const DocumentFilterKey = {
    DocumentType: "DocumentType",
    Name: "Name",
    Owner: "Owner",
    PlatformTypes: "PlatformTypes",
};
export const OpsItemEventFilterKey = {
    OPSITEM_ID: "OpsItemId",
};
export const OpsItemEventFilterOperator = {
    EQUAL: "Equal",
};
export const OpsItemRelatedItemsFilterKey = {
    ASSOCIATION_ID: "AssociationId",
    RESOURCE_TYPE: "ResourceType",
    RESOURCE_URI: "ResourceUri",
};
export const OpsItemRelatedItemsFilterOperator = {
    EQUAL: "Equal",
};
export const LastResourceDataSyncStatus = {
    FAILED: "Failed",
    INPROGRESS: "InProgress",
    SUCCESSFUL: "Successful",
};
export class DocumentPermissionLimit extends __BaseException {
    constructor(opts) {
        super({
            name: "DocumentPermissionLimit",
            $fault: "client",
            ...opts,
        });
        this.name = "DocumentPermissionLimit";
        this.$fault = "client";
        Object.setPrototypeOf(this, DocumentPermissionLimit.prototype);
        this.Message = opts.Message;
    }
}
export class ComplianceTypeCountLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ComplianceTypeCountLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ComplianceTypeCountLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ComplianceTypeCountLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidItemContentException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidItemContentException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidItemContentException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidItemContentException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
export class ItemSizeLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ItemSizeLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ItemSizeLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ItemSizeLimitExceededException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
export const ComplianceUploadType = {
    Complete: "COMPLETE",
    Partial: "PARTIAL",
};
export class TotalSizeLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "TotalSizeLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "TotalSizeLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, TotalSizeLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class CustomSchemaCountLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "CustomSchemaCountLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "CustomSchemaCountLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, CustomSchemaCountLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidInventoryItemContextException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidInventoryItemContextException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidInventoryItemContextException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidInventoryItemContextException.prototype);
        this.Message = opts.Message;
    }
}
export class ItemContentMismatchException extends __BaseException {
    constructor(opts) {
        super({
            name: "ItemContentMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "ItemContentMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ItemContentMismatchException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
export class SubTypeCountLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "SubTypeCountLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "SubTypeCountLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, SubTypeCountLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class UnsupportedInventoryItemContextException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedInventoryItemContextException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedInventoryItemContextException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedInventoryItemContextException.prototype);
        this.TypeName = opts.TypeName;
        this.Message = opts.Message;
    }
}
export class UnsupportedInventorySchemaVersionException extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedInventorySchemaVersionException",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedInventorySchemaVersionException";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedInventorySchemaVersionException.prototype);
        this.Message = opts.Message;
    }
}
export class HierarchyLevelLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "HierarchyLevelLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "HierarchyLevelLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, HierarchyLevelLimitExceededException.prototype);
    }
}
export class HierarchyTypeMismatchException extends __BaseException {
    constructor(opts) {
        super({
            name: "HierarchyTypeMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "HierarchyTypeMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, HierarchyTypeMismatchException.prototype);
    }
}
export class IncompatiblePolicyException extends __BaseException {
    constructor(opts) {
        super({
            name: "IncompatiblePolicyException",
            $fault: "client",
            ...opts,
        });
        this.name = "IncompatiblePolicyException";
        this.$fault = "client";
        Object.setPrototypeOf(this, IncompatiblePolicyException.prototype);
    }
}
export class InvalidAllowedPatternException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAllowedPatternException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAllowedPatternException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAllowedPatternException.prototype);
    }
}
export class InvalidPolicyAttributeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidPolicyAttributeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPolicyAttributeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPolicyAttributeException.prototype);
    }
}
export class InvalidPolicyTypeException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidPolicyTypeException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidPolicyTypeException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidPolicyTypeException.prototype);
    }
}
export class ParameterAlreadyExists extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterAlreadyExists",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterAlreadyExists";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterAlreadyExists.prototype);
    }
}
export class ParameterLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterLimitExceeded.prototype);
    }
}
export class ParameterMaxVersionLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterMaxVersionLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterMaxVersionLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterMaxVersionLimitExceeded.prototype);
    }
}
export class ParameterPatternMismatchException extends __BaseException {
    constructor(opts) {
        super({
            name: "ParameterPatternMismatchException",
            $fault: "client",
            ...opts,
        });
        this.name = "ParameterPatternMismatchException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ParameterPatternMismatchException.prototype);
    }
}
export class PoliciesLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "PoliciesLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "PoliciesLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, PoliciesLimitExceededException.prototype);
    }
}
export class UnsupportedParameterType extends __BaseException {
    constructor(opts) {
        super({
            name: "UnsupportedParameterType",
            $fault: "client",
            ...opts,
        });
        this.name = "UnsupportedParameterType";
        this.$fault = "client";
        Object.setPrototypeOf(this, UnsupportedParameterType.prototype);
    }
}
export class ResourcePolicyLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "ResourcePolicyLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "ResourcePolicyLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, ResourcePolicyLimitExceededException.prototype);
        this.Limit = opts.Limit;
        this.LimitType = opts.LimitType;
        this.Message = opts.Message;
    }
}
export class FeatureNotAvailableException extends __BaseException {
    constructor(opts) {
        super({
            name: "FeatureNotAvailableException",
            $fault: "client",
            ...opts,
        });
        this.name = "FeatureNotAvailableException";
        this.$fault = "client";
        Object.setPrototypeOf(this, FeatureNotAvailableException.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationStepNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationStepNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationStepNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationStepNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidAutomationSignalException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAutomationSignalException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutomationSignalException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutomationSignalException.prototype);
        this.Message = opts.Message;
    }
}
export const SignalType = {
    APPROVE: "Approve",
    REJECT: "Reject",
    RESUME: "Resume",
    START_STEP: "StartStep",
    STOP_STEP: "StopStep",
};
export class InvalidNotificationConfig extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidNotificationConfig",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidNotificationConfig";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidNotificationConfig.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidOutputFolder extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidOutputFolder",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidOutputFolder";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidOutputFolder.prototype);
    }
}
export class InvalidRole extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidRole",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidRole";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidRole.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidAssociation extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAssociation",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAssociation";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAssociation.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationDefinitionNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationDefinitionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationDefinitionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationDefinitionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationDefinitionVersionNotFoundException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationDefinitionVersionNotFoundException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationDefinitionVersionNotFoundException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationDefinitionVersionNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationExecutionLimitExceededException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationExecutionLimitExceededException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationExecutionLimitExceededException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationExecutionLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidAutomationExecutionParametersException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAutomationExecutionParametersException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutomationExecutionParametersException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutomationExecutionParametersException.prototype);
        this.Message = opts.Message;
    }
}
export class AutomationDefinitionNotApprovedException extends __BaseException {
    constructor(opts) {
        super({
            name: "AutomationDefinitionNotApprovedException",
            $fault: "client",
            ...opts,
        });
        this.name = "AutomationDefinitionNotApprovedException";
        this.$fault = "client";
        Object.setPrototypeOf(this, AutomationDefinitionNotApprovedException.prototype);
        this.Message = opts.Message;
    }
}
export class TargetNotConnected extends __BaseException {
    constructor(opts) {
        super({
            name: "TargetNotConnected",
            $fault: "client",
            ...opts,
        });
        this.name = "TargetNotConnected";
        this.$fault = "client";
        Object.setPrototypeOf(this, TargetNotConnected.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidAutomationStatusUpdateException extends __BaseException {
    constructor(opts) {
        super({
            name: "InvalidAutomationStatusUpdateException",
            $fault: "client",
            ...opts,
        });
        this.name = "InvalidAutomationStatusUpdateException";
        this.$fault = "client";
        Object.setPrototypeOf(this, InvalidAutomationStatusUpdateException.prototype);
        this.Message = opts.Message;
    }
}
export const StopType = {
    CANCEL: "Cancel",
    COMPLETE: "Complete",
};
export class AssociationVersionLimitExceeded extends __BaseException {
    constructor(opts) {
        super({
            name: "AssociationVersionLimitExceeded",
            $fault: "client",
            ...opts,
        });
        this.name = "AssociationVersionLimitExceeded";
        this.$fault = "client";
        Object.setPrototypeOf(this, AssociationVersionLimitExceeded.prototype);
        this.Message = opts.Message;
    }
}
export const BaselineOverrideFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }),
});
export const GetDeployablePatchSnapshotForInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const GetMaintenanceWindowResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const GetMaintenanceWindowExecutionTaskResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: SENSITIVE_STRING }),
});
export const GetMaintenanceWindowExecutionTaskInvocationResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
    ...(obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }),
});
export const MaintenanceWindowLambdaParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Payload && { Payload: SENSITIVE_STRING }),
});
export const MaintenanceWindowRunCommandParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const MaintenanceWindowStepFunctionsParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Input && { Input: SENSITIVE_STRING }),
});
export const MaintenanceWindowTaskInvocationParametersFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RunCommand && { RunCommand: MaintenanceWindowRunCommandParametersFilterSensitiveLog(obj.RunCommand) }),
    ...(obj.StepFunctions && {
        StepFunctions: MaintenanceWindowStepFunctionsParametersFilterSensitiveLog(obj.StepFunctions),
    }),
    ...(obj.Lambda && { Lambda: MaintenanceWindowLambdaParametersFilterSensitiveLog(obj.Lambda) }),
});
export const GetMaintenanceWindowTaskResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: SENSITIVE_STRING }),
    ...(obj.TaskInvocationParameters && {
        TaskInvocationParameters: MaintenanceWindowTaskInvocationParametersFilterSensitiveLog(obj.TaskInvocationParameters),
    }),
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const ParameterFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Value && { Value: SENSITIVE_STRING }),
});
export const GetParameterResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameter && { Parameter: ParameterFilterSensitiveLog(obj.Parameter) }),
});
export const ParameterHistoryFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Value && { Value: SENSITIVE_STRING }),
});
export const GetParameterHistoryResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: obj.Parameters.map((item) => ParameterHistoryFilterSensitiveLog(item)) }),
});
export const GetParametersResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: obj.Parameters.map((item) => ParameterFilterSensitiveLog(item)) }),
});
export const GetParametersByPathResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: obj.Parameters.map((item) => ParameterFilterSensitiveLog(item)) }),
});
export const GetPatchBaselineResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Sources && { Sources: obj.Sources.map((item) => PatchSourceFilterSensitiveLog(item)) }),
});
export const AssociationVersionInfoFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const ListAssociationVersionsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AssociationVersions && {
        AssociationVersions: obj.AssociationVersions.map((item) => AssociationVersionInfoFilterSensitiveLog(item)),
    }),
});
export const CommandFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const ListCommandsResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Commands && { Commands: obj.Commands.map((item) => CommandFilterSensitiveLog(item)) }),
});
export const PutParameterRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Value && { Value: SENSITIVE_STRING }),
});
export const RegisterTargetWithMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OwnerInformation && { OwnerInformation: SENSITIVE_STRING }),
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const RegisterTaskWithMaintenanceWindowRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TaskParameters && { TaskParameters: SENSITIVE_STRING }),
    ...(obj.TaskInvocationParameters && {
        TaskInvocationParameters: MaintenanceWindowTaskInvocationParametersFilterSensitiveLog(obj.TaskInvocationParameters),
    }),
    ...(obj.Description && { Description: SENSITIVE_STRING }),
});
export const SendCommandRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Parameters && { Parameters: SENSITIVE_STRING }),
});
export const SendCommandResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Command && { Command: CommandFilterSensitiveLog(obj.Command) }),
});
