import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { SSMServiceException as __BaseException } from "./SSMServiceException";
export interface AccountSharingInfo {
  AccountId?: string;
  SharedDocumentVersion?: string;
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface Activation {
  ActivationId?: string;
  Description?: string;
  DefaultInstanceName?: string;
  IamRole?: string;
  RegistrationLimit?: number;
  RegistrationsCount?: number;
  ExpirationDate?: Date;
  Expired?: boolean;
  CreatedDate?: Date;
  Tags?: Tag[];
}
export declare const ResourceTypeForTagging: {
  readonly ASSOCIATION: "Association";
  readonly AUTOMATION: "Automation";
  readonly DOCUMENT: "Document";
  readonly MAINTENANCE_WINDOW: "MaintenanceWindow";
  readonly MANAGED_INSTANCE: "ManagedInstance";
  readonly OPSMETADATA: "OpsMetadata";
  readonly OPS_ITEM: "OpsItem";
  readonly PARAMETER: "Parameter";
  readonly PATCH_BASELINE: "PatchBaseline";
};
export type ResourceTypeForTagging =
  (typeof ResourceTypeForTagging)[keyof typeof ResourceTypeForTagging];
export interface AddTagsToResourceRequest {
  ResourceType: ResourceTypeForTagging | string | undefined;
  ResourceId: string | undefined;
  Tags: Tag[] | undefined;
}
export interface AddTagsToResourceResult {}
export declare class InternalServerError extends __BaseException {
  readonly name: "InternalServerError";
  readonly $fault: "server";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InternalServerError, __BaseException>
  );
}
export declare class InvalidResourceId extends __BaseException {
  readonly name: "InvalidResourceId";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidResourceId, __BaseException>);
}
export declare class InvalidResourceType extends __BaseException {
  readonly name: "InvalidResourceType";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidResourceType, __BaseException>
  );
}
export declare class TooManyTagsError extends __BaseException {
  readonly name: "TooManyTagsError";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<TooManyTagsError, __BaseException>);
}
export declare class TooManyUpdates extends __BaseException {
  readonly name: "TooManyUpdates";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<TooManyUpdates, __BaseException>);
}
export interface Alarm {
  Name: string | undefined;
}
export interface AlarmConfiguration {
  IgnorePollAlarmFailure?: boolean;
  Alarms: Alarm[] | undefined;
}
export declare const ExternalAlarmState: {
  readonly ALARM: "ALARM";
  readonly UNKNOWN: "UNKNOWN";
};
export type ExternalAlarmState =
  (typeof ExternalAlarmState)[keyof typeof ExternalAlarmState];
export interface AlarmStateInformation {
  Name: string | undefined;
  State: ExternalAlarmState | string | undefined;
}
export declare class AlreadyExistsException extends __BaseException {
  readonly name: "AlreadyExistsException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<AlreadyExistsException, __BaseException>
  );
}
export interface AssociateOpsItemRelatedItemRequest {
  OpsItemId: string | undefined;
  AssociationType: string | undefined;
  ResourceType: string | undefined;
  ResourceUri: string | undefined;
}
export interface AssociateOpsItemRelatedItemResponse {
  AssociationId?: string;
}
export declare class OpsItemInvalidParameterException extends __BaseException {
  readonly name: "OpsItemInvalidParameterException";
  readonly $fault: "client";
  ParameterNames?: string[];
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      OpsItemInvalidParameterException,
      __BaseException
    >
  );
}
export declare class OpsItemLimitExceededException extends __BaseException {
  readonly name: "OpsItemLimitExceededException";
  readonly $fault: "client";
  ResourceTypes?: string[];
  Limit?: number;
  LimitType?: string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<OpsItemLimitExceededException, __BaseException>
  );
}
export declare class OpsItemNotFoundException extends __BaseException {
  readonly name: "OpsItemNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<OpsItemNotFoundException, __BaseException>
  );
}
export declare class OpsItemRelatedItemAlreadyExistsException extends __BaseException {
  readonly name: "OpsItemRelatedItemAlreadyExistsException";
  readonly $fault: "client";
  Message?: string;
  ResourceUri?: string;
  OpsItemId?: string;
  constructor(
    opts: __ExceptionOptionType<
      OpsItemRelatedItemAlreadyExistsException,
      __BaseException
    >
  );
}
export interface CancelCommandRequest {
  CommandId: string | undefined;
  InstanceIds?: string[];
}
export interface CancelCommandResult {}
export declare class DuplicateInstanceId extends __BaseException {
  readonly name: "DuplicateInstanceId";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DuplicateInstanceId, __BaseException>
  );
}
export declare class InvalidCommandId extends __BaseException {
  readonly name: "InvalidCommandId";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidCommandId, __BaseException>);
}
export declare class InvalidInstanceId extends __BaseException {
  readonly name: "InvalidInstanceId";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidInstanceId, __BaseException>);
}
export interface CancelMaintenanceWindowExecutionRequest {
  WindowExecutionId: string | undefined;
}
export interface CancelMaintenanceWindowExecutionResult {
  WindowExecutionId?: string;
}
export declare class DoesNotExistException extends __BaseException {
  readonly name: "DoesNotExistException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<DoesNotExistException, __BaseException>
  );
}
export interface RegistrationMetadataItem {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateActivationRequest {
  Description?: string;
  DefaultInstanceName?: string;
  IamRole: string | undefined;
  RegistrationLimit?: number;
  ExpirationDate?: Date;
  Tags?: Tag[];
  RegistrationMetadata?: RegistrationMetadataItem[];
}
export interface CreateActivationResult {
  ActivationId?: string;
  ActivationCode?: string;
}
export declare class InvalidParameters extends __BaseException {
  readonly name: "InvalidParameters";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidParameters, __BaseException>);
}
export declare class AssociationAlreadyExists extends __BaseException {
  readonly name: "AssociationAlreadyExists";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AssociationAlreadyExists, __BaseException>
  );
}
export declare class AssociationLimitExceeded extends __BaseException {
  readonly name: "AssociationLimitExceeded";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AssociationLimitExceeded, __BaseException>
  );
}
export declare const AssociationComplianceSeverity: {
  readonly Critical: "CRITICAL";
  readonly High: "HIGH";
  readonly Low: "LOW";
  readonly Medium: "MEDIUM";
  readonly Unspecified: "UNSPECIFIED";
};
export type AssociationComplianceSeverity =
  (typeof AssociationComplianceSeverity)[keyof typeof AssociationComplianceSeverity];
export interface S3OutputLocation {
  OutputS3Region?: string;
  OutputS3BucketName?: string;
  OutputS3KeyPrefix?: string;
}
export interface InstanceAssociationOutputLocation {
  S3Location?: S3OutputLocation;
}
export declare const AssociationSyncCompliance: {
  readonly Auto: "AUTO";
  readonly Manual: "MANUAL";
};
export type AssociationSyncCompliance =
  (typeof AssociationSyncCompliance)[keyof typeof AssociationSyncCompliance];
export interface TargetLocation {
  Accounts?: string[];
  Regions?: string[];
  TargetLocationMaxConcurrency?: string;
  TargetLocationMaxErrors?: string;
  ExecutionRoleName?: string;
  TargetLocationAlarmConfiguration?: AlarmConfiguration;
}
export interface Target {
  Key?: string;
  Values?: string[];
}
export interface CreateAssociationRequest {
  Name: string | undefined;
  DocumentVersion?: string;
  InstanceId?: string;
  Parameters?: Record<string, string[]>;
  Targets?: Target[];
  ScheduleExpression?: string;
  OutputLocation?: InstanceAssociationOutputLocation;
  AssociationName?: string;
  AutomationTargetParameterName?: string;
  MaxErrors?: string;
  MaxConcurrency?: string;
  ComplianceSeverity?: AssociationComplianceSeverity | string;
  SyncCompliance?: AssociationSyncCompliance | string;
  ApplyOnlyAtCronInterval?: boolean;
  CalendarNames?: string[];
  TargetLocations?: TargetLocation[];
  ScheduleOffset?: number;
  TargetMaps?: Record<string, string[]>[];
  Tags?: Tag[];
  AlarmConfiguration?: AlarmConfiguration;
}
export interface AssociationOverview {
  Status?: string;
  DetailedStatus?: string;
  AssociationStatusAggregatedCount?: Record<string, number>;
}
export declare const AssociationStatusName: {
  readonly Failed: "Failed";
  readonly Pending: "Pending";
  readonly Success: "Success";
};
export type AssociationStatusName =
  (typeof AssociationStatusName)[keyof typeof AssociationStatusName];
export interface AssociationStatus {
  Date: Date | undefined;
  Name: AssociationStatusName | string | undefined;
  Message: string | undefined;
  AdditionalInfo?: string;
}
export interface AssociationDescription {
  Name?: string;
  InstanceId?: string;
  AssociationVersion?: string;
  Date?: Date;
  LastUpdateAssociationDate?: Date;
  Status?: AssociationStatus;
  Overview?: AssociationOverview;
  DocumentVersion?: string;
  AutomationTargetParameterName?: string;
  Parameters?: Record<string, string[]>;
  AssociationId?: string;
  Targets?: Target[];
  ScheduleExpression?: string;
  OutputLocation?: InstanceAssociationOutputLocation;
  LastExecutionDate?: Date;
  LastSuccessfulExecutionDate?: Date;
  AssociationName?: string;
  MaxErrors?: string;
  MaxConcurrency?: string;
  ComplianceSeverity?: AssociationComplianceSeverity | string;
  SyncCompliance?: AssociationSyncCompliance | string;
  ApplyOnlyAtCronInterval?: boolean;
  CalendarNames?: string[];
  TargetLocations?: TargetLocation[];
  ScheduleOffset?: number;
  TargetMaps?: Record<string, string[]>[];
  AlarmConfiguration?: AlarmConfiguration;
  TriggeredAlarms?: AlarmStateInformation[];
}
export interface CreateAssociationResult {
  AssociationDescription?: AssociationDescription;
}
export declare class InvalidDocument extends __BaseException {
  readonly name: "InvalidDocument";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidDocument, __BaseException>);
}
export declare class InvalidDocumentVersion extends __BaseException {
  readonly name: "InvalidDocumentVersion";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidDocumentVersion, __BaseException>
  );
}
export declare class InvalidOutputLocation extends __BaseException {
  readonly name: "InvalidOutputLocation";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidOutputLocation, __BaseException>
  );
}
export declare class InvalidSchedule extends __BaseException {
  readonly name: "InvalidSchedule";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidSchedule, __BaseException>);
}
export declare class InvalidTag extends __BaseException {
  readonly name: "InvalidTag";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidTag, __BaseException>);
}
export declare class InvalidTarget extends __BaseException {
  readonly name: "InvalidTarget";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidTarget, __BaseException>);
}
export declare class InvalidTargetMaps extends __BaseException {
  readonly name: "InvalidTargetMaps";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidTargetMaps, __BaseException>);
}
export declare class UnsupportedPlatformType extends __BaseException {
  readonly name: "UnsupportedPlatformType";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnsupportedPlatformType, __BaseException>
  );
}
export interface CreateAssociationBatchRequestEntry {
  Name: string | undefined;
  InstanceId?: string;
  Parameters?: Record<string, string[]>;
  AutomationTargetParameterName?: string;
  DocumentVersion?: string;
  Targets?: Target[];
  ScheduleExpression?: string;
  OutputLocation?: InstanceAssociationOutputLocation;
  AssociationName?: string;
  MaxErrors?: string;
  MaxConcurrency?: string;
  ComplianceSeverity?: AssociationComplianceSeverity | string;
  SyncCompliance?: AssociationSyncCompliance | string;
  ApplyOnlyAtCronInterval?: boolean;
  CalendarNames?: string[];
  TargetLocations?: TargetLocation[];
  ScheduleOffset?: number;
  TargetMaps?: Record<string, string[]>[];
  AlarmConfiguration?: AlarmConfiguration;
}
export interface CreateAssociationBatchRequest {
  Entries: CreateAssociationBatchRequestEntry[] | undefined;
}
export declare const Fault: {
  readonly Client: "Client";
  readonly Server: "Server";
  readonly Unknown: "Unknown";
};
export type Fault = (typeof Fault)[keyof typeof Fault];
export interface FailedCreateAssociation {
  Entry?: CreateAssociationBatchRequestEntry;
  Message?: string;
  Fault?: Fault | string;
}
export interface CreateAssociationBatchResult {
  Successful?: AssociationDescription[];
  Failed?: FailedCreateAssociation[];
}
export declare const AttachmentsSourceKey: {
  readonly AttachmentReference: "AttachmentReference";
  readonly S3FileUrl: "S3FileUrl";
  readonly SourceUrl: "SourceUrl";
};
export type AttachmentsSourceKey =
  (typeof AttachmentsSourceKey)[keyof typeof AttachmentsSourceKey];
export interface AttachmentsSource {
  Key?: AttachmentsSourceKey | string;
  Values?: string[];
  Name?: string;
}
export declare const DocumentFormat: {
  readonly JSON: "JSON";
  readonly TEXT: "TEXT";
  readonly YAML: "YAML";
};
export type DocumentFormat =
  (typeof DocumentFormat)[keyof typeof DocumentFormat];
export declare const DocumentType: {
  readonly ApplicationConfiguration: "ApplicationConfiguration";
  readonly ApplicationConfigurationSchema: "ApplicationConfigurationSchema";
  readonly Automation: "Automation";
  readonly ChangeCalendar: "ChangeCalendar";
  readonly ChangeTemplate: "Automation.ChangeTemplate";
  readonly CloudFormation: "CloudFormation";
  readonly Command: "Command";
  readonly ConformancePackTemplate: "ConformancePackTemplate";
  readonly DeploymentStrategy: "DeploymentStrategy";
  readonly Package: "Package";
  readonly Policy: "Policy";
  readonly ProblemAnalysis: "ProblemAnalysis";
  readonly ProblemAnalysisTemplate: "ProblemAnalysisTemplate";
  readonly QuickSetup: "QuickSetup";
  readonly Session: "Session";
};
export type DocumentType = (typeof DocumentType)[keyof typeof DocumentType];
export interface DocumentRequires {
  Name: string | undefined;
  Version?: string;
  RequireType?: string;
  VersionName?: string;
}
export interface CreateDocumentRequest {
  Content: string | undefined;
  Requires?: DocumentRequires[];
  Attachments?: AttachmentsSource[];
  Name: string | undefined;
  DisplayName?: string;
  VersionName?: string;
  DocumentType?: DocumentType | string;
  DocumentFormat?: DocumentFormat | string;
  TargetType?: string;
  Tags?: Tag[];
}
export interface AttachmentInformation {
  Name?: string;
}
export declare const DocumentHashType: {
  readonly SHA1: "Sha1";
  readonly SHA256: "Sha256";
};
export type DocumentHashType =
  (typeof DocumentHashType)[keyof typeof DocumentHashType];
export declare const DocumentParameterType: {
  readonly String: "String";
  readonly StringList: "StringList";
};
export type DocumentParameterType =
  (typeof DocumentParameterType)[keyof typeof DocumentParameterType];
export interface DocumentParameter {
  Name?: string;
  Type?: DocumentParameterType | string;
  Description?: string;
  DefaultValue?: string;
}
export declare const PlatformType: {
  readonly LINUX: "Linux";
  readonly MACOS: "MacOS";
  readonly WINDOWS: "Windows";
};
export type PlatformType = (typeof PlatformType)[keyof typeof PlatformType];
export declare const ReviewStatus: {
  readonly APPROVED: "APPROVED";
  readonly NOT_REVIEWED: "NOT_REVIEWED";
  readonly PENDING: "PENDING";
  readonly REJECTED: "REJECTED";
};
export type ReviewStatus = (typeof ReviewStatus)[keyof typeof ReviewStatus];
export interface ReviewInformation {
  ReviewedTime?: Date;
  Status?: ReviewStatus | string;
  Reviewer?: string;
}
export declare const DocumentStatus: {
  readonly Active: "Active";
  readonly Creating: "Creating";
  readonly Deleting: "Deleting";
  readonly Failed: "Failed";
  readonly Updating: "Updating";
};
export type DocumentStatus =
  (typeof DocumentStatus)[keyof typeof DocumentStatus];
export interface DocumentDescription {
  Sha1?: string;
  Hash?: string;
  HashType?: DocumentHashType | string;
  Name?: string;
  DisplayName?: string;
  VersionName?: string;
  Owner?: string;
  CreatedDate?: Date;
  Status?: DocumentStatus | string;
  StatusInformation?: string;
  DocumentVersion?: string;
  Description?: string;
  Parameters?: DocumentParameter[];
  PlatformTypes?: (PlatformType | string)[];
  DocumentType?: DocumentType | string;
  SchemaVersion?: string;
  LatestVersion?: string;
  DefaultVersion?: string;
  DocumentFormat?: DocumentFormat | string;
  TargetType?: string;
  Tags?: Tag[];
  AttachmentsInformation?: AttachmentInformation[];
  Requires?: DocumentRequires[];
  Author?: string;
  ReviewInformation?: ReviewInformation[];
  ApprovedVersion?: string;
  PendingReviewVersion?: string;
  ReviewStatus?: ReviewStatus | string;
  Category?: string[];
  CategoryEnum?: string[];
}
export interface CreateDocumentResult {
  DocumentDescription?: DocumentDescription;
}
export declare class DocumentAlreadyExists extends __BaseException {
  readonly name: "DocumentAlreadyExists";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<DocumentAlreadyExists, __BaseException>
  );
}
export declare class DocumentLimitExceeded extends __BaseException {
  readonly name: "DocumentLimitExceeded";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<DocumentLimitExceeded, __BaseException>
  );
}
export declare class InvalidDocumentContent extends __BaseException {
  readonly name: "InvalidDocumentContent";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidDocumentContent, __BaseException>
  );
}
export declare class InvalidDocumentSchemaVersion extends __BaseException {
  readonly name: "InvalidDocumentSchemaVersion";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidDocumentSchemaVersion, __BaseException>
  );
}
export declare class MaxDocumentSizeExceeded extends __BaseException {
  readonly name: "MaxDocumentSizeExceeded";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<MaxDocumentSizeExceeded, __BaseException>
  );
}
export interface CreateMaintenanceWindowRequest {
  Name: string | undefined;
  Description?: string;
  StartDate?: string;
  EndDate?: string;
  Schedule: string | undefined;
  ScheduleTimezone?: string;
  ScheduleOffset?: number;
  Duration: number | undefined;
  Cutoff: number | undefined;
  AllowUnassociatedTargets: boolean | undefined;
  ClientToken?: string;
  Tags?: Tag[];
}
export interface CreateMaintenanceWindowResult {
  WindowId?: string;
}
export declare class IdempotentParameterMismatch extends __BaseException {
  readonly name: "IdempotentParameterMismatch";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<IdempotentParameterMismatch, __BaseException>
  );
}
export declare class ResourceLimitExceededException extends __BaseException {
  readonly name: "ResourceLimitExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>
  );
}
export interface OpsItemNotification {
  Arn?: string;
}
export declare const OpsItemDataType: {
  readonly SEARCHABLE_STRING: "SearchableString";
  readonly STRING: "String";
};
export type OpsItemDataType =
  (typeof OpsItemDataType)[keyof typeof OpsItemDataType];
export interface OpsItemDataValue {
  Value?: string;
  Type?: OpsItemDataType | string;
}
export interface RelatedOpsItem {
  OpsItemId: string | undefined;
}
export interface CreateOpsItemRequest {
  Description: string | undefined;
  OpsItemType?: string;
  OperationalData?: Record<string, OpsItemDataValue>;
  Notifications?: OpsItemNotification[];
  Priority?: number;
  RelatedOpsItems?: RelatedOpsItem[];
  Source: string | undefined;
  Title: string | undefined;
  Tags?: Tag[];
  Category?: string;
  Severity?: string;
  ActualStartTime?: Date;
  ActualEndTime?: Date;
  PlannedStartTime?: Date;
  PlannedEndTime?: Date;
  AccountId?: string;
}
export interface CreateOpsItemResponse {
  OpsItemId?: string;
  OpsItemArn?: string;
}
export declare class OpsItemAccessDeniedException extends __BaseException {
  readonly name: "OpsItemAccessDeniedException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<OpsItemAccessDeniedException, __BaseException>
  );
}
export declare class OpsItemAlreadyExistsException extends __BaseException {
  readonly name: "OpsItemAlreadyExistsException";
  readonly $fault: "client";
  Message?: string;
  OpsItemId?: string;
  constructor(
    opts: __ExceptionOptionType<OpsItemAlreadyExistsException, __BaseException>
  );
}
export interface MetadataValue {
  Value?: string;
}
export interface CreateOpsMetadataRequest {
  ResourceId: string | undefined;
  Metadata?: Record<string, MetadataValue>;
  Tags?: Tag[];
}
export interface CreateOpsMetadataResult {
  OpsMetadataArn?: string;
}
export declare class OpsMetadataAlreadyExistsException extends __BaseException {
  readonly name: "OpsMetadataAlreadyExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      OpsMetadataAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class OpsMetadataInvalidArgumentException extends __BaseException {
  readonly name: "OpsMetadataInvalidArgumentException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      OpsMetadataInvalidArgumentException,
      __BaseException
    >
  );
}
export declare class OpsMetadataLimitExceededException extends __BaseException {
  readonly name: "OpsMetadataLimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      OpsMetadataLimitExceededException,
      __BaseException
    >
  );
}
export declare class OpsMetadataTooManyUpdatesException extends __BaseException {
  readonly name: "OpsMetadataTooManyUpdatesException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      OpsMetadataTooManyUpdatesException,
      __BaseException
    >
  );
}
export declare const PatchComplianceLevel: {
  readonly Critical: "CRITICAL";
  readonly High: "HIGH";
  readonly Informational: "INFORMATIONAL";
  readonly Low: "LOW";
  readonly Medium: "MEDIUM";
  readonly Unspecified: "UNSPECIFIED";
};
export type PatchComplianceLevel =
  (typeof PatchComplianceLevel)[keyof typeof PatchComplianceLevel];
export declare const PatchFilterKey: {
  readonly AdvisoryId: "ADVISORY_ID";
  readonly Arch: "ARCH";
  readonly BugzillaId: "BUGZILLA_ID";
  readonly CVEId: "CVE_ID";
  readonly Classification: "CLASSIFICATION";
  readonly Epoch: "EPOCH";
  readonly MsrcSeverity: "MSRC_SEVERITY";
  readonly Name: "NAME";
  readonly PatchId: "PATCH_ID";
  readonly PatchSet: "PATCH_SET";
  readonly Priority: "PRIORITY";
  readonly Product: "PRODUCT";
  readonly ProductFamily: "PRODUCT_FAMILY";
  readonly Release: "RELEASE";
  readonly Repository: "REPOSITORY";
  readonly Section: "SECTION";
  readonly Security: "SECURITY";
  readonly Severity: "SEVERITY";
  readonly Version: "VERSION";
};
export type PatchFilterKey =
  (typeof PatchFilterKey)[keyof typeof PatchFilterKey];
export interface PatchFilter {
  Key: PatchFilterKey | string | undefined;
  Values: string[] | undefined;
}
export interface PatchFilterGroup {
  PatchFilters: PatchFilter[] | undefined;
}
export interface PatchRule {
  PatchFilterGroup: PatchFilterGroup | undefined;
  ComplianceLevel?: PatchComplianceLevel | string;
  ApproveAfterDays?: number;
  ApproveUntilDate?: string;
  EnableNonSecurity?: boolean;
}
export interface PatchRuleGroup {
  PatchRules: PatchRule[] | undefined;
}
export declare const OperatingSystem: {
  readonly AlmaLinux: "ALMA_LINUX";
  readonly AmazonLinux: "AMAZON_LINUX";
  readonly AmazonLinux2: "AMAZON_LINUX_2";
  readonly AmazonLinux2022: "AMAZON_LINUX_2022";
  readonly AmazonLinux2023: "AMAZON_LINUX_2023";
  readonly CentOS: "CENTOS";
  readonly Debian: "DEBIAN";
  readonly MacOS: "MACOS";
  readonly OracleLinux: "ORACLE_LINUX";
  readonly Raspbian: "RASPBIAN";
  readonly RedhatEnterpriseLinux: "REDHAT_ENTERPRISE_LINUX";
  readonly Rocky_Linux: "ROCKY_LINUX";
  readonly Suse: "SUSE";
  readonly Ubuntu: "UBUNTU";
  readonly Windows: "WINDOWS";
};
export type OperatingSystem =
  (typeof OperatingSystem)[keyof typeof OperatingSystem];
export declare const PatchAction: {
  readonly AllowAsDependency: "ALLOW_AS_DEPENDENCY";
  readonly Block: "BLOCK";
};
export type PatchAction = (typeof PatchAction)[keyof typeof PatchAction];
export interface PatchSource {
  Name: string | undefined;
  Products: string[] | undefined;
  Configuration: string | undefined;
}
export interface CreatePatchBaselineRequest {
  OperatingSystem?: OperatingSystem | string;
  Name: string | undefined;
  GlobalFilters?: PatchFilterGroup;
  ApprovalRules?: PatchRuleGroup;
  ApprovedPatches?: string[];
  ApprovedPatchesComplianceLevel?: PatchComplianceLevel | string;
  ApprovedPatchesEnableNonSecurity?: boolean;
  RejectedPatches?: string[];
  RejectedPatchesAction?: PatchAction | string;
  Description?: string;
  Sources?: PatchSource[];
  ClientToken?: string;
  Tags?: Tag[];
}
export interface CreatePatchBaselineResult {
  BaselineId?: string;
}
export interface ResourceDataSyncDestinationDataSharing {
  DestinationDataSharingType?: string;
}
export declare const ResourceDataSyncS3Format: {
  readonly JSON_SERDE: "JsonSerDe";
};
export type ResourceDataSyncS3Format =
  (typeof ResourceDataSyncS3Format)[keyof typeof ResourceDataSyncS3Format];
export interface ResourceDataSyncS3Destination {
  BucketName: string | undefined;
  Prefix?: string;
  SyncFormat: ResourceDataSyncS3Format | string | undefined;
  Region: string | undefined;
  AWSKMSKeyARN?: string;
  DestinationDataSharing?: ResourceDataSyncDestinationDataSharing;
}
export interface ResourceDataSyncOrganizationalUnit {
  OrganizationalUnitId?: string;
}
export interface ResourceDataSyncAwsOrganizationsSource {
  OrganizationSourceType: string | undefined;
  OrganizationalUnits?: ResourceDataSyncOrganizationalUnit[];
}
export interface ResourceDataSyncSource {
  SourceType: string | undefined;
  AwsOrganizationsSource?: ResourceDataSyncAwsOrganizationsSource;
  SourceRegions: string[] | undefined;
  IncludeFutureRegions?: boolean;
  EnableAllOpsDataSources?: boolean;
}
export interface CreateResourceDataSyncRequest {
  SyncName: string | undefined;
  S3Destination?: ResourceDataSyncS3Destination;
  SyncType?: string;
  SyncSource?: ResourceDataSyncSource;
}
export interface CreateResourceDataSyncResult {}
export declare class ResourceDataSyncAlreadyExistsException extends __BaseException {
  readonly name: "ResourceDataSyncAlreadyExistsException";
  readonly $fault: "client";
  SyncName?: string;
  constructor(
    opts: __ExceptionOptionType<
      ResourceDataSyncAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class ResourceDataSyncCountExceededException extends __BaseException {
  readonly name: "ResourceDataSyncCountExceededException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      ResourceDataSyncCountExceededException,
      __BaseException
    >
  );
}
export declare class ResourceDataSyncInvalidConfigurationException extends __BaseException {
  readonly name: "ResourceDataSyncInvalidConfigurationException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      ResourceDataSyncInvalidConfigurationException,
      __BaseException
    >
  );
}
export interface DeleteActivationRequest {
  ActivationId: string | undefined;
}
export interface DeleteActivationResult {}
export declare class InvalidActivation extends __BaseException {
  readonly name: "InvalidActivation";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidActivation, __BaseException>);
}
export declare class InvalidActivationId extends __BaseException {
  readonly name: "InvalidActivationId";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidActivationId, __BaseException>
  );
}
export declare class AssociationDoesNotExist extends __BaseException {
  readonly name: "AssociationDoesNotExist";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<AssociationDoesNotExist, __BaseException>
  );
}
export interface DeleteAssociationRequest {
  Name?: string;
  InstanceId?: string;
  AssociationId?: string;
}
export interface DeleteAssociationResult {}
export declare class AssociatedInstances extends __BaseException {
  readonly name: "AssociatedInstances";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AssociatedInstances, __BaseException>
  );
}
export interface DeleteDocumentRequest {
  Name: string | undefined;
  DocumentVersion?: string;
  VersionName?: string;
  Force?: boolean;
}
export interface DeleteDocumentResult {}
export declare class InvalidDocumentOperation extends __BaseException {
  readonly name: "InvalidDocumentOperation";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidDocumentOperation, __BaseException>
  );
}
export declare const InventorySchemaDeleteOption: {
  readonly DELETE_SCHEMA: "DeleteSchema";
  readonly DISABLE_SCHEMA: "DisableSchema";
};
export type InventorySchemaDeleteOption =
  (typeof InventorySchemaDeleteOption)[keyof typeof InventorySchemaDeleteOption];
export interface DeleteInventoryRequest {
  TypeName: string | undefined;
  SchemaDeleteOption?: InventorySchemaDeleteOption | string;
  DryRun?: boolean;
  ClientToken?: string;
}
export interface InventoryDeletionSummaryItem {
  Version?: string;
  Count?: number;
  RemainingCount?: number;
}
export interface InventoryDeletionSummary {
  TotalCount?: number;
  RemainingCount?: number;
  SummaryItems?: InventoryDeletionSummaryItem[];
}
export interface DeleteInventoryResult {
  DeletionId?: string;
  TypeName?: string;
  DeletionSummary?: InventoryDeletionSummary;
}
export declare class InvalidDeleteInventoryParametersException extends __BaseException {
  readonly name: "InvalidDeleteInventoryParametersException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidDeleteInventoryParametersException,
      __BaseException
    >
  );
}
export declare class InvalidInventoryRequestException extends __BaseException {
  readonly name: "InvalidInventoryRequestException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      InvalidInventoryRequestException,
      __BaseException
    >
  );
}
export declare class InvalidOptionException extends __BaseException {
  readonly name: "InvalidOptionException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidOptionException, __BaseException>
  );
}
export declare class InvalidTypeNameException extends __BaseException {
  readonly name: "InvalidTypeNameException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidTypeNameException, __BaseException>
  );
}
export interface DeleteMaintenanceWindowRequest {
  WindowId: string | undefined;
}
export interface DeleteMaintenanceWindowResult {
  WindowId?: string;
}
export interface DeleteOpsMetadataRequest {
  OpsMetadataArn: string | undefined;
}
export interface DeleteOpsMetadataResult {}
export declare class OpsMetadataNotFoundException extends __BaseException {
  readonly name: "OpsMetadataNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<OpsMetadataNotFoundException, __BaseException>
  );
}
export interface DeleteParameterRequest {
  Name: string | undefined;
}
export interface DeleteParameterResult {}
export declare class ParameterNotFound extends __BaseException {
  readonly name: "ParameterNotFound";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<ParameterNotFound, __BaseException>);
}
export interface DeleteParametersRequest {
  Names: string[] | undefined;
}
export interface DeleteParametersResult {
  DeletedParameters?: string[];
  InvalidParameters?: string[];
}
export interface DeletePatchBaselineRequest {
  BaselineId: string | undefined;
}
export interface DeletePatchBaselineResult {
  BaselineId?: string;
}
export declare class ResourceInUseException extends __BaseException {
  readonly name: "ResourceInUseException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<ResourceInUseException, __BaseException>
  );
}
export interface DeleteResourceDataSyncRequest {
  SyncName: string | undefined;
  SyncType?: string;
}
export interface DeleteResourceDataSyncResult {}
export declare class ResourceDataSyncNotFoundException extends __BaseException {
  readonly name: "ResourceDataSyncNotFoundException";
  readonly $fault: "client";
  SyncName?: string;
  SyncType?: string;
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      ResourceDataSyncNotFoundException,
      __BaseException
    >
  );
}
export interface DeleteResourcePolicyRequest {
  ResourceArn: string | undefined;
  PolicyId: string | undefined;
  PolicyHash: string | undefined;
}
export interface DeleteResourcePolicyResponse {}
export declare class ResourcePolicyConflictException extends __BaseException {
  readonly name: "ResourcePolicyConflictException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      ResourcePolicyConflictException,
      __BaseException
    >
  );
}
export declare class ResourcePolicyInvalidParameterException extends __BaseException {
  readonly name: "ResourcePolicyInvalidParameterException";
  readonly $fault: "client";
  ParameterNames?: string[];
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      ResourcePolicyInvalidParameterException,
      __BaseException
    >
  );
}
export interface DeregisterManagedInstanceRequest {
  InstanceId: string | undefined;
}
export interface DeregisterManagedInstanceResult {}
export interface DeregisterPatchBaselineForPatchGroupRequest {
  BaselineId: string | undefined;
  PatchGroup: string | undefined;
}
export interface DeregisterPatchBaselineForPatchGroupResult {
  BaselineId?: string;
  PatchGroup?: string;
}
export interface DeregisterTargetFromMaintenanceWindowRequest {
  WindowId: string | undefined;
  WindowTargetId: string | undefined;
  Safe?: boolean;
}
export interface DeregisterTargetFromMaintenanceWindowResult {
  WindowId?: string;
  WindowTargetId?: string;
}
export declare class TargetInUseException extends __BaseException {
  readonly name: "TargetInUseException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<TargetInUseException, __BaseException>
  );
}
export interface DeregisterTaskFromMaintenanceWindowRequest {
  WindowId: string | undefined;
  WindowTaskId: string | undefined;
}
export interface DeregisterTaskFromMaintenanceWindowResult {
  WindowId?: string;
  WindowTaskId?: string;
}
export declare const DescribeActivationsFilterKeys: {
  readonly ACTIVATION_IDS: "ActivationIds";
  readonly DEFAULT_INSTANCE_NAME: "DefaultInstanceName";
  readonly IAM_ROLE: "IamRole";
};
export type DescribeActivationsFilterKeys =
  (typeof DescribeActivationsFilterKeys)[keyof typeof DescribeActivationsFilterKeys];
export interface DescribeActivationsFilter {
  FilterKey?: DescribeActivationsFilterKeys | string;
  FilterValues?: string[];
}
export interface DescribeActivationsRequest {
  Filters?: DescribeActivationsFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeActivationsResult {
  ActivationList?: Activation[];
  NextToken?: string;
}
export declare class InvalidFilter extends __BaseException {
  readonly name: "InvalidFilter";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidFilter, __BaseException>);
}
export declare class InvalidNextToken extends __BaseException {
  readonly name: "InvalidNextToken";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidNextToken, __BaseException>);
}
export interface DescribeAssociationRequest {
  Name?: string;
  InstanceId?: string;
  AssociationId?: string;
  AssociationVersion?: string;
}
export interface DescribeAssociationResult {
  AssociationDescription?: AssociationDescription;
}
export declare class InvalidAssociationVersion extends __BaseException {
  readonly name: "InvalidAssociationVersion";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidAssociationVersion, __BaseException>
  );
}
export declare const AssociationExecutionFilterKey: {
  readonly CreatedTime: "CreatedTime";
  readonly ExecutionId: "ExecutionId";
  readonly Status: "Status";
};
export type AssociationExecutionFilterKey =
  (typeof AssociationExecutionFilterKey)[keyof typeof AssociationExecutionFilterKey];
export declare const AssociationFilterOperatorType: {
  readonly Equal: "EQUAL";
  readonly GreaterThan: "GREATER_THAN";
  readonly LessThan: "LESS_THAN";
};
export type AssociationFilterOperatorType =
  (typeof AssociationFilterOperatorType)[keyof typeof AssociationFilterOperatorType];
export interface AssociationExecutionFilter {
  Key: AssociationExecutionFilterKey | string | undefined;
  Value: string | undefined;
  Type: AssociationFilterOperatorType | string | undefined;
}
export interface DescribeAssociationExecutionsRequest {
  AssociationId: string | undefined;
  Filters?: AssociationExecutionFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface AssociationExecution {
  AssociationId?: string;
  AssociationVersion?: string;
  ExecutionId?: string;
  Status?: string;
  DetailedStatus?: string;
  CreatedTime?: Date;
  LastExecutionDate?: Date;
  ResourceCountByStatus?: string;
  AlarmConfiguration?: AlarmConfiguration;
  TriggeredAlarms?: AlarmStateInformation[];
}
export interface DescribeAssociationExecutionsResult {
  AssociationExecutions?: AssociationExecution[];
  NextToken?: string;
}
export declare class AssociationExecutionDoesNotExist extends __BaseException {
  readonly name: "AssociationExecutionDoesNotExist";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      AssociationExecutionDoesNotExist,
      __BaseException
    >
  );
}
export declare const AssociationExecutionTargetsFilterKey: {
  readonly ResourceId: "ResourceId";
  readonly ResourceType: "ResourceType";
  readonly Status: "Status";
};
export type AssociationExecutionTargetsFilterKey =
  (typeof AssociationExecutionTargetsFilterKey)[keyof typeof AssociationExecutionTargetsFilterKey];
export interface AssociationExecutionTargetsFilter {
  Key: AssociationExecutionTargetsFilterKey | string | undefined;
  Value: string | undefined;
}
export interface DescribeAssociationExecutionTargetsRequest {
  AssociationId: string | undefined;
  ExecutionId: string | undefined;
  Filters?: AssociationExecutionTargetsFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface OutputSource {
  OutputSourceId?: string;
  OutputSourceType?: string;
}
export interface AssociationExecutionTarget {
  AssociationId?: string;
  AssociationVersion?: string;
  ExecutionId?: string;
  ResourceId?: string;
  ResourceType?: string;
  Status?: string;
  DetailedStatus?: string;
  LastExecutionDate?: Date;
  OutputSource?: OutputSource;
}
export interface DescribeAssociationExecutionTargetsResult {
  AssociationExecutionTargets?: AssociationExecutionTarget[];
  NextToken?: string;
}
export declare const AutomationExecutionFilterKey: {
  readonly AUTOMATION_SUBTYPE: "AutomationSubtype";
  readonly AUTOMATION_TYPE: "AutomationType";
  readonly CURRENT_ACTION: "CurrentAction";
  readonly DOCUMENT_NAME_PREFIX: "DocumentNamePrefix";
  readonly EXECUTION_ID: "ExecutionId";
  readonly EXECUTION_STATUS: "ExecutionStatus";
  readonly OPS_ITEM_ID: "OpsItemId";
  readonly PARENT_EXECUTION_ID: "ParentExecutionId";
  readonly START_TIME_AFTER: "StartTimeAfter";
  readonly START_TIME_BEFORE: "StartTimeBefore";
  readonly TAG_KEY: "TagKey";
  readonly TARGET_RESOURCE_GROUP: "TargetResourceGroup";
};
export type AutomationExecutionFilterKey =
  (typeof AutomationExecutionFilterKey)[keyof typeof AutomationExecutionFilterKey];
export interface AutomationExecutionFilter {
  Key: AutomationExecutionFilterKey | string | undefined;
  Values: string[] | undefined;
}
export interface DescribeAutomationExecutionsRequest {
  Filters?: AutomationExecutionFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export declare const AutomationExecutionStatus: {
  readonly APPROVED: "Approved";
  readonly CANCELLED: "Cancelled";
  readonly CANCELLING: "Cancelling";
  readonly CHANGE_CALENDAR_OVERRIDE_APPROVED: "ChangeCalendarOverrideApproved";
  readonly CHANGE_CALENDAR_OVERRIDE_REJECTED: "ChangeCalendarOverrideRejected";
  readonly COMPLETED_WITH_FAILURE: "CompletedWithFailure";
  readonly COMPLETED_WITH_SUCCESS: "CompletedWithSuccess";
  readonly FAILED: "Failed";
  readonly INPROGRESS: "InProgress";
  readonly PENDING: "Pending";
  readonly PENDING_APPROVAL: "PendingApproval";
  readonly PENDING_CHANGE_CALENDAR_OVERRIDE: "PendingChangeCalendarOverride";
  readonly REJECTED: "Rejected";
  readonly RUNBOOK_INPROGRESS: "RunbookInProgress";
  readonly SCHEDULED: "Scheduled";
  readonly SUCCESS: "Success";
  readonly TIMEDOUT: "TimedOut";
  readonly WAITING: "Waiting";
};
export type AutomationExecutionStatus =
  (typeof AutomationExecutionStatus)[keyof typeof AutomationExecutionStatus];
export declare const AutomationSubtype: {
  readonly ChangeRequest: "ChangeRequest";
};
export type AutomationSubtype =
  (typeof AutomationSubtype)[keyof typeof AutomationSubtype];
export declare const AutomationType: {
  readonly CrossAccount: "CrossAccount";
  readonly Local: "Local";
};
export type AutomationType =
  (typeof AutomationType)[keyof typeof AutomationType];
export declare const ExecutionMode: {
  readonly Auto: "Auto";
  readonly Interactive: "Interactive";
};
export type ExecutionMode = (typeof ExecutionMode)[keyof typeof ExecutionMode];
export interface ResolvedTargets {
  ParameterValues?: string[];
  Truncated?: boolean;
}
export interface Runbook {
  DocumentName: string | undefined;
  DocumentVersion?: string;
  Parameters?: Record<string, string[]>;
  TargetParameterName?: string;
  Targets?: Target[];
  TargetMaps?: Record<string, string[]>[];
  MaxConcurrency?: string;
  MaxErrors?: string;
  TargetLocations?: TargetLocation[];
}
export interface AutomationExecutionMetadata {
  AutomationExecutionId?: string;
  DocumentName?: string;
  DocumentVersion?: string;
  AutomationExecutionStatus?: AutomationExecutionStatus | string;
  ExecutionStartTime?: Date;
  ExecutionEndTime?: Date;
  ExecutedBy?: string;
  LogFile?: string;
  Outputs?: Record<string, string[]>;
  Mode?: ExecutionMode | string;
  ParentAutomationExecutionId?: string;
  CurrentStepName?: string;
  CurrentAction?: string;
  FailureMessage?: string;
  TargetParameterName?: string;
  Targets?: Target[];
  TargetMaps?: Record<string, string[]>[];
  ResolvedTargets?: ResolvedTargets;
  MaxConcurrency?: string;
  MaxErrors?: string;
  Target?: string;
  AutomationType?: AutomationType | string;
  AlarmConfiguration?: AlarmConfiguration;
  TriggeredAlarms?: AlarmStateInformation[];
  AutomationSubtype?: AutomationSubtype | string;
  ScheduledTime?: Date;
  Runbooks?: Runbook[];
  OpsItemId?: string;
  AssociationId?: string;
  ChangeRequestName?: string;
}
export interface DescribeAutomationExecutionsResult {
  AutomationExecutionMetadataList?: AutomationExecutionMetadata[];
  NextToken?: string;
}
export declare class InvalidFilterKey extends __BaseException {
  readonly name: "InvalidFilterKey";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidFilterKey, __BaseException>);
}
export declare class InvalidFilterValue extends __BaseException {
  readonly name: "InvalidFilterValue";
  readonly $fault: "client";
  Message?: string;
  constructor(opts: __ExceptionOptionType<InvalidFilterValue, __BaseException>);
}
export declare class AutomationExecutionNotFoundException extends __BaseException {
  readonly name: "AutomationExecutionNotFoundException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<
      AutomationExecutionNotFoundException,
      __BaseException
    >
  );
}
export declare const StepExecutionFilterKey: {
  readonly ACTION: "Action";
  readonly START_TIME_AFTER: "StartTimeAfter";
  readonly START_TIME_BEFORE: "StartTimeBefore";
  readonly STEP_EXECUTION_ID: "StepExecutionId";
  readonly STEP_EXECUTION_STATUS: "StepExecutionStatus";
  readonly STEP_NAME: "StepName";
};
export type StepExecutionFilterKey =
  (typeof StepExecutionFilterKey)[keyof typeof StepExecutionFilterKey];
export interface StepExecutionFilter {
  Key: StepExecutionFilterKey | string | undefined;
  Values: string[] | undefined;
}
export interface DescribeAutomationStepExecutionsRequest {
  AutomationExecutionId: string | undefined;
  Filters?: StepExecutionFilter[];
  NextToken?: string;
  MaxResults?: number;
  ReverseOrder?: boolean;
}
export interface FailureDetails {
  FailureStage?: string;
  FailureType?: string;
  Details?: Record<string, string[]>;
}
export interface StepExecution {
  StepName?: string;
  Action?: string;
  TimeoutSeconds?: number;
  OnFailure?: string;
  MaxAttempts?: number;
  ExecutionStartTime?: Date;
  ExecutionEndTime?: Date;
  StepStatus?: AutomationExecutionStatus | string;
  ResponseCode?: string;
  Inputs?: Record<string, string>;
  Outputs?: Record<string, string[]>;
  Response?: string;
  FailureMessage?: string;
  FailureDetails?: FailureDetails;
  StepExecutionId?: string;
  OverriddenParameters?: Record<string, string[]>;
  IsEnd?: boolean;
  NextStep?: string;
  IsCritical?: boolean;
  ValidNextSteps?: string[];
  Targets?: Target[];
  TargetLocation?: TargetLocation;
  TriggeredAlarms?: AlarmStateInformation[];
}
export interface DescribeAutomationStepExecutionsResult {
  StepExecutions?: StepExecution[];
  NextToken?: string;
}
export interface PatchOrchestratorFilter {
  Key?: string;
  Values?: string[];
}
export interface DescribeAvailablePatchesRequest {
  Filters?: PatchOrchestratorFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface Patch {
  Id?: string;
  ReleaseDate?: Date;
  Title?: string;
  Description?: string;
  ContentUrl?: string;
  Vendor?: string;
  ProductFamily?: string;
  Product?: string;
  Classification?: string;
  MsrcSeverity?: string;
  KbNumber?: string;
  MsrcNumber?: string;
  Language?: string;
  AdvisoryIds?: string[];
  BugzillaIds?: string[];
  CVEIds?: string[];
  Name?: string;
  Epoch?: number;
  Version?: string;
  Release?: string;
  Arch?: string;
  Severity?: string;
  Repository?: string;
}
export interface DescribeAvailablePatchesResult {
  Patches?: Patch[];
  NextToken?: string;
}
export interface DescribeDocumentRequest {
  Name: string | undefined;
  DocumentVersion?: string;
  VersionName?: string;
}
export interface DescribeDocumentResult {
  Document?: DocumentDescription;
}
export declare const DocumentPermissionType: {
  readonly SHARE: "Share";
};
export type DocumentPermissionType =
  (typeof DocumentPermissionType)[keyof typeof DocumentPermissionType];
export interface DescribeDocumentPermissionRequest {
  Name: string | undefined;
  PermissionType: DocumentPermissionType | string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface DescribeDocumentPermissionResponse {
  AccountIds?: string[];
  AccountSharingInfoList?: AccountSharingInfo[];
  NextToken?: string;
}
export declare class InvalidPermissionType extends __BaseException {
  readonly name: "InvalidPermissionType";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidPermissionType, __BaseException>
  );
}
export interface DescribeEffectiveInstanceAssociationsRequest {
  InstanceId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface InstanceAssociation {
  AssociationId?: string;
  InstanceId?: string;
  Content?: string;
  AssociationVersion?: string;
}
export interface DescribeEffectiveInstanceAssociationsResult {
  Associations?: InstanceAssociation[];
  NextToken?: string;
}
export interface DescribeEffectivePatchesForPatchBaselineRequest {
  BaselineId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export declare const PatchDeploymentStatus: {
  readonly Approved: "APPROVED";
  readonly ExplicitApproved: "EXPLICIT_APPROVED";
  readonly ExplicitRejected: "EXPLICIT_REJECTED";
  readonly PendingApproval: "PENDING_APPROVAL";
};
export type PatchDeploymentStatus =
  (typeof PatchDeploymentStatus)[keyof typeof PatchDeploymentStatus];
export interface PatchStatus {
  DeploymentStatus?: PatchDeploymentStatus | string;
  ComplianceLevel?: PatchComplianceLevel | string;
  ApprovalDate?: Date;
}
export interface EffectivePatch {
  Patch?: Patch;
  PatchStatus?: PatchStatus;
}
export interface DescribeEffectivePatchesForPatchBaselineResult {
  EffectivePatches?: EffectivePatch[];
  NextToken?: string;
}
export declare class UnsupportedOperatingSystem extends __BaseException {
  readonly name: "UnsupportedOperatingSystem";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<UnsupportedOperatingSystem, __BaseException>
  );
}
export interface DescribeInstanceAssociationsStatusRequest {
  InstanceId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface S3OutputUrl {
  OutputUrl?: string;
}
export interface InstanceAssociationOutputUrl {
  S3OutputUrl?: S3OutputUrl;
}
export interface InstanceAssociationStatusInfo {
  AssociationId?: string;
  Name?: string;
  DocumentVersion?: string;
  AssociationVersion?: string;
  InstanceId?: string;
  ExecutionDate?: Date;
  Status?: string;
  DetailedStatus?: string;
  ExecutionSummary?: string;
  ErrorCode?: string;
  OutputUrl?: InstanceAssociationOutputUrl;
  AssociationName?: string;
}
export interface DescribeInstanceAssociationsStatusResult {
  InstanceAssociationStatusInfos?: InstanceAssociationStatusInfo[];
  NextToken?: string;
}
export interface InstanceInformationStringFilter {
  Key: string | undefined;
  Values: string[] | undefined;
}
export declare const InstanceInformationFilterKey: {
  readonly ACTIVATION_IDS: "ActivationIds";
  readonly AGENT_VERSION: "AgentVersion";
  readonly ASSOCIATION_STATUS: "AssociationStatus";
  readonly IAM_ROLE: "IamRole";
  readonly INSTANCE_IDS: "InstanceIds";
  readonly PING_STATUS: "PingStatus";
  readonly PLATFORM_TYPES: "PlatformTypes";
  readonly RESOURCE_TYPE: "ResourceType";
};
export type InstanceInformationFilterKey =
  (typeof InstanceInformationFilterKey)[keyof typeof InstanceInformationFilterKey];
export interface InstanceInformationFilter {
  key: InstanceInformationFilterKey | string | undefined;
  valueSet: string[] | undefined;
}
export interface DescribeInstanceInformationRequest {
  InstanceInformationFilterList?: InstanceInformationFilter[];
  Filters?: InstanceInformationStringFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface InstanceAggregatedAssociationOverview {
  DetailedStatus?: string;
  InstanceAssociationStatusAggregatedCount?: Record<string, number>;
}
export declare const PingStatus: {
  readonly CONNECTION_LOST: "ConnectionLost";
  readonly INACTIVE: "Inactive";
  readonly ONLINE: "Online";
};
export type PingStatus = (typeof PingStatus)[keyof typeof PingStatus];
export declare const ResourceType: {
  readonly DOCUMENT: "Document";
  readonly EC2_INSTANCE: "EC2Instance";
  readonly MANAGED_INSTANCE: "ManagedInstance";
};
export type ResourceType = (typeof ResourceType)[keyof typeof ResourceType];
export declare const SourceType: {
  readonly AWS_EC2_INSTANCE: "AWS::EC2::Instance";
  readonly AWS_IOT_THING: "AWS::IoT::Thing";
  readonly AWS_SSM_MANAGEDINSTANCE: "AWS::SSM::ManagedInstance";
};
export type SourceType = (typeof SourceType)[keyof typeof SourceType];
export interface InstanceInformation {
  InstanceId?: string;
  PingStatus?: PingStatus | string;
  LastPingDateTime?: Date;
  AgentVersion?: string;
  IsLatestVersion?: boolean;
  PlatformType?: PlatformType | string;
  PlatformName?: string;
  PlatformVersion?: string;
  ActivationId?: string;
  IamRole?: string;
  RegistrationDate?: Date;
  ResourceType?: ResourceType | string;
  Name?: string;
  IPAddress?: string;
  ComputerName?: string;
  AssociationStatus?: string;
  LastAssociationExecutionDate?: Date;
  LastSuccessfulAssociationExecutionDate?: Date;
  AssociationOverview?: InstanceAggregatedAssociationOverview;
  SourceId?: string;
  SourceType?: SourceType | string;
}
export interface DescribeInstanceInformationResult {
  InstanceInformationList?: InstanceInformation[];
  NextToken?: string;
}
export declare class InvalidInstanceInformationFilterValue extends __BaseException {
  readonly name: "InvalidInstanceInformationFilterValue";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidInstanceInformationFilterValue,
      __BaseException
    >
  );
}
export interface DescribeInstancePatchesRequest {
  InstanceId: string | undefined;
  Filters?: PatchOrchestratorFilter[];
  NextToken?: string;
  MaxResults?: number;
}
export declare const PatchComplianceDataState: {
  readonly Failed: "FAILED";
  readonly Installed: "INSTALLED";
  readonly InstalledOther: "INSTALLED_OTHER";
  readonly InstalledPendingReboot: "INSTALLED_PENDING_REBOOT";
  readonly InstalledRejected: "INSTALLED_REJECTED";
  readonly Missing: "MISSING";
  readonly NotApplicable: "NOT_APPLICABLE";
};
export type PatchComplianceDataState =
  (typeof PatchComplianceDataState)[keyof typeof PatchComplianceDataState];
export interface PatchComplianceData {
  Title: string | undefined;
  KBId: string | undefined;
  Classification: string | undefined;
  Severity: string | undefined;
  State: PatchComplianceDataState | string | undefined;
  InstalledTime: Date | undefined;
  CVEIds?: string;
}
export interface DescribeInstancePatchesResult {
  Patches?: PatchComplianceData[];
  NextToken?: string;
}
export interface DescribeInstancePatchStatesRequest {
  InstanceIds: string[] | undefined;
  NextToken?: string;
  MaxResults?: number;
}
export declare const PatchOperationType: {
  readonly INSTALL: "Install";
  readonly SCAN: "Scan";
};
export type PatchOperationType =
  (typeof PatchOperationType)[keyof typeof PatchOperationType];
export declare const RebootOption: {
  readonly NO_REBOOT: "NoReboot";
  readonly REBOOT_IF_NEEDED: "RebootIfNeeded";
};
export type RebootOption = (typeof RebootOption)[keyof typeof RebootOption];
export interface InstancePatchState {
  InstanceId: string | undefined;
  PatchGroup: string | undefined;
  BaselineId: string | undefined;
  SnapshotId?: string;
  InstallOverrideList?: string;
  OwnerInformation?: string;
  InstalledCount?: number;
  InstalledOtherCount?: number;
  InstalledPendingRebootCount?: number;
  InstalledRejectedCount?: number;
  MissingCount?: number;
  FailedCount?: number;
  UnreportedNotApplicableCount?: number;
  NotApplicableCount?: number;
  OperationStartTime: Date | undefined;
  OperationEndTime: Date | undefined;
  Operation: PatchOperationType | string | undefined;
  LastNoRebootInstallOperationTime?: Date;
  RebootOption?: RebootOption | string;
  CriticalNonCompliantCount?: number;
  SecurityNonCompliantCount?: number;
  OtherNonCompliantCount?: number;
}
export interface DescribeInstancePatchStatesResult {
  InstancePatchStates?: InstancePatchState[];
  NextToken?: string;
}
export declare const InstancePatchStateOperatorType: {
  readonly EQUAL: "Equal";
  readonly GREATER_THAN: "GreaterThan";
  readonly LESS_THAN: "LessThan";
  readonly NOT_EQUAL: "NotEqual";
};
export type InstancePatchStateOperatorType =
  (typeof InstancePatchStateOperatorType)[keyof typeof InstancePatchStateOperatorType];
export interface InstancePatchStateFilter {
  Key: string | undefined;
  Values: string[] | undefined;
  Type: InstancePatchStateOperatorType | string | undefined;
}
export interface DescribeInstancePatchStatesForPatchGroupRequest {
  PatchGroup: string | undefined;
  Filters?: InstancePatchStateFilter[];
  NextToken?: string;
  MaxResults?: number;
}
export interface DescribeInstancePatchStatesForPatchGroupResult {
  InstancePatchStates?: InstancePatchState[];
  NextToken?: string;
}
export interface DescribeInventoryDeletionsRequest {
  DeletionId?: string;
  NextToken?: string;
  MaxResults?: number;
}
export declare const InventoryDeletionStatus: {
  readonly COMPLETE: "Complete";
  readonly IN_PROGRESS: "InProgress";
};
export type InventoryDeletionStatus =
  (typeof InventoryDeletionStatus)[keyof typeof InventoryDeletionStatus];
export interface InventoryDeletionStatusItem {
  DeletionId?: string;
  TypeName?: string;
  DeletionStartTime?: Date;
  LastStatus?: InventoryDeletionStatus | string;
  LastStatusMessage?: string;
  DeletionSummary?: InventoryDeletionSummary;
  LastStatusUpdateTime?: Date;
}
export interface DescribeInventoryDeletionsResult {
  InventoryDeletions?: InventoryDeletionStatusItem[];
  NextToken?: string;
}
export declare class InvalidDeletionIdException extends __BaseException {
  readonly name: "InvalidDeletionIdException";
  readonly $fault: "client";
  Message?: string;
  constructor(
    opts: __ExceptionOptionType<InvalidDeletionIdException, __BaseException>
  );
}
export interface MaintenanceWindowFilter {
  Key?: string;
  Values?: string[];
}
export interface DescribeMaintenanceWindowExecutionsRequest {
  WindowId: string | undefined;
  Filters?: MaintenanceWindowFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export declare const MaintenanceWindowExecutionStatus: {
  readonly Cancelled: "CANCELLED";
  readonly Cancelling: "CANCELLING";
  readonly Failed: "FAILED";
  readonly InProgress: "IN_PROGRESS";
  readonly Pending: "PENDING";
  readonly SkippedOverlapping: "SKIPPED_OVERLAPPING";
  readonly Success: "SUCCESS";
  readonly TimedOut: "TIMED_OUT";
};
export type MaintenanceWindowExecutionStatus =
  (typeof MaintenanceWindowExecutionStatus)[keyof typeof MaintenanceWindowExecutionStatus];
export interface MaintenanceWindowExecution {
  WindowId?: string;
  WindowExecutionId?: string;
  Status?: MaintenanceWindowExecutionStatus | string;
  StatusDetails?: string;
  StartTime?: Date;
  EndTime?: Date;
}
export interface DescribeMaintenanceWindowExecutionsResult {
  WindowExecutions?: MaintenanceWindowExecution[];
  NextToken?: string;
}
export interface DescribeMaintenanceWindowExecutionTaskInvocationsRequest {
  WindowExecutionId: string | undefined;
  TaskId: string | undefined;
  Filters?: MaintenanceWindowFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export declare const MaintenanceWindowTaskType: {
  readonly Automation: "AUTOMATION";
  readonly Lambda: "LAMBDA";
  readonly RunCommand: "RUN_COMMAND";
  readonly StepFunctions: "STEP_FUNCTIONS";
};
export type MaintenanceWindowTaskType =
  (typeof MaintenanceWindowTaskType)[keyof typeof MaintenanceWindowTaskType];
export interface MaintenanceWindowExecutionTaskInvocationIdentity {
  WindowExecutionId?: string;
  TaskExecutionId?: string;
  InvocationId?: string;
  ExecutionId?: string;
  TaskType?: MaintenanceWindowTaskType | string;
  Parameters?: string;
  Status?: MaintenanceWindowExecutionStatus | string;
  StatusDetails?: string;
  StartTime?: Date;
  EndTime?: Date;
  OwnerInformation?: string;
  WindowTargetId?: string;
}
export interface DescribeMaintenanceWindowExecutionTaskInvocationsResult {
  WindowExecutionTaskInvocationIdentities?: MaintenanceWindowExecutionTaskInvocationIdentity[];
  NextToken?: string;
}
export interface DescribeMaintenanceWindowExecutionTasksRequest {
  WindowExecutionId: string | undefined;
  Filters?: MaintenanceWindowFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface MaintenanceWindowExecutionTaskIdentity {
  WindowExecutionId?: string;
  TaskExecutionId?: string;
  Status?: MaintenanceWindowExecutionStatus | string;
  StatusDetails?: string;
  StartTime?: Date;
  EndTime?: Date;
  TaskArn?: string;
  TaskType?: MaintenanceWindowTaskType | string;
  AlarmConfiguration?: AlarmConfiguration;
  TriggeredAlarms?: AlarmStateInformation[];
}
export interface DescribeMaintenanceWindowExecutionTasksResult {
  WindowExecutionTaskIdentities?: MaintenanceWindowExecutionTaskIdentity[];
  NextToken?: string;
}
export interface DescribeMaintenanceWindowsRequest {
  Filters?: MaintenanceWindowFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface MaintenanceWindowIdentity {
  WindowId?: string;
  Name?: string;
  Description?: string;
  Enabled?: boolean;
  Duration?: number;
  Cutoff?: number;
  Schedule?: string;
  ScheduleTimezone?: string;
  ScheduleOffset?: number;
  EndDate?: string;
  StartDate?: string;
  NextExecutionTime?: string;
}
export interface DescribeMaintenanceWindowsResult {
  WindowIdentities?: MaintenanceWindowIdentity[];
  NextToken?: string;
}
export declare const MaintenanceWindowResourceType: {
  readonly Instance: "INSTANCE";
  readonly ResourceGroup: "RESOURCE_GROUP";
};
export type MaintenanceWindowResourceType =
  (typeof MaintenanceWindowResourceType)[keyof typeof MaintenanceWindowResourceType];
export interface DescribeMaintenanceWindowScheduleRequest {
  WindowId?: string;
  Targets?: Target[];
  ResourceType?: MaintenanceWindowResourceType | string;
  Filters?: PatchOrchestratorFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface ScheduledWindowExecution {
  WindowId?: string;
  Name?: string;
  ExecutionTime?: string;
}
export interface DescribeMaintenanceWindowScheduleResult {
  ScheduledWindowExecutions?: ScheduledWindowExecution[];
  NextToken?: string;
}
export interface DescribeMaintenanceWindowsForTargetRequest {
  Targets: Target[] | undefined;
  ResourceType: MaintenanceWindowResourceType | string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface MaintenanceWindowIdentityForTarget {
  WindowId?: string;
  Name?: string;
}
export interface DescribeMaintenanceWindowsForTargetResult {
  WindowIdentities?: MaintenanceWindowIdentityForTarget[];
  NextToken?: string;
}
export interface DescribeMaintenanceWindowTargetsRequest {
  WindowId: string | undefined;
  Filters?: MaintenanceWindowFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export interface MaintenanceWindowTarget {
  WindowId?: string;
  WindowTargetId?: string;
  ResourceType?: MaintenanceWindowResourceType | string;
  Targets?: Target[];
  OwnerInformation?: string;
  Name?: string;
  Description?: string;
}
export interface DescribeMaintenanceWindowTargetsResult {
  Targets?: MaintenanceWindowTarget[];
  NextToken?: string;
}
export interface DescribeMaintenanceWindowTasksRequest {
  WindowId: string | undefined;
  Filters?: MaintenanceWindowFilter[];
  MaxResults?: number;
  NextToken?: string;
}
export declare const MaintenanceWindowTaskCutoffBehavior: {
  readonly CancelTask: "CANCEL_TASK";
  readonly ContinueTask: "CONTINUE_TASK";
};
export type MaintenanceWindowTaskCutoffBehavior =
  (typeof MaintenanceWindowTaskCutoffBehavior)[keyof typeof MaintenanceWindowTaskCutoffBehavior];
export interface LoggingInfo {
  S3BucketName: string | undefined;
  S3KeyPrefix?: string;
  S3Region: string | undefined;
}
export interface MaintenanceWindowTaskParameterValueExpression {
  Values?: string[];
}
export interface MaintenanceWindowTask {
  WindowId?: string;
  WindowTaskId?: string;
  TaskArn?: string;
  Type?: MaintenanceWindowTaskType | string;
  Targets?: Target[];
  TaskParameters?: Record<
    string,
    MaintenanceWindowTaskParameterValueExpression
  >;
  Priority?: number;
  LoggingInfo?: LoggingInfo;
  ServiceRoleArn?: string;
  MaxConcurrency?: string;
  MaxErrors?: string;
  Name?: string;
  Description?: string;
  CutoffBehavior?: MaintenanceWindowTaskCutoffBehavior | string;
  AlarmConfiguration?: AlarmConfiguration;
}
export interface DescribeMaintenanceWindowTasksResult {
  Tasks?: MaintenanceWindowTask[];
  NextToken?: string;
}
export declare const OpsItemFilterKey: {
  readonly ACCOUNT_ID: "AccountId";
  readonly ACTUAL_END_TIME: "ActualEndTime";
  readonly ACTUAL_START_TIME: "ActualStartTime";
  readonly AUTOMATION_ID: "AutomationId";
  readonly CATEGORY: "Category";
  readonly CHANGE_REQUEST_APPROVER_ARN: "ChangeRequestByApproverArn";
  readonly CHANGE_REQUEST_APPROVER_NAME: "ChangeRequestByApproverName";
  readonly CHANGE_REQUEST_REQUESTER_ARN: "ChangeRequestByRequesterArn";
  readonly CHANGE_REQUEST_REQUESTER_NAME: "ChangeRequestByRequesterName";
  readonly CHANGE_REQUEST_TARGETS_RESOURCE_GROUP: "ChangeRequestByTargetsResourceGroup";
  readonly CHANGE_REQUEST_TEMPLATE: "ChangeRequestByTemplate";
  readonly CREATED_BY: "CreatedBy";
  readonly CREATED_TIME: "CreatedTime";
  readonly INSIGHT_TYPE: "InsightByType";
  readonly LAST_MODIFIED_TIME: "LastModifiedTime";
  readonly OPERATIONAL_DATA: "OperationalData";
  readonly OPERATIONAL_DATA_KEY: "OperationalDataKey";
  readonly OPERATIONAL_DATA_VALUE: "OperationalDataValue";
  readonly OPSITEM_ID: "OpsItemId";
  readonly OPSITEM_TYPE: "OpsItemType";
  readonly PLANNED_END_TIME: "PlannedEndTime";
  readonly PLANNED_START_TIME: "PlannedStartTime";
  readonly PRIORITY: "Priority";
  readonly RESOURCE_ID: "ResourceId";
  readonly SEVERITY: "Severity";
  readonly SOURCE: "Source";
  readonly STATUS: "Status";
  readonly TITLE: "Title";
};
export type OpsItemFilterKey =
  (typeof OpsItemFilterKey)[keyof typeof OpsItemFilterKey];
export declare const OpsItemFilterOperator: {
  readonly CONTAINS: "Contains";
  readonly EQUAL: "Equal";
  readonly GREATER_THAN: "GreaterThan";
  readonly LESS_THAN: "LessThan";
};
export type OpsItemFilterOperator =
  (typeof OpsItemFilterOperator)[keyof typeof OpsItemFilterOperator];
export declare const CreateAssociationRequestFilterSensitiveLog: (
  obj: CreateAssociationRequest
) => any;
export declare const AssociationDescriptionFilterSensitiveLog: (
  obj: AssociationDescription
) => any;
export declare const CreateAssociationResultFilterSensitiveLog: (
  obj: CreateAssociationResult
) => any;
export declare const CreateAssociationBatchRequestEntryFilterSensitiveLog: (
  obj: CreateAssociationBatchRequestEntry
) => any;
export declare const CreateAssociationBatchRequestFilterSensitiveLog: (
  obj: CreateAssociationBatchRequest
) => any;
export declare const FailedCreateAssociationFilterSensitiveLog: (
  obj: FailedCreateAssociation
) => any;
export declare const CreateAssociationBatchResultFilterSensitiveLog: (
  obj: CreateAssociationBatchResult
) => any;
export declare const CreateMaintenanceWindowRequestFilterSensitiveLog: (
  obj: CreateMaintenanceWindowRequest
) => any;
export declare const PatchSourceFilterSensitiveLog: (obj: PatchSource) => any;
export declare const CreatePatchBaselineRequestFilterSensitiveLog: (
  obj: CreatePatchBaselineRequest
) => any;
export declare const DescribeAssociationResultFilterSensitiveLog: (
  obj: DescribeAssociationResult
) => any;
export declare const InstancePatchStateFilterSensitiveLog: (
  obj: InstancePatchState
) => any;
export declare const DescribeInstancePatchStatesResultFilterSensitiveLog: (
  obj: DescribeInstancePatchStatesResult
) => any;
export declare const DescribeInstancePatchStatesForPatchGroupResultFilterSensitiveLog: (
  obj: DescribeInstancePatchStatesForPatchGroupResult
) => any;
export declare const MaintenanceWindowExecutionTaskInvocationIdentityFilterSensitiveLog: (
  obj: MaintenanceWindowExecutionTaskInvocationIdentity
) => any;
export declare const DescribeMaintenanceWindowExecutionTaskInvocationsResultFilterSensitiveLog: (
  obj: DescribeMaintenanceWindowExecutionTaskInvocationsResult
) => any;
export declare const MaintenanceWindowIdentityFilterSensitiveLog: (
  obj: MaintenanceWindowIdentity
) => any;
export declare const DescribeMaintenanceWindowsResultFilterSensitiveLog: (
  obj: DescribeMaintenanceWindowsResult
) => any;
export declare const MaintenanceWindowTargetFilterSensitiveLog: (
  obj: MaintenanceWindowTarget
) => any;
export declare const DescribeMaintenanceWindowTargetsResultFilterSensitiveLog: (
  obj: DescribeMaintenanceWindowTargetsResult
) => any;
export declare const MaintenanceWindowTaskParameterValueExpressionFilterSensitiveLog: (
  obj: MaintenanceWindowTaskParameterValueExpression
) => any;
export declare const MaintenanceWindowTaskFilterSensitiveLog: (
  obj: MaintenanceWindowTask
) => any;
export declare const DescribeMaintenanceWindowTasksResultFilterSensitiveLog: (
  obj: DescribeMaintenanceWindowTasksResult
) => any;
