#!/usr/bin/python
# -*- coding: utf-8 -*-

# Hive Budy
# Copyright (c) 2008-2020 Hive Solutions Lda.
#
# This file is part of Hive Budy.
#
# Hive Budy is free software: you can redistribute it and/or modify
# it under the terms of the Apache License as published by the Apache
# Foundation, either version 2.0 of the License, or (at your option) any
# later version.
#
# Hive Budy is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# Apache License for more details.
#
# You should have received a copy of the Apache License along with
# Hive Budy. If not, see <http://www.apache.org/licenses/>.

__version__ = "1.0.0"
""" The version of the module """

__revision__ = "$LastChangedRevision$"
""" The revision number of the module """

__date__ = "$LastChangedDate$"
""" The last change date of the module """

__copyright__ = "Copyright (c) 2008-2020 Hive Solutions Lda."
""" The copyright for the module """

__license__ = "Apache License, Version 2.0"
""" The license for the module """

from . import account
from . import address
from . import bag_line
from . import bag
from . import base
from . import brand
from . import bundle_line
from . import bundle
from . import category
from . import collection
from . import color
from . import composition
from . import country
from . import currency
from . import exchange_rate
from . import group
from . import live_model
from . import measurement
from . import media
from . import order_line
from . import order
from . import product
from . import referral
from . import season
from . import section
from . import store
from . import subscription
from . import voucher
from . import wishlist_line
from . import wishlist

from .account import BudyAccount
from .address import Address
from .bag_line import BagLine
from .bag import Bag
from .base import BudyBase
from .brand import Brand
from .bundle import Bundle
from .bundle_line import BundleLine
from .category import Category
from .collection import Collection
from .color import Color
from .composition import Composition
from .country import Country
from .currency import Currency
from .exchange_rate import ExchangeRate
from .group import Group
from .live_model import LiveModel
from .measurement import Measurement
from .media import Media
from .order_line import OrderLine
from .order import Order
from .product import Product
from .referral import Referral
from .season import Season
from .section import Section
from .store import Store
from .subscription import Subscription
from .voucher import Voucher
from .wishlist_line import WishlistLine
from .wishlist import Wishlist
