/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.util.agent;

import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"logger", "Lorg/jetbrains/projector/util/logging/Logger;", "attachAgent", "", "agentJarPath", "", "args", "copyAgentToTempJarAndAttach", "agentJar", "Ljava/io/InputStream;", "projector-util-agent"})
public final class MiscKt {
    private static final Logger logger = LoggerKt.Logger((String)"util.agent.MiscKt");

    public static final void attachAgent(@NotNull String agentJarPath, @Nullable String args) {
        Intrinsics.checkNotNullParameter((Object)agentJarPath, (String)"agentJarPath");
        Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(agentJarPath, args){
            final /* synthetic */ String $agentJarPath;
            final /* synthetic */ String $args;

            @NotNull
            public final String invoke() {
                return "dynamically attaching agent: jar=" + this.$agentJarPath + ", args=" + this.$args;
            }
            {
                this.$agentJarPath = string;
                this.$args = string2;
                super(0);
            }
        }), (int)1, null);
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeMXBean, (String)"ManagementFactory.getRuntimeMXBean()");
        String string = runtimeMXBean.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ManagementFactory.getRuntimeMXBean().name");
        String pidOfRunningVM = StringsKt.substringBefore$default((String)string, (char)'@', null, (int)2, null);
        try {
            VirtualMachine virtualMachine = VirtualMachine.attach(pidOfRunningVM);
            Intrinsics.checkNotNull((Object)virtualMachine);
            VirtualMachine virtualMachine2 = virtualMachine;
            boolean bl = false;
            boolean bl2 = false;
            VirtualMachine $this$apply = virtualMachine2;
            boolean bl3 = false;
            $this$apply.loadAgent(agentJarPath, args);
            $this$apply.detach();
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
        Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(agentJarPath, args){
            final /* synthetic */ String $agentJarPath;
            final /* synthetic */ String $args;

            @NotNull
            public final String invoke() {
                return "dynamically attaching agent is done: jar=" + this.$agentJarPath + ", args=" + this.$args;
            }
            {
                this.$agentJarPath = string;
                this.$args = string2;
                super(0);
            }
        }), (int)1, null);
    }

    public static final void copyAgentToTempJarAndAttach(@NotNull InputStream agentJar, @Nullable String args) {
        File tempJar;
        Intrinsics.checkNotNullParameter((Object)agentJar, (String)"agentJar");
        File file = File.createTempFile("projector-agent", ".jar");
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file;
        boolean bl3 = false;
        $this$apply.deleteOnExit();
        File file2 = tempJar = file;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tempJar");
        file = file2;
        bl = false;
        agentJar.transferTo(new FileOutputStream(file));
        String string = tempJar.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tempJar.absolutePath");
        MiscKt.attachAgent(string, args);
    }
}

