/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.data.Direction;
import org.jetbrains.projector.awt.image.PGraphics2D;
import org.jetbrains.projector.awt.service.ImageCacher;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ?2\u00020\u0001:\u0002?@B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000203J\u0016\u00105\u001a\u0002032\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0010J\u0006\u00108\u001a\u000203J\u001e\u00109\u001a\u0002032\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00102\u0006\u0010:\u001a\u00020;J\u0006\u0010<\u001a\u000203J\u0006\u0010=\u001a\u000203J\u0006\u0010>\u001a\u000203R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R.\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00142\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR)\u0010!\u001a\u0010\u0012\f\u0012\n #*\u0004\u0018\u00010\u00000\u00000\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0011\u00100\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u001e\u00a8\u0006A"}, d2={"Lorg/jetbrains/projector/awt/PWindow;", "", "target", "Ljava/awt/Component;", "(Ljava/awt/Component;)V", "cursor", "Ljava/awt/Cursor;", "getCursor", "()Ljava/awt/Cursor;", "setCursor", "(Ljava/awt/Cursor;)V", "graphics", "Lorg/jetbrains/projector/awt/image/PGraphics2D;", "getGraphics", "()Lorg/jetbrains/projector/awt/image/PGraphics2D;", "headerHeight", "", "getHeaderHeight", "()Ljava/lang/Integer;", "<set-?>", "", "icons", "getIcons", "()Ljava/util/List;", "id", "getId", "()I", "modal", "", "getModal", "()Z", "resizable", "getResizable", "self", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getSelf", "()Ljava/lang/ref/WeakReference;", "self$delegate", "Lkotlin/Lazy;", "getTarget", "()Ljava/awt/Component;", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "undecorated", "getUndecorated", "close", "", "dispose", "move", "deltaX", "deltaY", "repaint", "resize", "direction", "Lorg/jetbrains/projector/awt/data/Direction;", "toBack", "toFront", "updateIcons", "Companion", "Descriptor", "projector-awt"})
public final class PWindow {
    private final int id;
    @Nullable
    private String title;
    private final boolean resizable;
    private final boolean modal;
    private final boolean undecorated;
    @Nullable
    private List<? extends Object> icons;
    private final Lazy self$delegate;
    @Nullable
    private Cursor cursor;
    @NotNull
    private final PGraphics2D graphics;
    @NotNull
    private final Component target;
    private static ArrayDeque<WeakReference<PWindow>> weakWindows;
    public static final Companion Companion;

    public final int getId() {
        return this.id;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@Nullable String string) {
        this.title = string;
    }

    public final boolean getResizable() {
        return this.resizable;
    }

    public final boolean getModal() {
        return this.modal;
    }

    public final boolean getUndecorated() {
        return this.undecorated;
    }

    @Nullable
    public final List<Object> getIcons() {
        return this.icons;
    }

    @Nullable
    public final Integer getHeaderHeight() {
        Integer n;
        Component component = this.target;
        if (component instanceof Container) {
            Insets insets = ((Container)this.target).getInsets();
            n = insets != null ? insets.top : 0;
        } else {
            n = null;
        }
        return n;
    }

    private final WeakReference<PWindow> getSelf() {
        Lazy lazy = this.self$delegate;
        PWindow pWindow = this;
        Object var3_3 = null;
        boolean bl = false;
        return (WeakReference)lazy.getValue();
    }

    @Nullable
    public final Cursor getCursor() {
        return this.cursor;
    }

    public final void setCursor(@Nullable Cursor cursor) {
        this.cursor = cursor;
    }

    @NotNull
    public final PGraphics2D getGraphics() {
        return this.graphics;
    }

    public final void move(int deltaX, int deltaY) {
        this.toFront();
        this.target.requestFocusInWindow();
        this.target.setLocation(this.target.getX() + deltaX, this.target.getY() + deltaY);
        this.repaint();
    }

    public final void resize(int deltaX, int deltaY, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.toFront();
        this.target.requestFocusInWindow();
        if (direction == Direction.E || direction == Direction.S || direction == Direction.SE) {
            this.target.setSize(this.target.getSize().width + deltaX, this.target.getSize().height + deltaY);
        } else if (direction == Direction.SW) {
            this.target.setBounds(this.target.getX() + deltaX, this.target.getY(), this.target.getWidth() - deltaX, this.target.getSize().height + deltaY);
        } else if (direction == Direction.NE) {
            this.target.setBounds(this.target.getX(), this.target.getY() + deltaY, this.target.getWidth() + deltaX, this.target.getHeight() - deltaY);
        } else {
            this.target.setBounds(this.target.getX() + deltaX, this.target.getY() + deltaY, this.target.getWidth() - deltaX, this.target.getHeight() - deltaY);
        }
        this.target.revalidate();
        this.repaint();
    }

    public final void close() {
        block1: {
            Component component = this.target;
            if (!(component instanceof Window)) {
                component = null;
            }
            Window window = (Window)component;
            if (window == null) break block1;
            window.dispose();
        }
    }

    public final void repaint() {
        this.target.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateIcons() {
        List list;
        Object object;
        PWindow pWindow = this;
        Component component = this.target;
        if (!(component instanceof Window)) {
            component = null;
        }
        if ((object = (Window)component) != null && (object = ((Window)object).getIconImages()) != null) {
            Collection<Object> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)object;
            PWindow pWindow2 = pWindow;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Image image = (Image)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ImageCacher imageCacher = ImageCacher.Companion.getInstance();
                void v4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                Object object2 = imageCacher.getImageId((Image)v4, "updateIcons");
                collection.add(object2);
            }
            collection = (List)destination$iv$iv;
            pWindow = pWindow2;
            list = collection;
        } else {
            list = null;
        }
        pWindow.icons = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void toFront() {
        ArrayDeque<WeakReference<PWindow>> arrayDeque = weakWindows;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (arrayDeque) {
            boolean bl3 = false;
            if (Intrinsics.areEqual(weakWindows.getLast(), this.getSelf()) ^ true) {
                weakWindows.remove(this.getSelf());
                weakWindows.addLast(this.getSelf());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void toBack() {
        ArrayDeque<WeakReference<PWindow>> arrayDeque = weakWindows;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (arrayDeque) {
            boolean bl3 = false;
            if (Intrinsics.areEqual(weakWindows.getFirst(), this.getSelf()) ^ true) {
                weakWindows.remove(this.getSelf());
                weakWindows.addFirst(this.getSelf());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void dispose() {
        PWindow.Companion.disposeWindow(this);
    }

    @NotNull
    public final Component getTarget() {
        return this.target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public PWindow(@NotNull Component target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Serializable serializable = this.target = target;
        this.title = serializable instanceof Frame ? ((Frame)this.target).getTitle() : (serializable instanceof Dialog ? ((Dialog)this.target).getTitle() : null);
        serializable = this.target;
        this.resizable = serializable instanceof Frame ? ((Frame)this.target).isResizable() : (serializable instanceof Dialog ? ((Dialog)this.target).isResizable() : false);
        serializable = this.target;
        this.modal = serializable instanceof Dialog ? ((Dialog)this.target).isModal() : false;
        serializable = this.target;
        this.undecorated = serializable instanceof Frame ? ((Frame)this.target).isUndecorated() : (serializable instanceof Dialog ? ((Dialog)this.target).isUndecorated() : true);
        this.updateIcons();
        this.self$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WeakReference<PWindow>>(this){
            final /* synthetic */ PWindow this$0;

            @NotNull
            public final WeakReference<PWindow> invoke() {
                return new WeakReference<PWindow>(this.this$0);
            }
            {
                this.this$0 = pWindow;
                super(0);
            }
        }));
        this.cursor = this.target.getCursor();
        serializable = weakWindows;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (serializable) {
            Object element$iv2;
            block5: {
                void $this$first$iv;
                void $this$mapNotNullTo$iv$iv;
                boolean bl3 = false;
                Iterable $this$mapNotNull$iv = weakWindows;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Integer n;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl4 = false;
                    WeakReference it = (WeakReference)element$iv$iv;
                    boolean bl5 = false;
                    PWindow pWindow = (PWindow)it.get();
                    if ((pWindow != null ? Integer.valueOf(pWindow.id) : null) == null) continue;
                    n = n;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Integer it$iv$iv = n;
                    boolean bl8 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Set usedIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                $this$mapNotNull$iv = SequencesKt.generateSequence((Object)0, (Function1)1.1.INSTANCE);
                PWindow pWindow = this;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    int it = ((Number)element$iv2).intValue();
                    boolean bl9 = false;
                    if (!(!usedIds.contains(it))) continue;
                    break block5;
                }
                throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            Object e = element$iv2;
            pWindow.id = ((Number)e).intValue();
            weakWindows.addLast(this.getSelf());
            Unit unit = Unit.INSTANCE;
        }
        this.graphics = new PGraphics2D(this.target, new Descriptor(this.id));
    }

    static {
        Companion = new Companion(null);
        weakWindows = new ArrayDeque();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/projector/awt/PWindow$Descriptor;", "", "windowId", "", "(I)V", "getWindowId", "()I", "projector-awt"})
    public static final class Descriptor {
        private final int windowId;

        public final int getWindowId() {
            return this.windowId;
        }

        public Descriptor(int windowId) {
            this.windowId = windowId;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/projector/awt/PWindow$Companion;", "", "()V", "weakWindows", "Ljava/util/ArrayDeque;", "Ljava/lang/ref/WeakReference;", "Lorg/jetbrains/projector/awt/PWindow;", "windows", "", "getWindows", "()Ljava/util/List;", "disposeWindow", "", "window", "getWindow", "windowId", "", "projector-awt"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<PWindow> getWindows() {
            List list;
            ArrayDeque arrayDeque = weakWindows;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (arrayDeque) {
                Iterable $this$mapNotNullTo$iv$iv;
                boolean bl3 = false;
                Iterable $this$mapNotNull$iv = weakWindows;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Object object = $this$forEach$iv$iv$iv.iterator();
                while (object.hasNext()) {
                    PWindow pWindow;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = object.next();
                    boolean bl4 = false;
                    WeakReference p1 = (WeakReference)element$iv$iv;
                    boolean bl5 = false;
                    if ((PWindow)p1.get() == null) continue;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    PWindow it$iv$iv = pWindow;
                    boolean bl8 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List windows = (List)destination$iv$iv;
                if (weakWindows.size() != windows.size()) {
                    Collection<WeakReference<void>> collection;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = windows;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void p1;
                        object = (PWindow)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl9 = false;
                        WeakReference<void> weakReference = new WeakReference<void>(p1);
                        collection.add(weakReference);
                    }
                    collection = (List)destination$iv$iv;
                    Collection collection2 = collection;
                    weakWindows = new ArrayDeque(collection2);
                }
                list = windows;
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void disposeWindow(PWindow window) {
            ArrayDeque arrayDeque = weakWindows;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (arrayDeque) {
                boolean bl3 = false;
                bl2 = weakWindows.removeIf((Predicate)new Predicate<WeakReference<PWindow>>(window){
                    final /* synthetic */ PWindow $window$inlined;
                    {
                        this.$window$inlined = pWindow;
                    }

                    public final boolean test(WeakReference<PWindow> it) {
                        return Intrinsics.areEqual((Object)((PWindow)it.get()), (Object)this.$window$inlined);
                    }
                });
            }
        }

        @Nullable
        public final PWindow getWindow(int windowId) {
            Object v0;
            block1: {
                Iterable iterable = this.getWindows();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    PWindow it = (PWindow)t;
                    boolean bl3 = false;
                    if (!(it.getId() == windowId)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

