/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.image.BufferedImage;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.awt.font.PFontManager;
import org.jetbrains.projector.awt.image.PGraphicsDevice;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SunGraphicsEnvironment;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0016\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0013\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u000eH\u0016\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001aH\u0014J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006%"}, d2={"Lorg/jetbrains/projector/awt/image/PGraphicsEnvironment;", "Lsun/java2d/SunGraphicsEnvironment;", "()V", "xResolution", "", "getXResolution", "()D", "yResolution", "getYResolution", "createGraphics", "Ljava/awt/Graphics2D;", "img", "Ljava/awt/image/BufferedImage;", "getAllFonts", "", "Ljava/awt/Font;", "()[Ljava/awt/Font;", "getAvailableFontFamilyNames", "", "()[Ljava/lang/String;", "requestedLocale", "Ljava/util/Locale;", "(Ljava/util/Locale;)[Ljava/lang/String;", "getDefaultScreenDevice", "Ljava/awt/GraphicsDevice;", "getNumScreens", "", "getScreenDevices", "()[Ljava/awt/GraphicsDevice;", "isDisplayLocal", "", "makeScreenDevice", "p0", "setSize", "", "width", "height", "projector-awt"})
public final class PGraphicsEnvironment
extends SunGraphicsEnvironment {
    private final double xResolution;
    private final double yResolution;

    public final double getXResolution() {
        return this.xResolution;
    }

    public final double getYResolution() {
        return this.yResolution;
    }

    @Override
    @NotNull
    public GraphicsDevice[] getScreenDevices() {
        return new GraphicsDevice[]{this.getDefaultScreenDevice()};
    }

    @Override
    @NotNull
    public GraphicsDevice getDefaultScreenDevice() {
        return PGraphicsDevice.INSTANCE;
    }

    @Override
    @NotNull
    public Graphics2D createGraphics(@NotNull BufferedImage img) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return new SunGraphics2D(BufImgSurfaceData.createData(img), Color.WHITE, Color.WHITE, (Font)ArraysKt.first((Object[])PFontManager.INSTANCE.getAllInstalledFonts()));
    }

    @Override
    @NotNull
    public Font[] getAllFonts() {
        return PFontManager.INSTANCE.getAllInstalledFonts();
    }

    @Override
    @NotNull
    public String[] getAvailableFontFamilyNames() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        return this.getAvailableFontFamilyNames(locale);
    }

    @Override
    @NotNull
    public String[] getAvailableFontFamilyNames(@NotNull Locale requestedLocale) {
        Intrinsics.checkNotNullParameter((Object)requestedLocale, (String)"requestedLocale");
        return PFontManager.INSTANCE.getInstalledFontFamilyNames(requestedLocale);
    }

    public final void setSize(int width, int height) {
        PGraphicsDevice.INSTANCE.getBounds().setSize(width, height);
    }

    @Override
    protected int getNumScreens() {
        return 1;
    }

    @Override
    public boolean isDisplayLocal() {
        return false;
    }

    @Override
    @NotNull
    protected GraphicsDevice makeScreenDevice(int p0) {
        return PGraphicsDevice.INSTANCE;
    }

    public PGraphicsEnvironment() {
        this.xResolution = 96.0;
        this.yResolution = 96.0;
    }
}

