/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.protocol.toClient.MainWindow;
import org.jetbrains.projector.common.protocol.toClient.MainWindowsEndpointKt;
import org.jetbrains.projector.server.core.util.GetRequestResult;
import org.jetbrains.projector.server.core.util.HttpWsServer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H&J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/projector/server/core/ProjectorHttpWsServer;", "Lorg/jetbrains/projector/server/core/util/HttpWsServer;", "port", "", "(I)V", "getMainWindows", "", "Lorg/jetbrains/projector/common/protocol/toClient/MainWindow;", "onGetRequest", "Lorg/jetbrains/projector/server/core/util/GetRequestResult;", "path", "", "Companion", "projector-server-core"})
public abstract class ProjectorHttpWsServer
extends HttpWsServer {
    private static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public final GetRequestResult onGetRequest(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String pathWithoutParams = StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)path, (char)'?', null, (int)2, null), (char)'#', null, (int)2, null);
        if (Intrinsics.areEqual((Object)pathWithoutParams, (Object)"/mainWindows")) {
            List<MainWindow> mainWindows = this.getMainWindows();
            String string = MainWindowsEndpointKt.toJson(mainWindows);
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] json = byArray;
            return new GetRequestResult(200, "OK", "text/json", json);
        }
        String resourceFileName = Companion.getResourceName(pathWithoutParams);
        byte[] resourceBytes = Companion.getResource(resourceFileName);
        if (resourceBytes != null) {
            return new GetRequestResult(200, "OK", ProjectorHttpWsServer.Companion.calculateContentType(resourceFileName), resourceBytes);
        }
        String string = "<h1>404 Not found requested path: " + path + "</h1>";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return new GetRequestResult(404, "Not found", "text/html", byArray);
    }

    @NotNull
    public abstract List<MainWindow> getMainWindows();

    public ProjectorHttpWsServer(int port) {
        super(port);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\f\u0010\t\u001a\u00020\u0006*\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/projector/server/core/ProjectorHttpWsServer$Companion;", "", "()V", "getResource", "", "resourceFileName", "", "getResourceName", "pathWithoutParams", "calculateContentType", "projector-server-core"})
    private static final class Companion {
        private final String calculateContentType(String $this$calculateContentType) {
            String string;
            String string2 = StringsKt.substringAfterLast$default((String)$this$calculateContentType, (char)'.', null, (int)2, null);
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            switch (string4) {
                case "css": {
                    string = "text/css";
                    break;
                }
                case "html": {
                    string = "text/html";
                    break;
                }
                case "js": {
                    string = "text/javascript";
                    break;
                }
                case "png": {
                    string = "image/png";
                    break;
                }
                case "svg": {
                    string = "image/svg+xml";
                    break;
                }
                case "webmanifest": {
                    string = "application/manifest+json";
                    break;
                }
                default: {
                    string = "application/octet-stream";
                }
            }
            return string;
        }

        @NotNull
        public final String getResourceName(@NotNull String pathWithoutParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter((Object)pathWithoutParams, (String)"pathWithoutParams");
            String string4 = pathWithoutParams;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            boolean bl4 = StringsKt.startsWith$default((String)it, (String)"/projector/", (boolean)false, (int)2, null);
            if (bl4) {
                string3 = StringsKt.removePrefix((String)it, (CharSequence)"/projector");
            } else if (!bl4) {
                string3 = it;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            string4 = string3;
            bl = false;
            bl2 = false;
            it = string4;
            boolean bl5 = false;
            bl4 = StringsKt.startsWith$default((String)it, (String)"/projector-client/", (boolean)false, (int)2, null);
            if (bl4) {
                string2 = StringsKt.removePrefix((String)it, (CharSequence)"/projector-client");
            } else if (!bl4) {
                string2 = it;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            string4 = string2;
            bl = false;
            bl2 = false;
            it = string4;
            boolean bl6 = false;
            bl4 = Intrinsics.areEqual((Object)it, (Object)"/");
            if (bl4) {
                string = "/index.html";
            } else if (!bl4) {
                string = it;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @Nullable
        public final byte[] getResource(@NotNull String resourceFileName) {
            Intrinsics.checkNotNullParameter((Object)resourceFileName, (String)"resourceFileName");
            URL uRL = this.getClass().getResource("/projector-client-web-distribution" + resourceFileName);
            return (byte[])(uRL != null ? TextStreamsKt.readBytes((URL)uRL) : null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

