/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.convert.toAwt;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.protocol.toServer.ClientKeyEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientKeyPressEvent;
import org.jetbrains.projector.common.protocol.toServer.KeyModifier;
import org.jetbrains.projector.server.core.convert.toAwt.JsKeysMapKt;
import org.jetbrains.projector.server.core.convert.toAwt.KeyKt$WhenMappings;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010\u000e\u001a\u00020\u0003*\u00020\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0003*\u00020\u0013H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"keyModifierMask", "", "Lorg/jetbrains/projector/common/protocol/toServer/KeyModifier;", "", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "toAwtKeyEvent", "Ljava/awt/event/KeyEvent;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientKeyEvent;", "connectionMillis", "", "target", "Ljava/awt/Component;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientKeyPressEvent;", "toAwtKeyEventId", "Lorg/jetbrains/projector/common/protocol/toServer/ClientKeyEvent$KeyEventType;", "toInt", "", "toJavaLocation", "Lorg/jetbrains/projector/common/protocol/toServer/ClientKeyEvent$KeyLocation;", "projector-server-core"})
public final class KeyKt {
    private static final Logger logger = LoggerKt.Logger((String)"KeyKt");
    private static final Map<KeyModifier, Integer> keyModifierMask = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)KeyModifier.ALT_KEY, (Object)512), TuplesKt.to((Object)KeyModifier.CTRL_KEY, (Object)128), TuplesKt.to((Object)KeyModifier.SHIFT_KEY, (Object)64), TuplesKt.to((Object)KeyModifier.META_KEY, (Object)256), TuplesKt.to((Object)KeyModifier.REPEAT, (Object)0)});

    @Nullable
    public static final KeyEvent toAwtKeyEvent(@NotNull ClientKeyPressEvent $this$toAwtKeyEvent, long connectionMillis, @NotNull Component target) {
        Character c;
        boolean isKeystroke;
        Intrinsics.checkNotNullParameter((Object)$this$toAwtKeyEvent, (String)"$this$toAwtKeyEvent");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean bl = isKeystroke = $this$toAwtKeyEvent.getModifiers().contains(KeyModifier.CTRL_KEY);
        if (bl) {
            Integer n = JsKeysMapKt.toJavaCodeOrNull($this$toAwtKeyEvent.getKey());
            c = n != null ? JsKeysMapKt.toJavaControlCharOrNull(n) : null;
        } else if (!bl) {
            c = JsKeysMapKt.toJavaCharOrNull($this$toAwtKeyEvent.getKey());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        if (c == null) {
            ClientKeyPressEvent clientKeyPressEvent = $this$toAwtKeyEvent;
            boolean bl2 = false;
            boolean bl3 = false;
            ClientKeyPressEvent $this$run = clientKeyPressEvent;
            boolean bl4 = false;
            Logger.DefaultImpls.error$default((Logger)logger, null, (Function0)((Function0)new Function0<String>($this$run){
                final /* synthetic */ ClientKeyPressEvent $this_run;

                @NotNull
                public final String invoke() {
                    return this.$this_run + ".toAwtKeyEvent(...): unknown key, skipping";
                }
                {
                    this.$this_run = clientKeyPressEvent;
                    super(0);
                }
            }), (int)1, null);
            return null;
        }
        char keyChar2 = c.charValue();
        return new KeyEvent(target, 400, (long)$this$toAwtKeyEvent.getTimeStamp() + connectionMillis, KeyKt.toInt($this$toAwtKeyEvent.getModifiers()), 0, keyChar2, 0);
    }

    @Nullable
    public static final KeyEvent toAwtKeyEvent(@NotNull ClientKeyEvent $this$toAwtKeyEvent, long connectionMillis, @NotNull Component target) {
        Character c;
        boolean isKeystroke;
        Intrinsics.checkNotNullParameter((Object)$this$toAwtKeyEvent, (String)"$this$toAwtKeyEvent");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int keyEventType = KeyKt.toAwtKeyEventId($this$toAwtKeyEvent.getKeyEventType());
        Integer n = JsKeysMapKt.toJavaCodeOrNull($this$toAwtKeyEvent.getCode());
        if (n == null) {
            ClientKeyEvent clientKeyEvent = $this$toAwtKeyEvent;
            boolean bl = false;
            boolean bl2 = false;
            ClientKeyEvent $this$run = clientKeyEvent;
            boolean bl3 = false;
            Logger.DefaultImpls.error$default((Logger)logger, null, (Function0)((Function0)new Function0<String>($this$run){
                final /* synthetic */ ClientKeyEvent $this_run;

                @NotNull
                public final String invoke() {
                    return this.$this_run + ".toAwtKeyEvent(...): unknown code, skipping";
                }
                {
                    this.$this_run = clientKeyEvent;
                    super(0);
                }
            }), (int)1, null);
            return null;
        }
        int code2 = n;
        boolean bl = isKeystroke = $this$toAwtKeyEvent.getModifiers().contains(KeyModifier.CTRL_KEY);
        if (bl) {
            c = JsKeysMapKt.toJavaControlCharOrNull(code2);
        } else if (!bl) {
            c = JsKeysMapKt.toJavaCharOrNull($this$toAwtKeyEvent.getKey());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        char key = c != null ? c.charValue() : (char)'\uffff';
        long l = (long)$this$toAwtKeyEvent.getTimeStamp() + connectionMillis;
        int n2 = KeyKt.toInt($this$toAwtKeyEvent.getModifiers());
        ClientKeyEvent.KeyLocation keyLocation = JsKeysMapKt.extractLocationOrNull($this$toAwtKeyEvent.getCode());
        if (keyLocation == null) {
            keyLocation = $this$toAwtKeyEvent.getLocation();
        }
        return new KeyEvent(target, keyEventType, l, n2, code2, key, KeyKt.toJavaLocation(keyLocation));
    }

    /*
     * WARNING - void declaration
     */
    private static final int toInt(Set<? extends KeyModifier> $this$toInt) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = $this$toInt;
        Map<KeyModifier, Integer> map = keyModifierMask;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            KeyModifier keyModifier = (KeyModifier)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = ((Number)MapsKt.getValue(map, (Object)p1)).intValue();
            collection.add(n);
        }
        $this$map$iv = (List)destination$iv$iv;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p2;
            int n = ((Number)element$iv).intValue();
            int p1 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p1 | p2;
        }
        return accumulator$iv;
    }

    private static final int toAwtKeyEventId(ClientKeyEvent.KeyEventType $this$toAwtKeyEventId) {
        int n;
        switch (KeyKt$WhenMappings.$EnumSwitchMapping$0[$this$toAwtKeyEventId.ordinal()]) {
            case 1: {
                n = 401;
                break;
            }
            case 2: {
                n = 402;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private static final int toJavaLocation(ClientKeyEvent.KeyLocation $this$toJavaLocation) {
        int n;
        switch (KeyKt$WhenMappings.$EnumSwitchMapping$1[$this$toJavaLocation.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }
}

