/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.ij.md;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/projector/server/core/ij/md/LocalImagesInliner;", "", "()V", "docBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "kotlin.jvm.PlatformType", "docFactory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "transformer", "Ljavax/xml/transform/Transformer;", "transformerFactory", "Ljavax/xml/transform/TransformerFactory;", "inlineImage", "", "localPath", "Ljava/nio/file/Path;", "extension", "inlineLocalImages", "html", "projector-server-core"})
public final class LocalImagesInliner {
    private static final DocumentBuilderFactory docFactory;
    private static final DocumentBuilder docBuilder;
    private static final TransformerFactory transformerFactory;
    private static final Transformer transformer;
    public static final LocalImagesInliner INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String inlineLocalImages(@NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        String string = html;
        Charset charset = Charsets.UTF_8;
        int n = 0;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        ByteArrayInputStream input = new ByteArrayInputStream(byArray);
        Document doc = docBuilder.parse(input);
        NodeList images = doc.getElementsByTagName("img");
        n = 0;
        NodeList nodeList = images;
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"images");
        int n2 = nodeList.getLength();
        while (n < n2) {
            void imageId;
            Node image;
            Node node = image = images.item((int)imageId);
            Intrinsics.checkNotNullExpressionValue((Object)node, (String)"image");
            if (node.getAttributes().getNamedItem("src") == null) {
            } else {
                Node srcAttribute;
                String src;
                String string2 = src = srcAttribute.getTextContent();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"src");
                if (StringsKt.startsWith$default((String)string2, (String)"file:", (boolean)false, (int)2, null)) {
                    Path path;
                    String extension = StringsKt.substringAfterLast((String)src, (char)'.', (String)"");
                    Path path2 = path = Path.of(new URI(src));
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                    String inlinedImage = this.inlineImage(path2, extension);
                    srcAttribute.setTextContent(inlinedImage);
                }
            }
            ++imageId;
        }
        DOMSource source = new DOMSource(doc);
        StringWriter stringWriter = new StringWriter(html.length());
        transformer.transform(source, new StreamResult(stringWriter));
        String string3 = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"stringWriter.toString()");
        return string3;
    }

    private final String inlineImage(Path localPath, String extension) {
        String string;
        try {
            String string2;
            byte[] bytes = Files.readAllBytes(localPath);
            String base64Content = Base64.getEncoder().encodeToString(bytes);
            String string3 = extension;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            string3 = string5;
            switch (string3.hashCode()) {
                case 114276: {
                    if (string3.equals("svg")) {
                        string2 = "data:image/svg+xml;base64," + base64Content;
                        break;
                    }
                }
                default: {
                    string2 = "data:image/" + extension + ";base64," + base64Content;
                }
            }
            string = string2;
        }
        catch (Throwable t) {
            string = "Can't inline image because of " + t;
        }
        return string;
    }

    private LocalImagesInliner() {
    }

    static {
        LocalImagesInliner localImagesInliner;
        INSTANCE = localImagesInliner = new LocalImagesInliner();
        docFactory = DocumentBuilderFactory.newInstance();
        docBuilder = docFactory.newDocumentBuilder();
        transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        boolean bl = false;
        boolean bl2 = false;
        Transformer $this$apply = transformer;
        boolean bl3 = false;
        $this$apply.setOutputProperty("indent", "no");
        $this$apply.setOutputProperty("method", "xml");
        $this$apply.setOutputProperty("omit-xml-declaration", "yes");
        LocalImagesInliner.transformer = transformer;
    }
}

