/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty0;
import kotlin.text.StringsKt;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PClipboard;
import org.jetbrains.projector.awt.PToolkit;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.font.PFontManager;
import org.jetbrains.projector.awt.image.PGraphicsDevice;
import org.jetbrains.projector.awt.image.PGraphicsEnvironment;
import org.jetbrains.projector.awt.image.PVolatileImage;
import org.jetbrains.projector.awt.peer.PComponentPeer;
import org.jetbrains.projector.awt.peer.PMouseInfoPeer;
import org.jetbrains.projector.common.misc.Do;
import org.jetbrains.projector.common.protocol.compress.MessageCompressor;
import org.jetbrains.projector.common.protocol.compress.MessageDecompressor;
import org.jetbrains.projector.common.protocol.data.CommonIntSize;
import org.jetbrains.projector.common.protocol.data.CommonRectangle;
import org.jetbrains.projector.common.protocol.data.CursorType;
import org.jetbrains.projector.common.protocol.data.FontDataHolder;
import org.jetbrains.projector.common.protocol.data.ImageData;
import org.jetbrains.projector.common.protocol.data.ImageId;
import org.jetbrains.projector.common.protocol.data.Point;
import org.jetbrains.projector.common.protocol.handshake.CompressionType;
import org.jetbrains.projector.common.protocol.handshake.ConstantKt;
import org.jetbrains.projector.common.protocol.handshake.ProtocolType;
import org.jetbrains.projector.common.protocol.handshake.ToClientHandshakeEvent;
import org.jetbrains.projector.common.protocol.handshake.ToClientHandshakeFailureEvent;
import org.jetbrains.projector.common.protocol.handshake.ToClientHandshakeSuccessEvent;
import org.jetbrains.projector.common.protocol.handshake.ToServerHandshakeEvent;
import org.jetbrains.projector.common.protocol.toClient.MainWindow;
import org.jetbrains.projector.common.protocol.toClient.ServerCaretInfoChangedEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerClipboardEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawCommandsEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerImageDataReplyEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerMarkdownEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPingReplyEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowColorsEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowSetChangedEvent;
import org.jetbrains.projector.common.protocol.toClient.ToClientMessageEncoder;
import org.jetbrains.projector.common.protocol.toClient.WindowData;
import org.jetbrains.projector.common.protocol.toClient.WindowType;
import org.jetbrains.projector.common.protocol.toServer.ClientClipboardEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientKeyEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientKeyPressEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientMouseEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientOpenLinkEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRequestImageDataEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRequestPingEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientResizeEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientSetKeymapEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWheelEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowCloseEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowMoveEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowResizeEvent;
import org.jetbrains.projector.common.protocol.toServer.MouseModifier;
import org.jetbrains.projector.common.protocol.toServer.ToServerMessageDecoder;
import org.jetbrains.projector.server.ClientSettings;
import org.jetbrains.projector.server.ConnectedClientSettings;
import org.jetbrains.projector.server.ProjectorServer;
import org.jetbrains.projector.server.ProjectorServer$Companion$WhenMappings;
import org.jetbrains.projector.server.ProjectorServer$WhenMappings;
import org.jetbrains.projector.server.ProjectorServer$wasStarted$2;
import org.jetbrains.projector.server.ReadyClientSettings;
import org.jetbrains.projector.server.SetUpClientData;
import org.jetbrains.projector.server.SetUpClientSettings;
import org.jetbrains.projector.server.core.ProjectorHttpWsServer;
import org.jetbrains.projector.server.core.convert.toAwt.KeyKt;
import org.jetbrains.projector.server.core.ij.md.IjInjectorAgentInitializer;
import org.jetbrains.projector.server.core.ij.md.PanelUpdater;
import org.jetbrains.projector.server.core.protocol.HandshakeTypesSelector;
import org.jetbrains.projector.server.core.protocol.KotlinxJsonToClientHandshakeEncoder;
import org.jetbrains.projector.server.core.protocol.KotlinxJsonToServerHandshakeDecoder;
import org.jetbrains.projector.server.idea.CaretInfoUpdater;
import org.jetbrains.projector.server.idea.IdeColors;
import org.jetbrains.projector.server.idea.KeymapSetter;
import org.jetbrains.projector.server.idea.SettingsInitializer;
import org.jetbrains.projector.server.service.ProjectorAwtInitializer;
import org.jetbrains.projector.server.service.ProjectorDrawEventQueue;
import org.jetbrains.projector.server.service.ProjectorImageCacher;
import org.jetbrains.projector.server.util.ClientEventExtensionsKt;
import org.jetbrains.projector.server.util.ConvertKt;
import org.jetbrains.projector.server.util.FontCacher;
import org.jetbrains.projector.server.util.LaterInvokator;
import org.jetbrains.projector.server.util.ReflectKt;
import org.jetbrains.projector.server.util.TransformKt;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;
import sun.awt.AWTAccessor;
import sun.font.FontManagerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008d\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0001\u000f\u0018\u0000 72\u00020\u0001:\u00017B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010!\u001a\u00020\u00072\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00170#H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0#H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010,\u001a\u00020'2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020%0#H\u0002J \u0010.\u001a\u00020'2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010*\u001a\u000203H\u0002J\u0006\u00104\u001a\u00020'J\u0012\u00105\u001a\u00020'2\b\b\u0002\u00106\u001a\u00020\u0003H\u0007R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/projector/server/ProjectorServer;", "", "port", "", "laterInvokator", "Lorg/jetbrains/projector/server/util/LaterInvokator;", "isAgent", "", "(ILorg/jetbrains/projector/server/util/LaterInvokator;Z)V", "caretInfoQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/projector/common/protocol/toClient/ServerCaretInfoChangedEvent$CaretInfoChange;", "caretInfoUpdater", "Lorg/jetbrains/projector/server/idea/CaretInfoUpdater;", "httpWsServer", "org/jetbrains/projector/server/ProjectorServer$httpWsServer$1", "Lorg/jetbrains/projector/server/ProjectorServer$httpWsServer$1;", "ideaColors", "Lorg/jetbrains/projector/server/idea/IdeColors;", "markdownQueue", "Lorg/jetbrains/projector/common/protocol/toClient/ServerMarkdownEvent;", "previousWindowEvents", "", "Lorg/jetbrains/projector/common/protocol/toClient/WindowData;", "updateThread", "Ljava/lang/Thread;", "wasStarted", "getWasStarted", "()Z", "wasStarted$delegate", "Lkotlin/reflect/KProperty0;", "windowColorsEvent", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowColorsEvent;", "areChangedWindows", "windowEvents", "", "createDataToSend", "Lorg/jetbrains/projector/common/protocol/toClient/ServerEvent;", "processMessage", "", "clientSettings", "Lorg/jetbrains/projector/server/ReadyClientSettings;", "message", "Lorg/jetbrains/projector/common/protocol/toServer/ClientEvent;", "sendPictures", "dataToSend", "setUpClient", "conn", "Lorg/java_websocket/WebSocket;", "connectedClientSettings", "Lorg/jetbrains/projector/server/ConnectedClientSettings;", "", "start", "stop", "timeout", "Companion", "projector-server"})
public final class ProjectorServer {
    private final httpWsServer.1 httpWsServer;
    @NotNull
    private final KProperty0 wasStarted$delegate;
    private Thread updateThread;
    private final ConcurrentLinkedQueue<ServerCaretInfoChangedEvent.CaretInfoChange> caretInfoQueue;
    private final CaretInfoUpdater caretInfoUpdater;
    private final ConcurrentLinkedQueue<ServerMarkdownEvent> markdownQueue;
    private ServerWindowColorsEvent windowColorsEvent;
    private final IdeColors ideaColors;
    private Set<WindowData> previousWindowEvents;
    private final LaterInvokator laterInvokator;
    private final boolean isAgent;
    private static final Logger logger;
    private static final int DEFAULT_SCROLL_AMOUNT = 1;
    private static final int PIXEL_PER_UNIT = 100;
    private static final int TOUCH_PIXEL_PER_UNIT = 300;
    private static final int PIXEL_DELTA_ENOUGH_FOR_SCROLLING = 10;
    private static final Map<MouseModifier, Integer> mouseModifierMask;
    @NotNull
    public static final String ENABLE_PROPERTY_NAME = "org.jetbrains.projector.server.enable";
    @NotNull
    public static final String PORT_PROPERTY_NAME = "org.jetbrains.projector.server.port";
    public static final int DEFAULT_PORT = 8887;
    @NotNull
    public static final String TOKEN_ENV_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_HANDSHAKE_TOKEN";
    @NotNull
    public static final String RO_TOKEN_ENV_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_RO_HANDSHAKE_TOKEN";
    @NotNull
    public static final String SSL_ENV_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_SSL_PROPERTIES_PATH";
    @NotNull
    public static final String SSL_STORE_TYPE = "STORE_TYPE";
    @NotNull
    public static final String SSL_FILE_PATH = "FILE_PATH";
    @NotNull
    public static final String SSL_STORE_PASSWORD = "STORE_PASSWORD";
    @NotNull
    public static final String SSL_KEY_PASSWORD = "KEY_PASSWORD";
    private static boolean ENABLE_BIG_COLLECTIONS_CHECKS;
    private static final int DEFAULT_BIG_COLLECTIONS_CHECKS_SIZE = 10000;
    private static int BIG_COLLECTIONS_CHECKS_START_SIZE;
    @NotNull
    public static final String ENABLE_AUTO_KEYMAP_SETTING = "ORG_JETBRAINS_PROJECTOR_SERVER_AUTO_KEYMAP";
    @NotNull
    public static final String ENABLE_CONNECTION_CONFIRMATION = "ORG_JETBRAINS_PROJECTOR_SERVER_CONNECTION_CONFIRMATION";
    public static final Companion Companion;

    public final boolean getWasStarted() {
        KProperty0 kProperty0 = this.wasStarted$delegate;
        ProjectorServer projectorServer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)kProperty0.get();
    }

    /*
     * WARNING - void declaration
     */
    private final List<ServerEvent> createDataToSend() {
        void $this$mapTo$iv$iv;
        int n;
        Iterable iterable;
        ServerCaretInfoChangedEvent.CaretInfoChange window;
        void $this$mapIndexedTo$iv$iv;
        ServerDrawCommandsEvent serverDrawCommandsEvent;
        Collection collection;
        void $this$mapTo$iv$iv2;
        boolean bl;
        ProjectorDrawEventQueue it;
        Iterable $this$filterTo$iv$iv;
        List list;
        Transferable clipboardContents = PClipboard.INSTANCE.extractLastContents();
        if (clipboardContents == null) {
            list = CollectionsKt.emptyList();
        } else {
            boolean bl2 = clipboardContents.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (!bl2) {
                list = CollectionsKt.emptyList();
            } else if (bl2) {
                Object object = clipboardContents.getTransferData(DataFlavor.stringFlavor);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                list = CollectionsKt.listOf((Object)new ServerClipboardEvent((String)object));
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        List clipboardEvent = list;
        ProjectorServer.Companion.calculateMainWindowShift();
        Iterable $this$filter$iv = ProjectorDrawEventQueue.Companion.getQueues();
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProjectorDrawEventQueue)element$iv$iv;
            boolean bl3 = false;
            Collection collection2 = it.getCommands();
            bl = false;
            if (!(!collection2.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator queue;
            it = (ProjectorDrawEventQueue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            List drawEvents = TransformKt.extractData((Iterable)((ProjectorDrawEventQueue)((Object)queue)).getCommands());
            serverDrawCommandsEvent = new ServerDrawCommandsEvent(((ProjectorDrawEventQueue)((Object)queue)).getTarget(), TransformKt.convertToSimpleList(drawEvents));
            collection.add(serverDrawCommandsEvent);
        }
        List drawCommands = (List)destination$iv$iv;
        Iterable $this$mapIndexed$iv = PWindow.Companion.getWindows();
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv22 = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            List list2;
            Object object;
            int n2 = index$iv$iv22++;
            bl = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PWindow pWindow = (PWindow)item$iv$iv;
            int n3 = n2;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            int n4 = window.getId();
            String string = window.getTitle();
            List list3 = window.getIcons();
            if (list3 != null) {
                Collection<ImageId> collection3;
                void $this$mapTo$iv$iv3;
                void $this$map$iv2;
                iterable = list3;
                String string2 = string;
                n = n4;
                boolean $i$f$map2 = false;
                void var23_42 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                object = $this$mapTo$iv$iv3.iterator();
                while (object.hasNext()) {
                    void it2;
                    Object item$iv$iv2;
                    Object t = item$iv$iv2 = object.next();
                    collection3 = destination$iv$iv3;
                    boolean bl6 = false;
                    void v5 = it2;
                    if (v5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.projector.common.protocol.data.ImageId");
                    }
                    ImageId imageId = (ImageId)v5;
                    collection3.add(imageId);
                }
                collection3 = (List)destination$iv$iv3;
                n4 = n;
                string = string2;
                list2 = collection3;
            } else {
                list2 = null;
            }
            Cursor cursor = window.getCursor();
            iterable = ConvertKt.getWindowType((PWindow)window);
            boolean bl7 = window.getUndecorated();
            boolean bl8 = window.getModal();
            boolean bl9 = window.getResizable();
            CursorType cursorType = cursor != null ? ConvertKt.toCursorType(cursor.getType()) : null;
            Object object2 = object = window.getHeaderHeight();
            Iterable iterable3 = iterable;
            boolean bl10 = bl7;
            boolean bl11 = bl8;
            boolean bl12 = bl9;
            CursorType cursorType2 = cursorType;
            CommonRectangle commonRectangle = ProjectorServer.Companion.shiftBounds(window.getTarget(), PGraphicsDevice.INSTANCE.getClientShift());
            void var41_60 = i;
            boolean bl13 = window.getTarget().isShowing();
            List list4 = list2;
            String string3 = string;
            int n5 = n4;
            serverDrawCommandsEvent = new WindowData(n5, string3, list4, bl13, (int)var41_60, commonRectangle, cursorType2, bl12, bl11, bl10, (WindowType)iterable3, (Integer)object2);
            collection.add(serverDrawCommandsEvent);
        }
        List windows = (List)destination$iv$iv2;
        List windowSetChangedEvent = this.areChangedWindows(windows) ? CollectionsKt.listOf((Object)new ServerWindowSetChangedEvent(windows)) : CollectionsKt.emptyList();
        List newImagesCopy = TransformKt.extractData((Iterable)ProjectorImageCacher.INSTANCE.getNewImages());
        Iterable $this$map$iv3 = TransformKt.extractData((Iterable)this.caretInfoQueue);
        boolean $i$f$map3 = false;
        Iterable index$iv$iv22 = $this$map$iv3;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            window = (ServerCaretInfoChangedEvent.CaretInfoChange)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl14 = false;
            serverDrawCommandsEvent = new ServerCaretInfoChangedEvent((ServerCaretInfoChangedEvent.CaretInfoChange)p1);
            collection.add(serverDrawCommandsEvent);
        }
        List caretInfoEvents = (List)destination$iv$iv4;
        List markdownEvents = TransformKt.extractData((Iterable)this.markdownQueue);
        int commandsCount = caretInfoEvents.size() + newImagesCopy.size() + clipboardEvent.size() + drawCommands.size() + windowSetChangedEvent.size() + markdownEvents.size() + 1;
        boolean bl15 = false;
        boolean bl16 = false;
        bl16 = false;
        List list5 = CollectionsKt.createListBuilder((int)commandsCount);
        boolean bl17 = false;
        boolean bl18 = false;
        List $this$buildList = list5;
        boolean bl19 = false;
        $this$buildList.addAll(caretInfoEvents);
        $this$buildList.addAll(newImagesCopy);
        $this$buildList.addAll(clipboardEvent);
        $this$buildList.addAll(drawCommands);
        $this$buildList.addAll(windowSetChangedEvent);
        $this$buildList.addAll(markdownEvents);
        ServerWindowColorsEvent serverWindowColorsEvent = this.windowColorsEvent;
        if (serverWindowColorsEvent != null) {
            iterable = serverWindowColorsEvent;
            boolean bl20 = false;
            n = 0;
            Iterable it3 = iterable;
            boolean bl21 = false;
            $this$buildList.add(it3);
            this.windowColorsEvent = null;
        }
        List allEvents = CollectionsKt.build((List)list5);
        ProjectorImageCacher.INSTANCE.collectGarbage();
        return allEvents;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void processMessage(ReadyClientSettings clientSettings, ClientEvent message) {
        block15: {
            block24: {
                block25: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                block16: {
                                                    block14: {
                                                        if (!(clientSettings.getSetUpClientData().getHasWriteAccess() || message instanceof ClientRequestImageDataEvent || message instanceof ClientRequestPingEvent)) {
                                                            return;
                                                        }
                                                        var3_3 = Do.INSTANCE;
                                                        var4_4 = message;
                                                        if (!(var4_4 instanceof ClientResizeEvent)) break block14;
                                                        SwingUtilities.invokeLater(new Runnable(message){
                                                            final /* synthetic */ ClientEvent $message;

                                                            public final void run() {
                                                                org.jetbrains.projector.server.ProjectorServer$Companion.access$resize(ProjectorServer.Companion, ((ClientResizeEvent)this.$message).getSize().getWidth(), ((ClientResizeEvent)this.$message).getSize().getHeight());
                                                            }
                                                            {
                                                                this.$message = clientEvent;
                                                            }
                                                        });
                                                        v0 /* !! */  = Unit.INSTANCE;
                                                        break block15;
                                                    }
                                                    if (!(var4_4 instanceof ClientMouseEvent)) break block16;
                                                    SwingUtilities.invokeLater(new Runnable(this, message, clientSettings){
                                                        final /* synthetic */ ProjectorServer this$0;
                                                        final /* synthetic */ ClientEvent $message;
                                                        final /* synthetic */ ReadyClientSettings $clientSettings;

                                                        public final void run() {
                                                            ReadyClientSettings.TouchState touchState;
                                                            ClientMouseEvent shiftedMessage = ClientEventExtensionsKt.shift((ClientMouseEvent)this.$message, PGraphicsDevice.INSTANCE.getClientShift());
                                                            PMouseInfoPeer.INSTANCE.getLastMouseCoords().setLocation(shiftedMessage.getX(), shiftedMessage.getY());
                                                            PWindow pWindow = PWindow.Companion.getWindow(((ClientMouseEvent)this.$message).getWindowId());
                                                            Component window = pWindow != null ? pWindow.getTarget() : null;
                                                            PMouseInfoPeer.INSTANCE.setLastWindowUnderMouse(window);
                                                            if (window == null) {
                                                                return;
                                                            }
                                                            processMessage.1 $fun$isEnoughDeltaForScrolling$1 = processMessage.1.INSTANCE;
                                                            switch (ProjectorServer$WhenMappings.$EnumSwitchMapping$0[shiftedMessage.getMouseEventType().ordinal()]) {
                                                                case 1: {
                                                                    touchState = ReadyClientSettings.TouchState.Released.INSTANCE;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    touchState = new ReadyClientSettings.TouchState.OnlyPressed(((ClientMouseEvent)this.$message).getTimeStamp(), shiftedMessage.getX(), shiftedMessage.getY());
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    boolean bl;
                                                                    ReadyClientSettings.TouchState touchState2 = this.$clientSettings.getTouchState();
                                                                    if (touchState2 instanceof ReadyClientSettings.TouchState.Scrolling) {
                                                                        bl = $fun$isEnoughDeltaForScrolling$1.invoke((ReadyClientSettings.TouchState.Scrolling)touchState2, shiftedMessage.getX(), shiftedMessage.getY());
                                                                        if (!bl) {
                                                                            if (!bl) {
                                                                                return;
                                                                            }
                                                                            throw new NoWhenBranchMatchedException();
                                                                        }
                                                                        touchState = new ReadyClientSettings.TouchState.Scrolling(((ReadyClientSettings.TouchState.Scrolling)touchState2).getInitialX(), ((ReadyClientSettings.TouchState.Scrolling)touchState2).getInitialY(), shiftedMessage.getX(), shiftedMessage.getY());
                                                                        break;
                                                                    }
                                                                    if (touchState2 instanceof ReadyClientSettings.TouchState.Dragging) {
                                                                        touchState = ReadyClientSettings.TouchState.Dragging.INSTANCE;
                                                                        break;
                                                                    }
                                                                    if (touchState2 instanceof ReadyClientSettings.TouchState.OnlyPressed) {
                                                                        boolean bl2 = bl = ((ReadyClientSettings.TouchState.OnlyPressed)touchState2).getConnectionMillis() + 500 < shiftedMessage.getTimeStamp();
                                                                        if (bl) {
                                                                            touchState = ReadyClientSettings.TouchState.Dragging.INSTANCE;
                                                                            break;
                                                                        }
                                                                        if (!bl) {
                                                                            touchState = new ReadyClientSettings.TouchState.Scrolling(((ReadyClientSettings.TouchState.OnlyPressed)touchState2).getLastX(), ((ReadyClientSettings.TouchState.OnlyPressed)touchState2).getLastY(), shiftedMessage.getX(), shiftedMessage.getY());
                                                                            break;
                                                                        }
                                                                        throw new NoWhenBranchMatchedException();
                                                                    }
                                                                    if (touchState2 instanceof ReadyClientSettings.TouchState.Released) {
                                                                        touchState = ReadyClientSettings.TouchState.Released.INSTANCE;
                                                                        break;
                                                                    }
                                                                    throw new NoWhenBranchMatchedException();
                                                                }
                                                                default: {
                                                                    touchState = this.$clientSettings.getTouchState();
                                                                }
                                                            }
                                                            ReadyClientSettings.TouchState newTouchState = touchState;
                                                            MouseEvent mouseEvent = org.jetbrains.projector.server.ProjectorServer$Companion.access$createMouseEvent(ProjectorServer.Companion, window, shiftedMessage, this.$clientSettings.getTouchState(), newTouchState, this.$clientSettings.getConnectionMillis());
                                                            this.$clientSettings.setTouchState(newTouchState);
                                                            ProjectorServer.access$getLaterInvokator$p(this.this$0).invoke(mouseEvent);
                                                        }
                                                        {
                                                            this.this$0 = projectorServer;
                                                            this.$message = clientEvent;
                                                            this.$clientSettings = readyClientSettings;
                                                        }
                                                    });
                                                    v0 /* !! */  = Unit.INSTANCE;
                                                    break block15;
                                                }
                                                if (!(var4_4 instanceof ClientWheelEvent)) break block17;
                                                SwingUtilities.invokeLater(new Runnable(this, message, clientSettings){
                                                    final /* synthetic */ ProjectorServer this$0;
                                                    final /* synthetic */ ClientEvent $message;
                                                    final /* synthetic */ ReadyClientSettings $clientSettings;

                                                    public final void run() {
                                                        ClientWheelEvent shiftedMessage = ClientEventExtensionsKt.shift((ClientWheelEvent)this.$message, PGraphicsDevice.INSTANCE.getClientShift());
                                                        PMouseInfoPeer.INSTANCE.getLastMouseCoords().setLocation(shiftedMessage.getX(), shiftedMessage.getY());
                                                        PWindow pWindow = PWindow.Companion.getWindow(((ClientWheelEvent)this.$message).getWindowId());
                                                        Component window = pWindow != null ? pWindow.getTarget() : null;
                                                        PMouseInfoPeer.INSTANCE.setLastWindowUnderMouse(window);
                                                        if (window == null) {
                                                            return;
                                                        }
                                                        MouseWheelEvent mouseWheelEvent = org.jetbrains.projector.server.ProjectorServer$Companion.access$createMouseWheelEvent(ProjectorServer.Companion, window, shiftedMessage, this.$clientSettings.getConnectionMillis());
                                                        ProjectorServer.access$getLaterInvokator$p(this.this$0).invoke(mouseWheelEvent);
                                                    }
                                                    {
                                                        this.this$0 = projectorServer;
                                                        this.$message = clientEvent;
                                                        this.$clientSettings = readyClientSettings;
                                                    }
                                                });
                                                v0 /* !! */  = Unit.INSTANCE;
                                                break block15;
                                            }
                                            if (!(var4_4 instanceof ClientKeyEvent)) break block18;
                                            v1 = KeyKt.toAwtKeyEvent((ClientKeyEvent)((ClientKeyEvent)message), (long)clientSettings.getConnectionMillis(), (Component)org.jetbrains.projector.server.ProjectorServer$Companion.access$focusOwnerOrTarget(ProjectorServer.Companion, ((PWindow)CollectionsKt.last((List)PWindow.Companion.getWindows())).getTarget()));
                                            if (v1 != null) {
                                                var5_5 = v1;
                                                var6_7 = false;
                                                var7_11 = false;
                                                it = var5_5;
                                                $i$a$-let-ProjectorServer$processMessage$4 = false;
                                                SwingUtilities.invokeLater(new Runnable(it, this){
                                                    final /* synthetic */ KeyEvent $it;
                                                    final /* synthetic */ ProjectorServer this$0;
                                                    {
                                                        this.$it = keyEvent;
                                                        this.this$0 = projectorServer;
                                                    }

                                                    public final void run() {
                                                        ProjectorServer.access$getLaterInvokator$p(this.this$0).invoke(this.$it);
                                                    }
                                                });
                                                v0 /* !! */  = Unit.INSTANCE;
                                            } else {
                                                v0 /* !! */  = null;
                                            }
                                            break block15;
                                        }
                                        if (!(var4_4 instanceof ClientKeyPressEvent)) break block19;
                                        v2 = KeyKt.toAwtKeyEvent((ClientKeyPressEvent)((ClientKeyPressEvent)message), (long)clientSettings.getConnectionMillis(), (Component)org.jetbrains.projector.server.ProjectorServer$Companion.access$focusOwnerOrTarget(ProjectorServer.Companion, ((PWindow)CollectionsKt.last((List)PWindow.Companion.getWindows())).getTarget()));
                                        if (v2 != null) {
                                            var5_5 = v2;
                                            var6_8 = false;
                                            var7_11 = false;
                                            it = var5_5;
                                            $i$a$-let-ProjectorServer$processMessage$5 = false;
                                            SwingUtilities.invokeLater(new Runnable(it, this){
                                                final /* synthetic */ KeyEvent $it;
                                                final /* synthetic */ ProjectorServer this$0;
                                                {
                                                    this.$it = keyEvent;
                                                    this.this$0 = projectorServer;
                                                }

                                                public final void run() {
                                                    ProjectorServer.access$getLaterInvokator$p(this.this$0).invoke(this.$it);
                                                }
                                            });
                                            v0 /* !! */  = Unit.INSTANCE;
                                        } else {
                                            v0 /* !! */  = null;
                                        }
                                        break block15;
                                    }
                                    if (!(var4_4 instanceof ClientRequestImageDataEvent)) break block20;
                                    v3 = ProjectorImageCacher.INSTANCE.getImage(((ClientRequestImageDataEvent)message).getImageId());
                                    if (v3 == null) {
                                        v3 = (ImageData)ImageData.Empty.INSTANCE;
                                    }
                                    imageData = v3;
                                    resource = new ServerImageDataReplyEvent(((ClientRequestImageDataEvent)message).getImageId(), imageData);
                                    clientSettings.getRequestedData().add((ServerEvent)resource);
                                    v0 /* !! */  = Unit.INSTANCE;
                                    break block15;
                                }
                                if (!(var4_4 instanceof ClientClipboardEvent)) break block21;
                                transferable = new Transferable(message){
                                    final /* synthetic */ ClientEvent $message;

                                    @Nullable
                                    public Object getTransferData(@Nullable DataFlavor flavor) {
                                        if (!this.isDataFlavorSupported(flavor)) {
                                            throw (Throwable)new UnsupportedFlavorException(flavor);
                                        }
                                        return ((ClientClipboardEvent)this.$message).getStringContent();
                                    }

                                    public boolean isDataFlavorSupported(@Nullable DataFlavor flavor) {
                                        return ArraysKt.contains((Object[])this.getTransferDataFlavors(), (Object)flavor);
                                    }

                                    @NotNull
                                    public DataFlavor[] getTransferDataFlavors() {
                                        DataFlavor[] dataFlavorArray = new DataFlavor[1];
                                        DataFlavor dataFlavor = DataFlavor.stringFlavor;
                                        Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"DataFlavor.stringFlavor");
                                        dataFlavorArray[0] = dataFlavor;
                                        return dataFlavorArray;
                                    }
                                    {
                                        this.$message = $captured_local_variable$0;
                                    }
                                };
                                SwingUtilities.invokeLater(new Runnable(transferable){
                                    final /* synthetic */ processMessage.transferable.1 $transferable;

                                    public final void run() {
                                        PClipboard.INSTANCE.putContents((Transferable)this.$transferable);
                                    }
                                    {
                                        this.$transferable = var1_1;
                                    }
                                });
                                v0 /* !! */  = Unit.INSTANCE;
                                break block15;
                            }
                            if (!(var4_4 instanceof ClientRequestPingEvent)) break block22;
                            pingReply /* !! */  = new ServerPingReplyEvent(((ClientRequestPingEvent)message).getClientTimeStamp(), (int)(System.currentTimeMillis() - clientSettings.getConnectionMillis()));
                            v0 /* !! */  = Boolean.valueOf(clientSettings.getRequestedData().add((ServerEvent)pingReply /* !! */ ));
                            break block15;
                        }
                        if (!(var4_4 instanceof ClientOpenLinkEvent)) break block23;
                        PanelUpdater.INSTANCE.openInExternalBrowser(((ClientOpenLinkEvent)message).getLink());
                        v0 /* !! */  = Unit.INSTANCE;
                        break block15;
                    }
                    if (!(var4_4 instanceof ClientSetKeymapEvent)) break block24;
                    if (!this.isAgent) break block25;
                    Logger.DefaultImpls.info$default((Logger)ProjectorServer.logger, null, (Function0)processMessage.7.INSTANCE, (int)1, null);
                    v0 /* !! */  = Unit.INSTANCE;
                    break block15;
                }
                v4 = org.jetbrains.projector.server.ProjectorServer$Companion.access$getProperty(ProjectorServer.Companion, "ORG_JETBRAINS_PROJECTOR_SERVER_AUTO_KEYMAP");
                if (v4 == null) ** GOTO lbl-1000
                pingReply /* !! */  = v4;
                var6_10 = false;
                if (!Boolean.parseBoolean((String)pingReply /* !! */ )) {
                    Logger.DefaultImpls.info$default((Logger)ProjectorServer.logger, null, (Function0)processMessage.8.INSTANCE, (int)1, null);
                    v0 /* !! */  = Unit.INSTANCE;
                } else lbl-1000:
                // 2 sources

                {
                    KeymapSetter.INSTANCE.setKeymap(((ClientSetKeymapEvent)message).getKeymap());
                    v0 /* !! */  = Unit.INSTANCE;
                }
                break block15;
            }
            if (var4_4 instanceof ClientWindowMoveEvent) {
                SwingUtilities.invokeLater(new Runnable(message){
                    final /* synthetic */ ClientEvent $message;

                    public final void run() {
                        block0: {
                            PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowMoveEvent)this.$message).getWindowId());
                            if (pWindow == null) break block0;
                            PWindow pWindow2 = pWindow;
                            boolean bl = false;
                            boolean bl2 = false;
                            PWindow $this$apply = pWindow2;
                            boolean bl3 = false;
                            $this$apply.move(((ClientWindowMoveEvent)this.$message).getDeltaX(), ((ClientWindowMoveEvent)this.$message).getDeltaY());
                        }
                    }
                    {
                        this.$message = clientEvent;
                    }
                });
                v0 /* !! */  = Unit.INSTANCE;
            } else if (var4_4 instanceof ClientWindowResizeEvent) {
                SwingUtilities.invokeLater(new Runnable(message){
                    final /* synthetic */ ClientEvent $message;

                    public final void run() {
                        block0: {
                            PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowResizeEvent)this.$message).getWindowId());
                            if (pWindow == null) break block0;
                            PWindow pWindow2 = pWindow;
                            boolean bl = false;
                            boolean bl2 = false;
                            PWindow $this$apply = pWindow2;
                            boolean bl3 = false;
                            $this$apply.resize(((ClientWindowResizeEvent)this.$message).getDeltaX(), ((ClientWindowResizeEvent)this.$message).getDeltaY(), ConvertKt.toDirection(((ClientWindowResizeEvent)this.$message).getDirection()));
                        }
                    }
                    {
                        this.$message = clientEvent;
                    }
                });
                v0 /* !! */  = Unit.INSTANCE;
            } else if (var4_4 instanceof ClientWindowCloseEvent) {
                SwingUtilities.invokeLater(new Runnable(message){
                    final /* synthetic */ ClientEvent $message;

                    public final void run() {
                        block0: {
                            PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowCloseEvent)this.$message).getWindowId());
                            if (pWindow == null) break block0;
                            pWindow.close();
                        }
                    }
                    {
                        this.$message = clientEvent;
                    }
                });
                v0 /* !! */  = Unit.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        any$iv = v0 /* !! */ ;
        $i$f$exhaustive = false;
    }

    /*
     * WARNING - void declaration
     */
    private final void setUpClient(WebSocket conn, ConnectedClientSettings connectedClientSettings, String message) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        ToServerMessageDecoder toServerDecoder;
        MessageDecompressor toServerDecompressor;
        ToClientMessageEncoder toClientEncoder;
        MessageCompressor toClientCompressor;
        boolean hasWriteAccess;
        ToServerHandshakeEvent toServerHandshakeEvent;
        block17: {
            String string;
            String ipString;
            Function1<String, Unit> $fun$sendHandshakeFailureEvent$1;
            block18: {
                boolean bl;
                $fun$sendHandshakeFailureEvent$1 = new Function1<String, Unit>(conn){
                    final /* synthetic */ WebSocket $conn;

                    public final void invoke(@NotNull String reason) {
                        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                        ToClientHandshakeFailureEvent failureEvent = new ToClientHandshakeFailureEvent(reason);
                        this.$conn.send(KotlinxJsonToClientHandshakeEncoder.INSTANCE.encode((ToClientHandshakeEvent)failureEvent));
                    }
                    {
                        this.$conn = webSocket;
                        super(1);
                    }
                };
                toServerHandshakeEvent = KotlinxJsonToServerHandshakeDecoder.INSTANCE.decode(message);
                String string2 = toServerHandshakeEvent.getToken();
                if (Intrinsics.areEqual((Object)string2, (Object)ProjectorServer.Companion.getProperty(TOKEN_ENV_NAME))) {
                    bl = true;
                } else if (Intrinsics.areEqual((Object)string2, (Object)ProjectorServer.Companion.getProperty(RO_TOKEN_ENV_NAME))) {
                    bl = false;
                } else {
                    $fun$sendHandshakeFailureEvent$1.invoke("Bad handshake token");
                    return;
                }
                hasWriteAccess = bl;
                if (toServerHandshakeEvent.getCommonVersion() != ConstantKt.getCOMMON_VERSION()) {
                    String reason = "Incompatible common protocol versions: server - " + ConstantKt.getCOMMON_VERSION() + " (#" + ConstantKt.getCommonVersionList().indexOf(ConstantKt.getCOMMON_VERSION()) + "), " + "client - " + toServerHandshakeEvent.getCommonVersion() + " (#" + toServerHandshakeEvent.getCommonVersionId() + ')';
                    $fun$sendHandshakeFailureEvent$1.invoke(reason);
                    return;
                }
                toClientCompressor = HandshakeTypesSelector.INSTANCE.selectToClientCompressor(toServerHandshakeEvent.getSupportedToClientCompressions());
                if (toClientCompressor == null) {
                    $fun$sendHandshakeFailureEvent$1.invoke("Server doesn't support any of the following to-client compressions: " + toServerHandshakeEvent.getSupportedToClientCompressions());
                    return;
                }
                toClientEncoder = HandshakeTypesSelector.INSTANCE.selectToClientEncoder(toServerHandshakeEvent.getSupportedToClientProtocols());
                if (toClientEncoder == null) {
                    $fun$sendHandshakeFailureEvent$1.invoke("Server doesn't support any of the following to-client protocols: " + toServerHandshakeEvent.getSupportedToClientProtocols());
                    return;
                }
                toServerDecompressor = HandshakeTypesSelector.INSTANCE.selectToServerDecompressor(toServerHandshakeEvent.getSupportedToServerCompressions());
                if (toServerDecompressor == null) {
                    $fun$sendHandshakeFailureEvent$1.invoke("Server doesn't support any of the following to-server compressions: " + toServerHandshakeEvent.getSupportedToServerCompressions());
                    return;
                }
                toServerDecoder = HandshakeTypesSelector.INSTANCE.selectToServerDecoder(toServerHandshakeEvent.getSupportedToServerProtocols());
                if (toServerDecoder == null) {
                    $fun$sendHandshakeFailureEvent$1.invoke("Server doesn't support any of the following to-server protocols: " + toServerHandshakeEvent.getSupportedToServerProtocols());
                    return;
                }
                Serializable serializable = conn.getRemoteSocketAddress();
                String string3 = serializable != null && (serializable = ((InetSocketAddress)serializable).getAddress()) != null ? ((InetAddress)serializable).getHostAddress() : (ipString = null);
                if (!this.isAgent) break block17;
                String string4 = ProjectorServer.Companion.getProperty(ENABLE_CONNECTION_CONFIRMATION);
                if (string4 == null) break block18;
                string = string4;
                boolean bl2 = false;
                if (!Boolean.parseBoolean(string)) break block17;
            }
            if (!CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])new String[]{"127.0.0.1", "0:0:0:0:0:0:0:1"}), (Object)ipString)) {
                void selectedOption;
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)setUpClient.2.INSTANCE, (int)1, null);
                string = new Ref.IntRef();
                ((Ref.IntRef)string).element = -1;
                SwingUtilities.invokeAndWait(new Runnable(hasWriteAccess, (Ref.IntRef)selectedOption, ipString){
                    final /* synthetic */ boolean $hasWriteAccess;
                    final /* synthetic */ Ref.IntRef $selectedOption;
                    final /* synthetic */ String $ipString;

                    public final void run() {
                        String string;
                        boolean bl = this.$hasWriteAccess;
                        if (bl) {
                            string = "read-write";
                        } else if (!bl) {
                            string = "read-only";
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        String accessType = string;
                        this.$selectedOption.element = JOptionPane.showOptionDialog(null, "Somebody (" + this.$ipString + ") wants to connect with " + accessType + " access. Allow the connection?", "New connection", 0, 3, null, null, null);
                    }
                    {
                        this.$hasWriteAccess = bl;
                        this.$selectedOption = intRef;
                        this.$ipString = string;
                    }
                });
                if (selectedOption.element != 0) {
                    Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)setUpClient.4.INSTANCE, (int)1, null);
                    $fun$sendHandshakeFailureEvent$1.invoke("Other user has disallowed this connection.");
                    return;
                }
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)setUpClient.5.INSTANCE, (int)1, null);
            }
        }
        CommonIntSize commonIntSize = PFontManager.INSTANCE.getAllInstalledFonts();
        ProtocolType protocolType = toServerDecoder.getProtocolType();
        CompressionType compressionType = toServerDecompressor.getCompressionType();
        ProtocolType protocolType2 = toClientEncoder.getProtocolType();
        CompressionType compressionType2 = toClientCompressor.getCompressionType();
        boolean $i$f$mapNotNull = false;
        void var15_20 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var20_27 = $this$forEach$iv$iv$iv;
        int n = ((void)var20_27).length;
        for (int i = 0; i < n; ++i) {
            Short s;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var20_27[i];
            boolean bl = false;
            void font = element$iv$iv;
            boolean bl3 = false;
            if (FontCacher.INSTANCE.getId((Font)font) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            Short it$iv$iv = s;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection<FontDataHolder> collection = (List)destination$iv$iv;
        $this$mapNotNull$iv = collection;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void fontId;
            short s = ((Number)item$iv$iv).shortValue();
            collection = destination$iv$iv;
            boolean bl = false;
            FontDataHolder fontDataHolder = FontCacher.INSTANCE.getFontData((short)fontId);
            collection.add(fontDataHolder);
        }
        collection = (List)destination$iv$iv;
        ServerWindowColorsEvent.ColorsStorage colorsStorage = this.ideaColors.getColors();
        List list = collection;
        ProtocolType protocolType3 = protocolType;
        CompressionType compressionType3 = compressionType;
        ProtocolType protocolType4 = protocolType2;
        CompressionType compressionType4 = compressionType2;
        ToClientHandshakeSuccessEvent successEvent = new ToClientHandshakeSuccessEvent(compressionType4, protocolType4, compressionType3, protocolType3, list, colorsStorage);
        conn.send(KotlinxJsonToClientHandshakeEncoder.INSTANCE.encode((ToClientHandshakeEvent)successEvent));
        conn.setAttachment((Object)new SetUpClientSettings(connectedClientSettings.getConnectionMillis(), new SetUpClientData(hasWriteAccess, toClientEncoder, (MessageCompressor<byte[]>)toClientCompressor, toServerDecoder, (MessageDecompressor<String>)toServerDecompressor)));
        if (hasWriteAccess) {
            commonIntSize = toServerHandshakeEvent.getInitialSize();
            boolean bl = false;
            boolean bl7 = false;
            CommonIntSize $this$with = commonIntSize;
            boolean bl8 = false;
            ProjectorServer.Companion.resize($this$with.getWidth(), $this$with.getHeight());
        }
    }

    private final void sendPictures(List<? extends ServerEvent> dataToSend) {
        this.httpWsServer.forEachOpenedConnection((Function1)new Function1<WebSocket, Unit>(dataToSend){
            final /* synthetic */ List $dataToSend;

            public final void invoke(@NotNull WebSocket client) {
                Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                Object object = client.getAttachment();
                if (!(object instanceof ReadyClientSettings)) {
                    object = null;
                }
                ReadyClientSettings readyClientSettings = (ReadyClientSettings)object;
                if (readyClientSettings == null) {
                    return;
                }
                ReadyClientSettings readyClientSettings2 = readyClientSettings;
                SetUpClientData setUpClientData = readyClientSettings2.getSetUpClientData();
                boolean bl = false;
                boolean bl2 = false;
                SetUpClientData $this$with = setUpClientData;
                boolean bl3 = false;
                List<E> requestedData = TransformKt.extractData((Iterable)readyClientSettings2.getRequestedData());
                List message = CollectionsKt.plus((Collection)requestedData, (Iterable)this.$dataToSend);
                if (message.isEmpty()) {
                    return;
                }
                byte[] encoded = (byte[])$this$with.getToClientMessageEncoder().encode((Object)message);
                byte[] compressed = (byte[])$this$with.getToClientMessageCompressor().compress((Object)encoded);
                try {
                    client.send(compressed);
                }
                catch (WebsocketNotConnectedException e) {
                    ProjectorServer.access$getLogger$cp().debug((Throwable)e, (Function0)sendPictures.1.INSTANCE);
                }
            }
            {
                this.$dataToSend = list;
                super(1);
            }
        });
    }

    private final boolean areChangedWindows(List<WindowData> windowEvents) {
        Set set = CollectionsKt.toSet((Iterable)windowEvents);
        boolean hasDifferentWindowEvents = Intrinsics.areEqual((Object)set, this.previousWindowEvents) ^ true;
        if (hasDifferentWindowEvents) {
            this.previousWindowEvents = set;
            return true;
        }
        return false;
    }

    public final void start() {
        this.httpWsServer.start();
    }

    @JvmOverloads
    public final void stop(int timeout) {
        this.httpWsServer.stop(timeout);
        if (this.updateThread != null) {
            Thread thread = this.updateThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"updateThread");
            }
            thread.interrupt();
        }
        this.caretInfoUpdater.stop();
    }

    public static /* synthetic */ void stop$default(ProjectorServer projectorServer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        projectorServer.stop(n);
    }

    @JvmOverloads
    public final void stop() {
        ProjectorServer.stop$default(this, 0, 1, null);
    }

    private ProjectorServer(int port, LaterInvokator laterInvokator, boolean isAgent) {
        this.laterInvokator = laterInvokator;
        this.isAgent = isAgent;
        this.httpWsServer = new ProjectorHttpWsServer(this, port, port){
            final /* synthetic */ ProjectorServer this$0;
            final /* synthetic */ int $port;

            public void onStart() {
                Logger.DefaultImpls.info$default((Logger)ProjectorServer.access$getLogger$cp(), null, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ httpWsServer.1 this$0;

                    @NotNull
                    public final String invoke() {
                        return "Server started on port " + this.this$0.$port;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }), (int)1, null);
                ProjectorServer.access$setUpdateThread$p(this.this$0, ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ httpWsServer.1 this$0;

                    public final void invoke() {
                        Logger.DefaultImpls.debug$default((Logger)ProjectorServer.access$getLogger$cp(), null, (Function0)httpWsServer.onStart.1.INSTANCE, (int)1, null);
                        while (true) {
                            Thread thread = Thread.currentThread();
                            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
                            if (thread.isInterrupted()) break;
                            try {
                                List dataToSend = ProjectorServer.access$createDataToSend(this.this$0.this$0);
                                ProjectorServer.access$sendPictures(this.this$0.this$0, dataToSend);
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                            }
                            catch (Throwable t) {
                                ProjectorServer.access$getLogger$cp().error(t, (Function0)httpWsServer.onStart.2.INSTANCE);
                            }
                        }
                        Logger.DefaultImpls.debug$default((Logger)ProjectorServer.access$getLogger$cp(), null, (Function0)httpWsServer.onStart.3.INSTANCE, (int)1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }), (int)29, null));
                ProjectorServer.access$getCaretInfoUpdater$p(this.this$0).start();
            }

            public void onWsMessage(@NotNull WebSocket connection, @NotNull ByteBuffer message) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                throw (Throwable)new RuntimeException("Unsupported message type: " + message);
            }

            public void onWsMessage(@NotNull WebSocket connection, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Object object = connection.getAttachment();
                Intrinsics.checkNotNull((Object)object);
                ClientSettings clientSettings = (ClientSettings)object;
                if (clientSettings instanceof ConnectedClientSettings) {
                    ProjectorServer.access$setUpClient(this.this$0, connection, (ConnectedClientSettings)clientSettings, message);
                } else if (clientSettings instanceof SetUpClientSettings) {
                    PVolatileImage p1;
                    connection.setAttachment((Object)new ReadyClientSettings(clientSettings.getConnectionMillis(), ((SetUpClientSettings)clientSettings).getSetUpClientData()));
                    Iterable $this$forEach$iv = PVolatileImage.Companion.getImages();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        p1 = (PVolatileImage)element$iv;
                        boolean bl = false;
                        p1.invalidate();
                    }
                    $this$forEach$iv = PWindow.Companion.getWindows();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PWindow it = (PWindow)element$iv;
                        boolean bl = false;
                        SwingUtilities.invokeAndWait(new Runnable(it){
                            final /* synthetic */ PWindow $it;

                            public final void run() {
                                this.$it.getTarget().revalidate();
                            }
                            {
                                this.$it = pWindow;
                            }
                        });
                    }
                    $this$forEach$iv = PWindow.Companion.getWindows();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        p1 = (PWindow)element$iv;
                        boolean bl = false;
                        p1.repaint();
                    }
                    ProjectorServer.access$setPreviousWindowEvents$p(this.this$0, SetsKt.emptySet());
                    ProjectorServer.access$getCaretInfoUpdater$p(this.this$0).createCaretInfoEvent();
                    PanelUpdater.INSTANCE.updateAll();
                } else if (clientSettings instanceof ReadyClientSettings) {
                    SetUpClientData $i$f$forEach = ((ReadyClientSettings)clientSettings).getSetUpClientData();
                    boolean bl = false;
                    boolean bl2 = false;
                    SetUpClientData $this$with = $i$f$forEach;
                    boolean bl3 = false;
                    String decompressed = (String)$this$with.getToServerMessageDecompressor().decompress((Object)message);
                    List events = (List)$this$with.getToServerMessageDecoder().decode((Object)decompressed);
                    Iterable $this$forEach$iv = events;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv) {
                        ClientEvent it = (ClientEvent)element$iv;
                        boolean bl4 = false;
                        ProjectorServer.access$processMessage(this.this$0, (ReadyClientSettings)clientSettings, it);
                    }
                }
            }

            public void onWsClose(@NotNull WebSocket connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                Logger.DefaultImpls.info$default((Logger)ProjectorServer.access$getLogger$cp(), null, (Function0)((Function0)new Function0<String>(connection){
                    final /* synthetic */ WebSocket $connection;

                    @NotNull
                    public final String invoke() {
                        Serializable serializable = this.$connection.getRemoteSocketAddress();
                        return (serializable != null && (serializable = ((InetSocketAddress)serializable).getAddress()) != null ? ((InetAddress)serializable).getHostAddress() : null) + " disconnected.";
                    }
                    {
                        this.$connection = webSocket;
                        super(0);
                    }
                }), (int)1, null);
            }

            public void onWsOpen(@NotNull WebSocket connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                connection.setAttachment((Object)new ConnectedClientSettings(System.currentTimeMillis()));
                Logger.DefaultImpls.info$default((Logger)ProjectorServer.access$getLogger$cp(), null, (Function0)((Function0)new Function0<String>(connection){
                    final /* synthetic */ WebSocket $connection;

                    @NotNull
                    public final String invoke() {
                        StringBuilder stringBuilder = new StringBuilder();
                        InetSocketAddress inetSocketAddress = this.$connection.getRemoteSocketAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"connection.remoteSocketAddress");
                        InetAddress inetAddress = inetSocketAddress.getAddress();
                        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"connection.remoteSocketAddress.address");
                        return stringBuilder.append(inetAddress.getHostAddress()).append(" connected.").toString();
                    }
                    {
                        this.$connection = webSocket;
                        super(0);
                    }
                }), (int)1, null);
            }

            public void onError(@Nullable WebSocket connection, @NotNull Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ProjectorServer.access$getLogger$cp().error((Throwable)e, (Function0)httpWsServer.onError.1.INSTANCE);
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public List<MainWindow> getMainWindows() {
                $this$map$iv = org.jetbrains.projector.server.ProjectorServer$Companion.access$getMainWindows(ProjectorServer.Companion);
                $i$f$map = false;
                var3_3 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var8_8 = (PWindow)item$iv$iv;
                    var19_17 = destination$iv$iv;
                    $i$a$-map-ProjectorServer$httpWsServer$1$getMainWindows$1 = false;
                    v0 = it.getTitle();
                    v1 = it.getIcons();
                    if (v1 == null || (v1 = CollectionsKt.firstOrNull((List)v1)) == null) ** GOTO lbl-1000
                    var10_10 = v1;
                    var11_11 = false;
                    var12_12 = false;
                    var13_13 = var10_10;
                    var14_14 = v0;
                    $i$a$-let-ProjectorServer$httpWsServer$1$getMainWindows$1$1 = false;
                    v2 = imageId;
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.projector.common.protocol.data.ImageId");
                    }
                    v3 = ProjectorImageCacher.INSTANCE.getImage((ImageId)v2);
                    if (!(v3 instanceof ImageData.PngBase64)) {
                        v3 = null;
                    }
                    var18_16 = (ImageData.PngBase64)v3;
                    v0 = var14_14;
                    v1 = var18_16;
                    if (v1 != null) {
                        v4 = v1.getPngBase64();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = null;
                    }
                    var21_19 = v4;
                    var22_20 = v0;
                    var20_18 = new MainWindow(var22_20, var21_19);
                    var19_17.add(var20_18);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = this$0;
                this.$port = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        this.wasStarted$delegate = new ProjectorServer$wasStarted$2(this.httpWsServer);
        this.caretInfoQueue = new ConcurrentLinkedQueue();
        this.caretInfoUpdater = new CaretInfoUpdater((Function1<? super ServerCaretInfoChangedEvent.CaretInfoChange, Unit>)((Function1)new Function1<ServerCaretInfoChangedEvent.CaretInfoChange, Unit>(this){
            final /* synthetic */ ProjectorServer this$0;

            public final void invoke(@NotNull ServerCaretInfoChangedEvent.CaretInfoChange caretInfo) {
                Intrinsics.checkNotNullParameter((Object)caretInfo, (String)"caretInfo");
                ProjectorServer.access$getCaretInfoQueue$p(this.this$0).add(caretInfo);
            }
            {
                this.this$0 = projectorServer;
                super(1);
            }
        }));
        this.markdownQueue = new ConcurrentLinkedQueue();
        this.ideaColors = new IdeColors((Function1<? super ServerWindowColorsEvent.ColorsStorage, Unit>)((Function1)new Function1<ServerWindowColorsEvent.ColorsStorage, Unit>(this){
            final /* synthetic */ ProjectorServer this$0;

            public final void invoke(@NotNull ServerWindowColorsEvent.ColorsStorage colors) {
                Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
                ProjectorServer.access$setWindowColorsEvent$p(this.this$0, new ServerWindowColorsEvent(colors));
            }
            {
                this.this$0 = projectorServer;
                super(1);
            }
        }));
        PanelUpdater.INSTANCE.setShowCallback((Function2)new Function2<Integer, Boolean, Unit>(){

            public final void invoke(int id2, boolean show) {
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownShowEvent(id2, show));
            }
        });
        PanelUpdater.INSTANCE.setResizeCallback((Function2)new Function2<Integer, Dimension, Unit>(){

            public final void invoke(int id2, @NotNull Dimension size) {
                Intrinsics.checkNotNullParameter((Object)size, (String)"size");
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownResizeEvent(id2, ConvertKt.toCommonIntSize(size)));
            }
        });
        PanelUpdater.INSTANCE.setMoveCallback((Function2)new Function2<Integer, java.awt.Point, Unit>(){

            public final void invoke(int id2, @NotNull java.awt.Point point) {
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownMoveEvent(id2, Companion.shift(point, PGraphicsDevice.INSTANCE.getClientShift())));
            }
        });
        PanelUpdater.INSTANCE.setDisposeCallback((Function1)new Function1<Integer, Unit>(){

            public final void invoke(int id2) {
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownDisposeEvent(id2));
            }
        });
        PanelUpdater.INSTANCE.setPlaceToWindowCallback((Function2)new Function2<Integer, Component, Unit>(){

            public final void invoke(int id2, @Nullable Component rootComponent) {
                block1: {
                    Component component = rootComponent;
                    if (component == null) break block1;
                    Component component2 = component;
                    boolean bl = false;
                    boolean bl2 = false;
                    Component it = component2;
                    boolean bl3 = false;
                    Object peer = AWTAccessor.getComponentAccessor().getPeer(it);
                    if (peer instanceof PComponentPeer) {
                        markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownPlaceToWindowEvent(id2, ((PComponentPeer)peer).getPWindow().getId()));
                    }
                }
            }
        });
        PanelUpdater.INSTANCE.setSetHtmlCallback((Function2)new Function2<Integer, String, Unit>(){

            public final void invoke(int id2, @NotNull String html) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownSetHtmlEvent(id2, html));
            }
        });
        PanelUpdater.INSTANCE.setSetCssCallback((Function2)new Function2<Integer, String, Unit>(){

            public final void invoke(int id2, @NotNull String css) {
                Intrinsics.checkNotNullParameter((Object)css, (String)"css");
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownSetCssEvent(id2, css));
            }
        });
        PanelUpdater.INSTANCE.setScrollCallback((Function2)new Function2<Integer, Integer, Unit>(){

            public final void invoke(int id2, int offset) {
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownScrollEvent(id2, offset));
            }
        });
        PanelUpdater.INSTANCE.setBrowseUriCallback((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String link) {
                Intrinsics.checkNotNullParameter((Object)link, (String)"link");
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownBrowseUriEvent(link));
            }
        });
        this.previousWindowEvents = SetsKt.emptySet();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(ProjectorServer.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
        mouseModifierMask = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)MouseModifier.ALT_KEY, (Object)512), TuplesKt.to((Object)MouseModifier.CTRL_KEY, (Object)128), TuplesKt.to((Object)MouseModifier.SHIFT_KEY, (Object)64), TuplesKt.to((Object)MouseModifier.META_KEY, (Object)256)});
        ENABLE_BIG_COLLECTIONS_CHECKS = Intrinsics.areEqual((Object)System.getProperty("org.jetbrains.projector.server.debug.collections.checks"), (Object)"true");
        Object object = System.getProperty("org.jetbrains.projector.server.debug.collections.checks.size");
        BIG_COLLECTIONS_CHECKS_START_SIZE = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 10000;
    }

    public static final /* synthetic */ LaterInvokator access$getLaterInvokator$p(ProjectorServer $this) {
        return $this.laterInvokator;
    }

    public static final /* synthetic */ Thread access$getUpdateThread$p(ProjectorServer $this) {
        Thread thread = $this.updateThread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateThread");
        }
        return thread;
    }

    public static final /* synthetic */ void access$setUpdateThread$p(ProjectorServer $this, Thread thread) {
        $this.updateThread = thread;
    }

    public static final /* synthetic */ List access$createDataToSend(ProjectorServer $this) {
        return $this.createDataToSend();
    }

    public static final /* synthetic */ void access$sendPictures(ProjectorServer $this, List dataToSend) {
        $this.sendPictures(dataToSend);
    }

    public static final /* synthetic */ CaretInfoUpdater access$getCaretInfoUpdater$p(ProjectorServer $this) {
        return $this.caretInfoUpdater;
    }

    public static final /* synthetic */ void access$setUpClient(ProjectorServer $this, WebSocket conn, ConnectedClientSettings connectedClientSettings, String message) {
        $this.setUpClient(conn, connectedClientSettings, message);
    }

    public static final /* synthetic */ Set access$getPreviousWindowEvents$p(ProjectorServer $this) {
        return $this.previousWindowEvents;
    }

    public static final /* synthetic */ void access$setPreviousWindowEvents$p(ProjectorServer $this, Set set) {
        $this.previousWindowEvents = set;
    }

    public static final /* synthetic */ void access$processMessage(ProjectorServer $this, ReadyClientSettings clientSettings, ClientEvent message) {
        $this.processMessage(clientSettings, message);
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getCaretInfoQueue$p(ProjectorServer $this) {
        return $this.caretInfoQueue;
    }

    public static final /* synthetic */ ServerWindowColorsEvent access$getWindowColorsEvent$p(ProjectorServer $this) {
        return $this.windowColorsEvent;
    }

    public static final /* synthetic */ void access$setWindowColorsEvent$p(ProjectorServer $this, ServerWindowColorsEvent serverWindowColorsEvent) {
        $this.windowColorsEvent = serverWindowColorsEvent;
    }

    public /* synthetic */ ProjectorServer(int port, LaterInvokator laterInvokator, boolean isAgent, DefaultConstructorMarker $constructor_marker) {
        this(port, laterInvokator, isAgent);
    }

    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    @JvmStatic
    @NotNull
    public static final ProjectorServer startServer(boolean isAgent) {
        return Companion.startServer(isAgent);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010(\u001a\u00020)H\u0002J0\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u000204H\u0002J \u00105\u001a\u0002062\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u0002072\u0006\u00103\u001a\u000204H\u0002J\u0010\u00108\u001a\u00020-2\u0006\u00109\u001a\u00020-H\u0002J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020\rH\u0002J\u0018\u0010?\u001a\u00020)2\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020\u0004H\u0002J\u001e\u0010B\u001a\u0004\u0018\u00010\r2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020)0DH\u0002J\b\u0010F\u001a\u00020)H\u0002J\b\u0010G\u001a\u00020)H\u0002J\b\u0010H\u001a\u00020)H\u0002J\b\u0010I\u001a\u00020)H\u0002J\b\u0010J\u001a\u00020)H\u0002J\b\u0010K\u001a\u00020)H\u0002J\b\u0010L\u001a\u00020)H\u0002J\b\u0010M\u001a\u00020)H\u0002J\u0012\u0010N\u001a\u00020O2\b\b\u0002\u0010P\u001a\u00020\u000fH\u0007J\u0014\u0010Q\u001a\u00020R*\u00020S2\u0006\u0010Q\u001a\u00020SH\u0002J\u0014\u0010T\u001a\u00020U*\u00020-2\u0006\u0010Q\u001a\u00020SH\u0002J\u0012\u0010V\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020'0WH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\"\u0010\u0002\u001a\u0004\b!\u0010\u0011R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00040&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lorg/jetbrains/projector/server/ProjectorServer$Companion;", "", "()V", "BIG_COLLECTIONS_CHECKS_START_SIZE", "", "getBIG_COLLECTIONS_CHECKS_START_SIZE", "()I", "setBIG_COLLECTIONS_CHECKS_START_SIZE", "(I)V", "DEFAULT_BIG_COLLECTIONS_CHECKS_SIZE", "DEFAULT_PORT", "DEFAULT_SCROLL_AMOUNT", "ENABLE_AUTO_KEYMAP_SETTING", "", "ENABLE_BIG_COLLECTIONS_CHECKS", "", "getENABLE_BIG_COLLECTIONS_CHECKS", "()Z", "setENABLE_BIG_COLLECTIONS_CHECKS", "(Z)V", "ENABLE_CONNECTION_CONFIRMATION", "ENABLE_PROPERTY_NAME", "PIXEL_DELTA_ENOUGH_FOR_SCROLLING", "PIXEL_PER_UNIT", "PORT_PROPERTY_NAME", "RO_TOKEN_ENV_NAME", "SSL_ENV_NAME", "SSL_FILE_PATH", "SSL_KEY_PASSWORD", "SSL_STORE_PASSWORD", "SSL_STORE_TYPE", "TOKEN_ENV_NAME", "TOUCH_PIXEL_PER_UNIT", "isEnabled", "isEnabled$annotations", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "mouseModifierMask", "", "Lorg/jetbrains/projector/common/protocol/toServer/MouseModifier;", "calculateMainWindowShift", "", "createMouseEvent", "Ljava/awt/event/MouseEvent;", "source", "Ljava/awt/Component;", "event", "Lorg/jetbrains/projector/common/protocol/toServer/ClientMouseEvent;", "previousTouchState", "Lorg/jetbrains/projector/server/ReadyClientSettings$TouchState;", "newTouchState", "connectionMillis", "", "createMouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientWheelEvent;", "focusOwnerOrTarget", "target", "getMainWindows", "", "Lorg/jetbrains/projector/awt/PWindow;", "getProperty", "propName", "resize", "width", "height", "setSsl", "setWebSocketFactory", "Lkotlin/Function1;", "Lorg/java_websocket/WebSocketServerFactory;", "setupAgentSingletons", "setupAgentSystemProperties", "setupFontManager", "setupGraphicsEnvironment", "setupRepaintManager", "setupSingletons", "setupSystemProperties", "setupToolkit", "startServer", "Lorg/jetbrains/projector/server/ProjectorServer;", "isAgent", "shift", "Lorg/jetbrains/projector/common/protocol/data/Point;", "Ljava/awt/Point;", "shiftBounds", "Lorg/jetbrains/projector/common/protocol/data/CommonRectangle;", "toMouseInt", "", "projector-server"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void isEnabled$annotations() {
        }

        public final boolean isEnabled() {
            boolean bl;
            String string = System.getProperty(ProjectorServer.ENABLE_PROPERTY_NAME);
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                bl = Boolean.parseBoolean(string2);
            } else {
                bl = false;
            }
            return bl;
        }

        private final String getProperty(String propName) {
            String string = System.getProperty(propName);
            if (string == null) {
                string = System.getenv(propName);
            }
            return string;
        }

        private final Component focusOwnerOrTarget(Component target) {
            KeyboardFocusManager manager;
            KeyboardFocusManager keyboardFocusManager = manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Intrinsics.checkNotNullExpressionValue((Object)keyboardFocusManager, (String)"manager");
            Component component = keyboardFocusManager.getFocusOwner();
            if (component == null) {
                component = target;
            }
            return component;
        }

        /*
         * WARNING - void declaration
         */
        private final int toMouseInt(Set<? extends MouseModifier> $this$toMouseInt) {
            void $this$fold$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = $this$toMouseInt;
            Map map = mouseModifierMask;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                MouseModifier mouseModifier = (MouseModifier)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Integer n = ((Number)MapsKt.getValue((Map)map, (Object)p1)).intValue();
                collection.add(n);
            }
            $this$map$iv = (List)destination$iv$iv;
            int initial$iv = 0;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void p2;
                int n = ((Number)element$iv).intValue();
                int p1 = accumulator$iv;
                boolean bl = false;
                accumulator$iv = p1 | p2;
            }
            return accumulator$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final MouseEvent createMouseEvent(Component source, ClientMouseEvent event, ReadyClientSettings.TouchState previousTouchState, ReadyClientSettings.TouchState newTouchState, long connectionMillis) {
            int n;
            int n2;
            java.awt.Point locationOnScreen = source.getLocationOnScreen();
            switch (ProjectorServer$Companion$WhenMappings.$EnumSwitchMapping$0[event.getMouseEventType().ordinal()]) {
                case 1: {
                    n2 = 503;
                    break;
                }
                case 2: {
                    n2 = 501;
                    break;
                }
                case 3: {
                    n2 = 502;
                    break;
                }
                case 4: {
                    n2 = 500;
                    break;
                }
                case 5: {
                    n2 = 505;
                    break;
                }
                case 6: {
                    n2 = 506;
                    break;
                }
                case 7: {
                    if (previousTouchState instanceof ReadyClientSettings.TouchState.WithCoordinates && newTouchState instanceof ReadyClientSettings.TouchState.Scrolling) {
                        void wheelDelta;
                        int deltaY;
                        int deltaX = ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getLastX() - ((ReadyClientSettings.TouchState.WithCoordinates)((Object)previousTouchState)).getLastX();
                        Function0<Boolean> $fun$isHorizontal$1 = new Function0<Boolean>(deltaX, deltaY = ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getLastY() - ((ReadyClientSettings.TouchState.WithCoordinates)((Object)previousTouchState)).getLastY()){
                            final /* synthetic */ int $deltaX;
                            final /* synthetic */ int $deltaY;

                            public final boolean invoke() {
                                int n = this.$deltaX;
                                boolean bl = false;
                                int n2 = Math.abs(n);
                                n = this.$deltaY;
                                bl = false;
                                return n2 > Math.abs(n);
                            }
                            {
                                this.$deltaX = n;
                                this.$deltaY = n2;
                                super(0);
                            }
                        };
                        Pair pair = $fun$isHorizontal$1.invoke() ? TuplesKt.to((Object)deltaX, (Object)(this.toMouseInt(event.getModifiers()) | 0x40)) : TuplesKt.to((Object)deltaY, (Object)this.toMouseInt(event.getModifiers()));
                        int n3 = ((Number)pair.component1()).intValue();
                        int modifiers = ((Number)pair.component2()).intValue();
                        void negatedWheelDelta = -wheelDelta;
                        double normalizedWheelDelta = (double)negatedWheelDelta / (double)300;
                        int notNullNormalizedWheelDelta = (int)ConvertKt.roundToInfinity(normalizedWheelDelta);
                        return new MouseWheelEvent(source, 507, connectionMillis + (long)event.getTimeStamp(), modifiers, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialX() - locationOnScreen.x, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialY() - locationOnScreen.y, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialX() - locationOnScreen.x, ((ReadyClientSettings.TouchState.Scrolling)newTouchState).getInitialY() - locationOnScreen.y, 0, false, 0, 1, notNullNormalizedWheelDelta, normalizedWheelDelta);
                    }
                    n2 = 506;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int id2 = n2;
            switch (ProjectorServer$Companion$WhenMappings.$EnumSwitchMapping$1[event.getMouseEventType().ordinal()]) {
                case 1: 
                case 2: {
                    n = 0;
                    break;
                }
                default: {
                    n = event.getButton() + 1;
                }
            }
            int awtEventButton = n;
            int modifiers = this.toMouseInt(event.getModifiers());
            int buttonModifier = awtEventButton == 0 || event.getMouseEventType() == ClientMouseEvent.MouseEventType.UP ? 0 : InputEvent.getMaskForButton(awtEventButton);
            boolean canTriggerPopup = awtEventButton == 3;
            return new MouseEvent(source, id2, connectionMillis + (long)event.getTimeStamp(), modifiers | buttonModifier, event.getX() - locationOnScreen.x, event.getY() - locationOnScreen.y, event.getClickCount(), canTriggerPopup, awtEventButton);
        }

        /*
         * WARNING - void declaration
         */
        private final MouseWheelEvent createMouseWheelEvent(Component source, ClientWheelEvent event, long connectionMillis) {
            void mode;
            Pair pair;
            createMouseWheelEvent.1 $fun$isHorizontal$1 = createMouseWheelEvent.1.INSTANCE;
            Pair pair2 = $fun$isHorizontal$1.invoke(event) ? TuplesKt.to((Object)event.getDeltaX(), (Object)(this.toMouseInt(event.getModifiers()) | 0x40)) : TuplesKt.to((Object)event.getDeltaY(), (Object)this.toMouseInt(event.getModifiers()));
            double d = ((Number)pair2.component1()).doubleValue();
            int modifiers = ((Number)pair2.component2()).intValue();
            switch (ProjectorServer$Companion$WhenMappings.$EnumSwitchMapping$2[event.getMode().ordinal()]) {
                case 1: {
                    void wheelDelta;
                    pair = TuplesKt.to((Object)0, (Object)((double)(wheelDelta / (double)100)));
                    break;
                }
                case 2: {
                    void wheelDelta;
                    pair = TuplesKt.to((Object)0, (Object)((double)wheelDelta));
                    break;
                }
                case 3: {
                    void wheelDelta;
                    pair = TuplesKt.to((Object)1, (Object)((double)wheelDelta));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Pair pair3 = pair;
            int n = ((Number)pair3.component1()).intValue();
            double normalizedWheelDelta = ((Number)pair3.component2()).doubleValue();
            int notNullNormalizedWheelDelta = (int)ConvertKt.roundToInfinity(normalizedWheelDelta);
            java.awt.Point locationOnScreen = source.getLocationOnScreen();
            return new MouseWheelEvent(source, 507, connectionMillis + (long)event.getTimeStamp(), modifiers, event.getX() - locationOnScreen.x, event.getY() - locationOnScreen.y, event.getX() - locationOnScreen.x, event.getY() - locationOnScreen.y, 0, false, (int)mode, 1, notNullNormalizedWheelDelta, normalizedWheelDelta);
        }

        private final void setupGraphicsEnvironment() {
            Class localGE;
            Object[] classes = GraphicsEnvironment.class.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classes, (String)"classes");
            Class clazz = localGE = (Class)ArraysKt.single((Object[])classes);
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"localGE");
            boolean bl = Intrinsics.areEqual((Object)clazz.getName(), (Object)"java.awt.GraphicsEnvironment$LocalGE");
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Field field = localGE.getDeclaredField("INSTANCE");
            bl2 = false;
            bl3 = false;
            Field $this$apply = field;
            boolean bl6 = false;
            ReflectKt.unprotect($this$apply);
            $this$apply.set(null, new PGraphicsEnvironment());
        }

        private final void setupToolkit() {
            Field field = Toolkit.class.getDeclaredField("toolkit");
            boolean bl = false;
            boolean bl2 = false;
            Field $this$apply = field;
            boolean bl3 = false;
            ReflectKt.unprotect($this$apply);
            $this$apply.set(null, new PToolkit());
        }

        private final void setupFontManager() {
            Field field = FontManagerFactory.class.getDeclaredField("instance");
            boolean bl = false;
            boolean bl2 = false;
            Field $this$apply = field;
            boolean bl3 = false;
            ReflectKt.unprotect($this$apply);
            $this$apply.set(null, PFontManager.INSTANCE);
        }

        private final void setupRepaintManager() {
        }

        private final void setupSystemProperties() {
            System.setProperty(ProjectorServer.ENABLE_PROPERTY_NAME, String.valueOf(true));
            System.setProperty("java.awt.graphicsenv", PGraphicsEnvironment.class.getCanonicalName());
            System.setProperty("awt.toolkit", PToolkit.class.getCanonicalName());
            System.setProperty("sun.font.fontmanager", PFontManager.class.getCanonicalName());
            System.setProperty("java.awt.headless", String.valueOf(false));
            System.setProperty("swing.bufferPerWindow", String.valueOf(false));
            System.setProperty("awt.nativeDoubleBuffering", String.valueOf(true));
            System.setProperty("swing.volatileImageBufferEnabled", String.valueOf(false));
        }

        private final void setupSingletons() {
            this.setupGraphicsEnvironment();
            this.setupToolkit();
            this.setupFontManager();
            this.setupRepaintManager();
        }

        private final void setupAgentSystemProperties() {
            System.setProperty(ProjectorServer.ENABLE_PROPERTY_NAME, String.valueOf(true));
            System.setProperty("swing.bufferPerWindow", String.valueOf(false));
            System.setProperty("swing.volatileImageBufferEnabled", String.valueOf(false));
        }

        private final void setupAgentSingletons() {
            this.setupFontManager();
            this.setupRepaintManager();
        }

        /*
         * WARNING - void declaration
         */
        private final List<PWindow> getMainWindows() {
            List list;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = PWindow.Companion.getWindows();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PWindow it = (PWindow)element$iv$iv;
                boolean bl = false;
                if (!(ConvertKt.getWindowType(it) == WindowType.IDEA_WINDOW)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List ideWindows = (List)destination$iv$iv;
            Collection collection = ideWindows;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return ideWindows;
            }
            PWindow pWindow = (PWindow)CollectionsKt.firstOrNull((List)PWindow.Companion.getWindows());
            if (pWindow != null) {
                collection = pWindow;
                bl = false;
                boolean bl2 = false;
                Collection p1 = collection;
                boolean bl3 = false;
                list = CollectionsKt.listOf((Object)p1);
            } else {
                list = null;
            }
            collection = list;
            bl = false;
            Collection collection2 = collection;
            if (collection2 == null) {
                collection2 = CollectionsKt.emptyList();
            }
            return collection2;
        }

        private final CommonRectangle shiftBounds(Component $this$shiftBounds, java.awt.Point shift) {
            Rectangle rectangle = $this$shiftBounds.getBounds();
            boolean bl = false;
            boolean bl2 = false;
            Rectangle $this$run = rectangle;
            boolean bl3 = false;
            return new CommonRectangle((double)($this$run.x - shift.x), (double)($this$run.y - shift.y), (double)$this$run.width, (double)$this$run.height);
        }

        private final Point shift(java.awt.Point $this$shift, java.awt.Point shift) {
            return new Point((double)($this$shift.x - shift.x), (double)($this$shift.y - shift.y));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void calculateMainWindowShift() {
            Object object = (PWindow)CollectionsKt.firstOrNull(this.getMainWindows());
            if (object != null && (object = object.getTarget()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object window = object2;
                boolean bl3 = false;
                Object object3 = ((Component)window).getTreeLock();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"window.treeLock");
                Object object4 = object3;
                boolean bl4 = false;
                boolean bl5 = false;
                synchronized (object4) {
                    Cloneable it;
                    boolean bl6;
                    boolean bl7;
                    Cloneable cloneable;
                    boolean bl8 = false;
                    double x = 0.0;
                    double y = 0.0;
                    if (window instanceof Frame) {
                        Insets insets = ((Frame)window).getInsets();
                        if (insets != null) {
                            cloneable = insets;
                            bl7 = false;
                            bl6 = false;
                            it = cloneable;
                            boolean bl9 = false;
                            x += (double)((Insets)it).left;
                            y += (double)((Insets)it).top;
                        }
                    }
                    Rectangle rectangle = ((Component)window).getBounds();
                    if (rectangle != null) {
                        cloneable = rectangle;
                        bl7 = false;
                        bl6 = false;
                        it = cloneable;
                        boolean bl10 = false;
                        x += (double)it.x;
                        y += (double)it.y;
                    }
                    PGraphicsDevice.INSTANCE.getClientShift().setLocation(x, y);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void resize(int width, int height) {
            void $this$mapTo$iv$iv;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (ge instanceof PGraphicsEnvironment) {
                ((PGraphicsEnvironment)ge).setSize(width, height);
            }
            Iterable $this$map$iv = this.getMainWindows();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void receiver;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Component component = ((PWindow)receiver).getTarget();
                collection.add(component);
            }
            List list = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            List mainWindows = list;
            boolean bl3 = false;
            SwingUtilities.invokeLater(new Runnable(mainWindows, width, height){
                final /* synthetic */ List $mainWindows;
                final /* synthetic */ int $width$inlined;
                final /* synthetic */ int $height$inlined;
                {
                    this.$mainWindows = list;
                    this.$width$inlined = n;
                    this.$height$inlined = n2;
                }

                public final void run() {
                    Iterable $this$forEach$iv = this.$mainWindows;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Component it = (Component)element$iv;
                        boolean bl = false;
                        java.awt.Point point = new java.awt.Point(PGraphicsDevice.INSTANCE.getClientShift());
                        int widthWithInsets = this.$width$inlined;
                        int heightWithInsets = this.$height$inlined;
                        if (it instanceof Frame && ((Frame)it).getInsets() != null) {
                            Insets insets;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            Insets i = insets;
                            boolean bl4 = false;
                            point.x -= i.left;
                            point.y -= i.top;
                            widthWithInsets += i.left + i.right;
                            heightWithInsets += i.top + i.bottom;
                        }
                        it.setBounds(point.x, point.y, widthWithInsets, heightWithInsets);
                        it.revalidate();
                    }
                }
            });
        }

        @JvmStatic
        @NotNull
        public final ProjectorServer startServer(boolean isAgent) {
            Unit unit;
            LoggerKt.setLoggerFactory((Function1)startServer.1.INSTANCE);
            ProjectorAwtInitializer.INSTANCE.initProjectorAwt();
            if (!isAgent) {
                this.setupSystemProperties();
                this.setupSingletons();
                IjInjectorAgentInitializer.INSTANCE.init();
            }
            ProjectorAwtInitializer.INSTANCE.initDefaults();
            SettingsInitializer.INSTANCE.addTaskToInitializeIdea();
            Object object = System.getProperty(ProjectorServer.PORT_PROPERTY_NAME);
            int port = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 8887;
            Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(port){
                final /* synthetic */ int $port;

                @NotNull
                public final String invoke() {
                    return Reflection.getOrCreateKotlinClass(ProjectorServer.class).getSimpleName() + " is starting on port: " + this.$port;
                }
                {
                    this.$port = n;
                    super(0);
                }
            }), (int)1, null);
            if (this.getENABLE_BIG_COLLECTIONS_CHECKS()) {
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)startServer.3.INSTANCE, (int)1, null);
            }
            ProjectorServer projectorServer = new ProjectorServer(port, LaterInvokator.Companion.getDefaultLaterInvokator(), isAgent, null);
            boolean bl = false;
            boolean bl2 = false;
            ProjectorServer it = projectorServer;
            boolean bl3 = false;
            Do do_ = Do.INSTANCE;
            String hint2 = Companion.setSsl((Function1<? super WebSocketServerFactory, Unit>)((Function1)new Function1<WebSocketServerFactory, Unit>(it.httpWsServer){

                public final void invoke(@NotNull WebSocketServerFactory p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    ((Object)this.receiver).setWebSocketFactory(p1);
                }
            }));
            if (hint2 == null) {
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)startServer.4.1.INSTANCE, (int)1, null);
                unit = Unit.INSTANCE;
            } else {
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(hint2){
                    final /* synthetic */ String $hint;

                    @NotNull
                    public final String invoke() {
                        return "WebSocket SSL is enabled: " + this.$hint;
                    }
                    {
                        this.$hint = string;
                        super(0);
                    }
                }), (int)1, null);
                unit = Unit.INSTANCE;
            }
            Unit any$iv = unit;
            boolean $i$f$exhaustive = false;
            it.start();
            return projectorServer;
        }

        public static /* synthetic */ ProjectorServer startServer$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.startServer(bl);
        }

        private final String setSsl(Function1<? super WebSocketServerFactory, Unit> setWebSocketFactory) {
            String string = this.getProperty(ProjectorServer.SSL_ENV_NAME);
            if (string == null) {
                return null;
            }
            String sslPropertiesFilePath = string;
            try {
                Properties properties = new Properties();
                boolean bl = false;
                boolean bl2 = false;
                Properties $this$apply = properties;
                boolean bl3 = false;
                $this$apply.load(new FileInputStream(sslPropertiesFilePath));
                Properties properties2 = properties;
                setSsl.1 $fun$getOrThrow$1 = setSsl.1.INSTANCE;
                String storetype = $fun$getOrThrow$1.invoke(properties2, ProjectorServer.SSL_STORE_TYPE);
                String filePath = $fun$getOrThrow$1.invoke(properties2, ProjectorServer.SSL_FILE_PATH);
                String storePassword = $fun$getOrThrow$1.invoke(properties2, ProjectorServer.SSL_STORE_PASSWORD);
                String keyPassword = $fun$getOrThrow$1.invoke(properties2, ProjectorServer.SSL_KEY_PASSWORD);
                KeyStore keyStore = KeyStore.getInstance(storetype);
                boolean bl4 = false;
                boolean bl5 = false;
                KeyStore $this$apply2 = keyStore;
                boolean bl6 = false;
                InputStream inputStream = new FileInputStream(filePath);
                String string2 = storePassword;
                boolean bl7 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                char[] cArray = string3.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                $this$apply2.load(inputStream, cArray);
                KeyStore keyStore2 = keyStore;
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                bl5 = false;
                boolean bl8 = false;
                KeyManagerFactory $this$apply3 = keyManagerFactory;
                boolean bl9 = false;
                String string4 = keyPassword;
                boolean bl10 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                char[] cArray2 = string5.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
                $this$apply3.init(keyStore2, cArray2);
                KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                bl8 = false;
                boolean bl11 = false;
                TrustManagerFactory $this$apply4 = trustManagerFactory;
                boolean bl12 = false;
                $this$apply4.init(keyStore2);
                TrustManagerFactory trustManagerFactory2 = trustManagerFactory;
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                bl11 = false;
                boolean bl13 = false;
                SSLContext $this$apply5 = sSLContext;
                boolean bl14 = false;
                KeyManagerFactory keyManagerFactory3 = keyManagerFactory2;
                Intrinsics.checkNotNullExpressionValue((Object)keyManagerFactory3, (String)"keyManagerFactory");
                KeyManager[] keyManagerArray = keyManagerFactory3.getKeyManagers();
                TrustManagerFactory trustManagerFactory3 = trustManagerFactory2;
                Intrinsics.checkNotNullExpressionValue((Object)trustManagerFactory3, (String)"trustManagerFactory");
                $this$apply5.init(keyManagerArray, trustManagerFactory3.getTrustManagers(), null);
                SSLContext sslContext = sSLContext;
                setWebSocketFactory.invoke((Object)new DefaultSSLWebSocketServerFactory(sslContext));
                return sslPropertiesFilePath;
            }
            catch (Throwable t) {
                logger.info(t, (Function0)setSsl.2.INSTANCE);
                return null;
            }
        }

        public final boolean getENABLE_BIG_COLLECTIONS_CHECKS() {
            return ENABLE_BIG_COLLECTIONS_CHECKS;
        }

        public final void setENABLE_BIG_COLLECTIONS_CHECKS(boolean bl) {
            ENABLE_BIG_COLLECTIONS_CHECKS = bl;
        }

        public final int getBIG_COLLECTIONS_CHECKS_START_SIZE() {
            return BIG_COLLECTIONS_CHECKS_START_SIZE;
        }

        public final void setBIG_COLLECTIONS_CHECKS_START_SIZE(int n) {
            BIG_COLLECTIONS_CHECKS_START_SIZE = n;
        }

        private Companion() {
        }

        public static final /* synthetic */ MouseEvent access$createMouseEvent(Companion $this, Component source, ClientMouseEvent event, ReadyClientSettings.TouchState previousTouchState, ReadyClientSettings.TouchState newTouchState, long connectionMillis) {
            return $this.createMouseEvent(source, event, previousTouchState, newTouchState, connectionMillis);
        }

        public static final /* synthetic */ MouseWheelEvent access$createMouseWheelEvent(Companion $this, Component source, ClientWheelEvent event, long connectionMillis) {
            return $this.createMouseWheelEvent(source, event, connectionMillis);
        }

        public static final /* synthetic */ Component access$focusOwnerOrTarget(Companion $this, Component target) {
            return $this.focusOwnerOrTarget(target);
        }

        public static final /* synthetic */ List access$getMainWindows(Companion $this) {
            return $this.getMainWindows();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

