/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.service;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.MultiResolutionImage;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.image.PVolatileImage;
import org.jetbrains.projector.awt.service.ImageCacher;
import org.jetbrains.projector.common.protocol.data.ImageData;
import org.jetbrains.projector.common.protocol.data.ImageId;
import org.jetbrains.projector.common.protocol.toClient.ServerImageDataReplyEvent;
import org.jetbrains.projector.server.service.ProjectorImageCacher;
import org.jetbrains.projector.server.service.ProjectorImageCacher$putImage$1;
import org.jetbrains.projector.server.service.ProjectorImageCacherKt;
import org.jetbrains.projector.server.util.SizeAware;
import org.jetbrains.projector.util.logging.LoggerKt;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.ToolkitImage;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002,-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\"\u0010\u0012\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00060\u0004H\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\u00132\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00060 H\u0002J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\"JY\u0010#\u001a\u00020\u0011\"\b\b\u0000\u0010$*\u00020\u001a2\u0006\u0010%\u001a\u00020\b2\u0006\u0010\u0019\u001a\u0002H$2\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u00020\u00050'\u00a2\u0006\u0002\b(2\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u00020\u00160'\u00a2\u0006\u0002\b(H\u0002\u00a2\u0006\u0002\u0010*J\u001e\u0010+\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u0013*\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006."}, d2={"Lorg/jetbrains/projector/server/service/ProjectorImageCacher;", "Lorg/jetbrains/projector/awt/service/ImageCacher;", "()V", "idToImage", "", "Lorg/jetbrains/projector/common/protocol/data/ImageId;", "Lorg/jetbrains/projector/server/service/ProjectorImageCacher$LivingImage;", "identityIdToImageId", "Lorg/jetbrains/projector/server/service/ProjectorImageCacher$IdentityImageId;", "newImages", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/projector/common/protocol/toClient/ServerImageDataReplyEvent;", "getNewImages", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "newImages$delegate", "Lorg/jetbrains/projector/server/util/SizeAware;", "collectGarbage", "", "filterNullsOutOfMutableMap", "K", "map", "getImage", "Lorg/jetbrains/projector/common/protocol/data/ImageData;", "id", "getImageId", "image", "Ljava/awt/Image;", "methodName", "", "isAlive", "", "entry", "", "putImage", "Ljava/awt/image/BufferedImage;", "putImageIfNeeded", "T", "identityImageId", "imageIdBuilder", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "imageConverter", "(Lorg/jetbrains/projector/server/service/ProjectorImageCacher$IdentityImageId;Ljava/awt/Image;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "removeAllImageIdsWithoutImages", "IdentityImageId", "LivingImage", "projector-server"})
public final class ProjectorImageCacher
implements ImageCacher {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private static final SizeAware newImages$delegate;
    private static Map<ImageId, LivingImage> idToImage;
    private static final Map<IdentityImageId, ImageId> identityIdToImageId;
    public static final ProjectorImageCacher INSTANCE;

    static {
        ProjectorImageCacher projectorImageCacher;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(ProjectorImageCacher.class, "newImages", "getNewImages()Ljava/util/concurrent/ConcurrentLinkedQueue;", 0))};
        INSTANCE = projectorImageCacher = new ProjectorImageCacher();
        Collection collection = new ConcurrentLinkedQueue();
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(ProjectorImageCacher.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        newImages$delegate = new SizeAware<Collection>(collection, LoggerKt.Logger((String)string));
        boolean bl = false;
        idToImage = new LinkedHashMap();
        bl = false;
        identityIdToImageId = new LinkedHashMap();
    }

    @NotNull
    public ImageId getImageId(@NotNull Image image, @NotNull String methodName) {
        Object object;
        block3: {
            block7: {
                block8: {
                    Image image2;
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    Intrinsics.checkNotNullParameter((Object)image, (String)"image");
                                    Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                                    image2 = image;
                                    if (!(image2 instanceof BufferedImage)) break block2;
                                    object = this.putImage((BufferedImage)image);
                                    break block3;
                                }
                                if (!(image2 instanceof ToolkitImage)) break block4;
                                BufferedImage bufferedImage = ((ToolkitImage)image).getBufferedImage();
                                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"image.bufferedImage");
                                object = this.getImageId(bufferedImage, methodName + ", extracted BufferedImage from ToolkitImage");
                                break block3;
                            }
                            if (!(image2 instanceof PVolatileImage)) break block5;
                            object = (ImageId)new ImageId.PVolatileImageId(((PVolatileImage)image).getId());
                            break block3;
                        }
                        if (!(image2 instanceof SunVolatileImage)) break block6;
                        BufferedImage bufferedImage = ((SunVolatileImage)image).getSnapshot();
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"image.snapshot");
                        object = this.getImageId(bufferedImage, methodName + ", extracted snapshot from SunVolatileImage");
                        break block3;
                    }
                    if (!(image2 instanceof MultiResolutionImage)) break block7;
                    List<Image> list = ((MultiResolutionImage)((Object)image)).getResolutionVariants();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"image.resolutionVariants");
                    object = (Image)CollectionsKt.singleOrNull(list);
                    if (object == null) break block8;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    object = INSTANCE.getImageId((Image)it, methodName + ", extracted single variant");
                    if (object != null) break block3;
                }
                object = (ImageId)new ImageId.Unknown(methodName + " received MultiResolutionImage with bad variant count (" + ((MultiResolutionImage)((Object)image)).getResolutionVariants().size() + "): " + image);
                break block3;
            }
            object = (ImageId)new ImageId.Unknown(methodName + " received " + Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName() + ": " + this);
        }
        return object;
    }

    @NotNull
    public final ConcurrentLinkedQueue<ServerImageDataReplyEvent> getNewImages() {
        return (ConcurrentLinkedQueue)newImages$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends Image> void putImageIfNeeded(IdentityImageId identityImageId, T image, Function1<? super T, ? extends ImageId> imageIdBuilder, Function1<? super T, ? extends ImageData> imageConverter) {
        ProjectorImageCacher projectorImageCacher = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (projectorImageCacher) {
            boolean bl3 = false;
            Map<IdentityImageId, ImageId> map = identityIdToImageId;
            Object object = identityImageId;
            boolean bl4 = false;
            Object object2 = map;
            boolean bl5 = false;
            if (!object2.containsKey(object)) {
                ImageId imageId = (ImageId)imageIdBuilder.invoke(image);
                identityIdToImageId.put(identityImageId, imageId);
                object = idToImage;
                bl4 = false;
                object2 = object;
                bl5 = false;
                if (!object2.containsKey(imageId)) {
                    ImageData imageData = (ImageData)imageConverter.invoke(image);
                    idToImage.put(imageId, new LivingImage(new SoftReference<Image>(image), imageData));
                    INSTANCE.getNewImages().add(new ServerImageDataReplyEvent(imageId, imageData));
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final ImageId putImage(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        IdentityImageId id2 = new IdentityImageId(System.identityHashCode(image), ProjectorImageCacherKt.getStateHash(image));
        this.putImageIfNeeded(id2, (Image)image, (Function1)ProjectorImageCacher$putImage$1.INSTANCE, putImage.2.INSTANCE);
        ImageId imageId = identityIdToImageId.get(id2);
        Intrinsics.checkNotNull((Object)imageId);
        return imageId;
    }

    @Nullable
    public final ImageData getImage(@NotNull ImageId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        LivingImage livingImage = idToImage.get(id2);
        return livingImage != null ? livingImage.getData() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void collectGarbage() {
        ProjectorImageCacher projectorImageCacher = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (projectorImageCacher) {
            boolean bl3 = false;
            INSTANCE.filterNullsOutOfMutableMap(idToImage);
            INSTANCE.removeAllImageIdsWithoutImages(identityIdToImageId);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <K> boolean isAlive(Map.Entry<? extends K, LivingImage> entry) {
        return entry.getValue().getReference().get() != null;
    }

    private final <K> void filterNullsOutOfMutableMap(Map<K, LivingImage> map) {
        Map<K, LivingImage> map2 = map;
        boolean bl = false;
        Iterator<Map.Entry<K, LivingImage>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, LivingImage> next = iterator.next();
            if (this.isAlive(next)) continue;
            iterator.remove();
        }
    }

    private final <K> void removeAllImageIdsWithoutImages(Map<K, ImageId> $this$removeAllImageIdsWithoutImages) {
        Map<K, ImageId> map = $this$removeAllImageIdsWithoutImages;
        boolean bl = false;
        Iterator<Map.Entry<K, ImageId>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, ImageId> next = iterator.next();
            Map<ImageId, LivingImage> map2 = idToImage;
            ImageId imageId = next.getValue();
            boolean bl2 = false;
            Map<ImageId, LivingImage> map3 = map2;
            boolean bl3 = false;
            if (map3.containsKey(imageId)) continue;
            iterator.remove();
        }
    }

    private ProjectorImageCacher() {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/projector/server/service/ProjectorImageCacher$LivingImage;", "", "reference", "Ljava/lang/ref/SoftReference;", "Ljava/awt/Image;", "data", "Lorg/jetbrains/projector/common/protocol/data/ImageData;", "(Ljava/lang/ref/SoftReference;Lorg/jetbrains/projector/common/protocol/data/ImageData;)V", "getData", "()Lorg/jetbrains/projector/common/protocol/data/ImageData;", "getReference", "()Ljava/lang/ref/SoftReference;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "projector-server"})
    private static final class LivingImage {
        @NotNull
        private final SoftReference<Image> reference;
        @NotNull
        private final ImageData data;

        @NotNull
        public final SoftReference<Image> getReference() {
            return this.reference;
        }

        @NotNull
        public final ImageData getData() {
            return this.data;
        }

        public LivingImage(@NotNull SoftReference<Image> reference, @NotNull ImageData data) {
            Intrinsics.checkNotNullParameter(reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.reference = reference;
            this.data = data;
        }

        @NotNull
        public final SoftReference<Image> component1() {
            return this.reference;
        }

        @NotNull
        public final ImageData component2() {
            return this.data;
        }

        @NotNull
        public final LivingImage copy(@NotNull SoftReference<Image> reference, @NotNull ImageData data) {
            Intrinsics.checkNotNullParameter(reference, (String)"reference");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new LivingImage(reference, data);
        }

        public static /* synthetic */ LivingImage copy$default(LivingImage livingImage, SoftReference softReference, ImageData imageData, int n, Object object) {
            if ((n & 1) != 0) {
                softReference = livingImage.reference;
            }
            if ((n & 2) != 0) {
                imageData = livingImage.data;
            }
            return livingImage.copy(softReference, imageData);
        }

        @NotNull
        public String toString() {
            return "LivingImage(reference=" + this.reference + ", data=" + this.data + ")";
        }

        public int hashCode() {
            SoftReference<Image> softReference = this.reference;
            ImageData imageData = this.data;
            return (softReference != null ? softReference.hashCode() : 0) * 31 + (imageData != null ? imageData.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LivingImage)) break block3;
                    LivingImage livingImage = (LivingImage)object;
                    if (!Intrinsics.areEqual(this.reference, livingImage.reference) || !Intrinsics.areEqual((Object)this.data, (Object)livingImage.data)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/projector/server/service/ProjectorImageCacher$IdentityImageId;", "", "identityHash", "", "stateHash", "(II)V", "getIdentityHash", "()I", "getStateHash", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "projector-server"})
    private static final class IdentityImageId {
        private final int identityHash;
        private final int stateHash;

        public final int getIdentityHash() {
            return this.identityHash;
        }

        public final int getStateHash() {
            return this.stateHash;
        }

        public IdentityImageId(int identityHash, int stateHash) {
            this.identityHash = identityHash;
            this.stateHash = stateHash;
        }

        public final int component1() {
            return this.identityHash;
        }

        public final int component2() {
            return this.stateHash;
        }

        @NotNull
        public final IdentityImageId copy(int identityHash, int stateHash) {
            return new IdentityImageId(identityHash, stateHash);
        }

        public static /* synthetic */ IdentityImageId copy$default(IdentityImageId identityImageId, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = identityImageId.identityHash;
            }
            if ((n3 & 2) != 0) {
                n2 = identityImageId.stateHash;
            }
            return identityImageId.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "IdentityImageId(identityHash=" + this.identityHash + ", stateHash=" + this.stateHash + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.identityHash) * 31 + Integer.hashCode(this.stateHash);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IdentityImageId)) break block3;
                    IdentityImageId identityImageId = (IdentityImageId)object;
                    if (this.identityHash != identityImageId.identityHash || this.stateHash != identityImageId.stateHash) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

