/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Popup;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.data.AwtImageInfo;
import org.jetbrains.projector.awt.data.AwtPaintType;
import org.jetbrains.projector.awt.data.Direction;
import org.jetbrains.projector.common.protocol.data.AlphaCompositeRule;
import org.jetbrains.projector.common.protocol.data.CommonAlphaComposite;
import org.jetbrains.projector.common.protocol.data.CommonComposite;
import org.jetbrains.projector.common.protocol.data.CommonIntSize;
import org.jetbrains.projector.common.protocol.data.CommonPath;
import org.jetbrains.projector.common.protocol.data.CommonRectangle;
import org.jetbrains.projector.common.protocol.data.CommonShape;
import org.jetbrains.projector.common.protocol.data.CursorType;
import org.jetbrains.projector.common.protocol.data.ImageEventInfo;
import org.jetbrains.projector.common.protocol.data.PaintType;
import org.jetbrains.projector.common.protocol.data.PaintValue;
import org.jetbrains.projector.common.protocol.data.PathSegment;
import org.jetbrains.projector.common.protocol.data.Point;
import org.jetbrains.projector.common.protocol.data.StrokeData;
import org.jetbrains.projector.common.protocol.data.UnknownComposite;
import org.jetbrains.projector.common.protocol.toClient.ServerSetClipEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetStrokeEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetUnknownStrokeEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowStateEvent;
import org.jetbrains.projector.common.protocol.toClient.WindowType;
import org.jetbrains.projector.common.protocol.toServer.ResizeDirection;
import org.jetbrains.projector.server.util.ConvertKt$WhenMappings;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u00b2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0013\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\n\u001a\n\u0010\u001f\u001a\u00020 *\u00020!\u001a\n\u0010\"\u001a\u00020#*\u00020$\u001a\n\u0010%\u001a\u00020&*\u00020'\u001a\n\u0010(\u001a\u00020)*\u00020*\u001a\n\u0010+\u001a\u00020,*\u00020-\u001a\n\u0010.\u001a\u00020/*\u000200\u001a\n\u00101\u001a\u000202*\u000203\u001a\n\u00104\u001a\u00020\b*\u000205\u001a\n\u00106\u001a\u000205*\u000207\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00068"}, d2={"logger", "Lorg/jetbrains/projector/util/logging/Logger;", "windowType", "Lorg/jetbrains/projector/common/protocol/toClient/WindowType;", "Lorg/jetbrains/projector/awt/PWindow;", "getWindowType", "(Lorg/jetbrains/projector/awt/PWindow;)Lorg/jetbrains/projector/common/protocol/toClient/WindowType;", "createSetClipEvent", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowStateEvent;", "identitySpaceClip", "Ljava/awt/Shape;", "roundToInfinity", "", "x", "toBasicStrokeData", "Lorg/jetbrains/projector/common/protocol/data/StrokeData$Basic;", "Ljava/awt/BasicStroke;", "toColor", "Ljava/awt/Color;", "", "toCommonAlphaComposite", "Lorg/jetbrains/projector/common/protocol/data/CommonAlphaComposite;", "Ljava/awt/AlphaComposite;", "toCommonComposite", "Lorg/jetbrains/projector/common/protocol/data/CommonComposite;", "Ljava/awt/Composite;", "toCommonIntSize", "Lorg/jetbrains/projector/common/protocol/data/CommonIntSize;", "Ljava/awt/Dimension;", "toCommonPath", "Lorg/jetbrains/projector/common/protocol/data/CommonPath;", "toCommonRectangle", "Lorg/jetbrains/projector/common/protocol/data/CommonRectangle;", "Ljava/awt/Rectangle;", "toCursorType", "Lorg/jetbrains/projector/common/protocol/data/CursorType;", "", "toDirection", "Lorg/jetbrains/projector/awt/data/Direction;", "Lorg/jetbrains/projector/common/protocol/toServer/ResizeDirection;", "toImageEventInfo", "Lorg/jetbrains/projector/common/protocol/data/ImageEventInfo;", "Lorg/jetbrains/projector/awt/data/AwtImageInfo;", "toPaintType", "Lorg/jetbrains/projector/common/protocol/data/PaintType;", "Lorg/jetbrains/projector/awt/data/AwtPaintType;", "toPaintValue", "Lorg/jetbrains/projector/common/protocol/data/PaintValue;", "Ljava/awt/Paint;", "toPoint", "Lorg/jetbrains/projector/common/protocol/data/Point;", "Ljava/awt/geom/Point2D;", "toSetStrokeEvent", "Ljava/awt/Stroke;", "toStroke", "Lorg/jetbrains/projector/common/protocol/data/StrokeData;", "projector-server"})
public final class ConvertKt {
    private static final Logger logger = LoggerKt.Logger((String)"ConvertKt");

    @NotNull
    public static final Point toPoint(@NotNull Point2D $this$toPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$toPoint, (String)"$this$toPoint");
        return new Point($this$toPoint.getX(), $this$toPoint.getY());
    }

    @NotNull
    public static final CommonIntSize toCommonIntSize(@NotNull Dimension $this$toCommonIntSize) {
        Intrinsics.checkNotNullParameter((Object)$this$toCommonIntSize, (String)"$this$toCommonIntSize");
        return new CommonIntSize($this$toCommonIntSize.width, $this$toCommonIntSize.height);
    }

    @NotNull
    public static final CommonRectangle toCommonRectangle(@NotNull Rectangle $this$toCommonRectangle) {
        Intrinsics.checkNotNullParameter((Object)$this$toCommonRectangle, (String)"$this$toCommonRectangle");
        return new CommonRectangle((double)$this$toCommonRectangle.x, (double)$this$toCommonRectangle.y, (double)$this$toCommonRectangle.width, (double)$this$toCommonRectangle.height);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CommonPath toCommonPath(@NotNull Shape $this$toCommonPath) {
        CommonPath.WindingType windingType;
        void windingRule;
        int pathSegmentType;
        Intrinsics.checkNotNullParameter((Object)$this$toCommonPath, (String)"$this$toCommonPath");
        boolean bl = false;
        List segments = new ArrayList();
        PathIterator pi = $this$toCommonPath.getPathIterator(null);
        while (true) {
            PathSegment pathSegment;
            void $this$mapTo$iv$iv;
            PathIterator pathIterator = pi;
            Intrinsics.checkNotNullExpressionValue((Object)pathIterator, (String)"pi");
            if (pathIterator.isDone()) break;
            double[] coordinates = new double[6];
            pathSegmentType = pi.currentSegment(coordinates);
            Iterable $this$map$iv = CollectionsKt.chunked((Iterable)ArraysKt.asList((double[])coordinates), (int)2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                void $dstr$x$y;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var15_16 = $dstr$x$y;
                boolean bl3 = false;
                double d = ((Number)var15_16.get(0)).doubleValue();
                var15_16 = $dstr$x$y;
                bl3 = false;
                double y = ((Number)var15_16.get(1)).doubleValue();
                Point point = new Point((double)x, y);
                collection.add(point);
            }
            List points = (List)destination$iv$iv;
            switch (pathSegmentType) {
                case 0: {
                    pathSegment = (PathSegment)new PathSegment.MoveTo((Point)points.get(0));
                    break;
                }
                case 1: {
                    pathSegment = (PathSegment)new PathSegment.LineTo((Point)points.get(0));
                    break;
                }
                case 2: {
                    pathSegment = (PathSegment)new PathSegment.QuadTo((Point)points.get(0), (Point)points.get(1));
                    break;
                }
                case 3: {
                    pathSegment = (PathSegment)new PathSegment.CubicTo((Point)points.get(0), (Point)points.get(1), (Point)points.get(2));
                    break;
                }
                case 4: {
                    pathSegment = (PathSegment)PathSegment.Close.INSTANCE;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unsupported path segment type: " + pathSegmentType);
                }
            }
            PathSegment segment = pathSegment;
            segments.add(segment);
            pi.next();
        }
        pathSegmentType = pi.getWindingRule();
        switch (windingRule) {
            case 0: {
                windingType = CommonPath.WindingType.EVEN_ODD;
                break;
            }
            case 1: {
                windingType = CommonPath.WindingType.NON_ZERO;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported winding rule: " + (int)windingRule);
            }
        }
        CommonPath.WindingType windingType2 = windingType;
        return new CommonPath(segments, windingType2);
    }

    @NotNull
    public static final Color toColor(@NotNull Number $this$toColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toColor, (String)"$this$toColor");
        return new Color($this$toColor.intValue(), true);
    }

    @NotNull
    public static final Stroke toStroke(@NotNull StrokeData $this$toStroke) {
        Intrinsics.checkNotNullParameter((Object)$this$toStroke, (String)"$this$toStroke");
        StrokeData strokeData = $this$toStroke;
        if (strokeData instanceof StrokeData.Basic) {
            int n;
            int n2;
            switch (ConvertKt$WhenMappings.$EnumSwitchMapping$0[((StrokeData.Basic)$this$toStroke).getEndCap().ordinal()]) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int cap = n2;
            switch (ConvertKt$WhenMappings.$EnumSwitchMapping$1[((StrokeData.Basic)$this$toStroke).getLineJoin().ordinal()]) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int join = n;
            List list = ((StrokeData.Basic)$this$toStroke).getDashArray();
            return new BasicStroke(((StrokeData.Basic)$this$toStroke).getLineWidth(), cap, join, ((StrokeData.Basic)$this$toStroke).getMiterLimit(), (float[])(list != null ? CollectionsKt.toFloatArray((Collection)list) : null), ((StrokeData.Basic)$this$toStroke).getDashPhase());
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final StrokeData.Basic toBasicStrokeData(@NotNull BasicStroke $this$toBasicStrokeData) {
        StrokeData.Basic.JoinType joinType;
        StrokeData.Basic.CapType capType;
        Intrinsics.checkNotNullParameter((Object)$this$toBasicStrokeData, (String)"$this$toBasicStrokeData");
        int cap = $this$toBasicStrokeData.getEndCap();
        switch (cap) {
            case 0: {
                capType = StrokeData.Basic.CapType.BUTT;
                break;
            }
            case 2: {
                capType = StrokeData.Basic.CapType.SQUARE;
                break;
            }
            case 1: {
                capType = StrokeData.Basic.CapType.ROUND;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Bad s.endCap: " + cap);
            }
        }
        StrokeData.Basic.CapType cap2 = capType;
        int join = $this$toBasicStrokeData.getLineJoin();
        switch (join) {
            case 0: {
                joinType = StrokeData.Basic.JoinType.MITER;
                break;
            }
            case 2: {
                joinType = StrokeData.Basic.JoinType.BEVEL;
                break;
            }
            case 1: {
                joinType = StrokeData.Basic.JoinType.ROUND;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Bad s.lineJoin: " + join);
            }
        }
        StrokeData.Basic.JoinType join2 = joinType;
        float[] fArray = $this$toBasicStrokeData.getDashArray();
        return new StrokeData.Basic($this$toBasicStrokeData.getLineWidth(), join2, cap2, $this$toBasicStrokeData.getMiterLimit(), $this$toBasicStrokeData.getDashPhase(), fArray != null ? ArraysKt.toList((float[])fArray) : null);
    }

    @NotNull
    public static final CursorType toCursorType(int $this$toCursorType) {
        CursorType cursorType;
        switch ($this$toCursorType) {
            case 0: {
                cursorType = CursorType.DEFAULT;
                break;
            }
            case 1: {
                cursorType = CursorType.CROSSHAIR;
                break;
            }
            case 2: {
                cursorType = CursorType.TEXT;
                break;
            }
            case 3: {
                cursorType = CursorType.WAIT;
                break;
            }
            case 4: {
                cursorType = CursorType.SW_RESIZE;
                break;
            }
            case 5: {
                cursorType = CursorType.SE_RESIZE;
                break;
            }
            case 6: {
                cursorType = CursorType.NW_RESIZE;
                break;
            }
            case 7: {
                cursorType = CursorType.NE_RESIZE;
                break;
            }
            case 8: {
                cursorType = CursorType.N_RESIZE;
                break;
            }
            case 9: {
                cursorType = CursorType.S_RESIZE;
                break;
            }
            case 10: {
                cursorType = CursorType.W_RESIZE;
                break;
            }
            case 11: {
                cursorType = CursorType.E_RESIZE;
                break;
            }
            case 12: {
                cursorType = CursorType.HAND;
                break;
            }
            case 13: {
                cursorType = CursorType.MOVE;
                break;
            }
            default: {
                Logger.DefaultImpls.error$default((Logger)logger, null, (Function0)((Function0)new Function0<String>($this$toCursorType){
                    final /* synthetic */ int $this_toCursorType;

                    @NotNull
                    public final String invoke() {
                        return "Int.toCursorType(): Bad cursor id: " + this.$this_toCursorType + ". Returning default.";
                    }
                    {
                        this.$this_toCursorType = n;
                        super(0);
                    }
                }), (int)1, null);
                cursorType = CursorType.DEFAULT;
            }
        }
        return cursorType;
    }

    @NotNull
    public static final PaintValue toPaintValue(@NotNull Paint $this$toPaintValue) {
        PaintValue paintValue;
        Intrinsics.checkNotNullParameter((Object)$this$toPaintValue, (String)"$this$toPaintValue");
        Paint paint = $this$toPaintValue;
        if (paint instanceof Color) {
            paintValue = (PaintValue)new PaintValue.Color(((Color)$this$toPaintValue).getRGB());
        } else if (paint instanceof GradientPaint) {
            Point2D point2D = ((GradientPaint)$this$toPaintValue).getPoint1();
            Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"point1");
            Point point = ConvertKt.toPoint(point2D);
            Point2D point2D2 = ((GradientPaint)$this$toPaintValue).getPoint2();
            Intrinsics.checkNotNullExpressionValue((Object)point2D2, (String)"point2");
            Point point2 = ConvertKt.toPoint(point2D2);
            Color color = ((GradientPaint)$this$toPaintValue).getColor1();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color1");
            int n = color.getRGB();
            Color color2 = ((GradientPaint)$this$toPaintValue).getColor2();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"color2");
            paintValue = (PaintValue)new PaintValue.Gradient(point, point2, n, color2.getRGB());
        } else {
            paintValue = paint instanceof MultipleGradientPaint ? (PaintValue)new PaintValue.Unknown("MultipleGradientPaint, maybe split to Linear and Radial") : (paint instanceof TexturePaint ? (PaintValue)new PaintValue.Unknown("TexturePaint") : (PaintValue)new PaintValue.Unknown(String.valueOf(Reflection.getOrCreateKotlinClass($this$toPaintValue.getClass()).getQualifiedName())));
        }
        return paintValue;
    }

    @NotNull
    public static final ServerWindowStateEvent createSetClipEvent(@Nullable Shape identitySpaceClip) {
        boolean bl = false;
        boolean bl2 = false;
        Shape $this$with = identitySpaceClip;
        boolean bl3 = false;
        Shape shape = $this$with;
        CommonShape commonShape = shape == null ? null : (shape instanceof Rectangle2D ? (CommonShape)new CommonRectangle(((Rectangle2D)$this$with).getX(), ((Rectangle2D)$this$with).getY(), ((Rectangle2D)$this$with).getWidth(), ((Rectangle2D)$this$with).getHeight()) : (CommonShape)ConvertKt.toCommonPath($this$with));
        CommonShape commonShape2 = commonShape;
        return (ServerWindowStateEvent)new ServerSetClipEvent(commonShape2);
    }

    @NotNull
    public static final ServerWindowStateEvent toSetStrokeEvent(@NotNull Stroke $this$toSetStrokeEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$toSetStrokeEvent, (String)"$this$toSetStrokeEvent");
        Stroke stroke = $this$toSetStrokeEvent;
        return stroke instanceof BasicStroke ? (ServerWindowStateEvent)new ServerSetStrokeEvent((StrokeData)ConvertKt.toBasicStrokeData((BasicStroke)$this$toSetStrokeEvent)) : (ServerWindowStateEvent)new ServerSetUnknownStrokeEvent(String.valueOf(Reflection.getOrCreateKotlinClass($this$toSetStrokeEvent.getClass()).getQualifiedName()));
    }

    private static final CommonAlphaComposite toCommonAlphaComposite(AlphaComposite $this$toCommonAlphaComposite) {
        AlphaCompositeRule alphaCompositeRule;
        switch ($this$toCommonAlphaComposite.getRule()) {
            case 3: {
                alphaCompositeRule = AlphaCompositeRule.SRC_OVER;
                break;
            }
            case 4: {
                alphaCompositeRule = AlphaCompositeRule.DST_OVER;
                break;
            }
            case 5: {
                alphaCompositeRule = AlphaCompositeRule.SRC_IN;
                break;
            }
            case 1: {
                alphaCompositeRule = AlphaCompositeRule.CLEAR;
                break;
            }
            case 2: {
                alphaCompositeRule = AlphaCompositeRule.SRC;
                break;
            }
            case 9: {
                alphaCompositeRule = AlphaCompositeRule.DST;
                break;
            }
            case 6: {
                alphaCompositeRule = AlphaCompositeRule.DST_IN;
                break;
            }
            case 7: {
                alphaCompositeRule = AlphaCompositeRule.SRC_OUT;
                break;
            }
            case 8: {
                alphaCompositeRule = AlphaCompositeRule.DST_OUT;
                break;
            }
            case 10: {
                alphaCompositeRule = AlphaCompositeRule.SRC_ATOP;
                break;
            }
            case 11: {
                alphaCompositeRule = AlphaCompositeRule.DST_ATOP;
                break;
            }
            case 12: {
                alphaCompositeRule = AlphaCompositeRule.XOR;
                break;
            }
            default: {
                Logger.DefaultImpls.error$default((Logger)logger, null, (Function0)((Function0)new Function0<String>($this$toCommonAlphaComposite){
                    final /* synthetic */ AlphaComposite $this_toCommonAlphaComposite;

                    @NotNull
                    public final String invoke() {
                        return "AlphaComposite.toCommonAlphaComposite: Bad alpha composite rule: " + this.$this_toCommonAlphaComposite.getRule() + ". Returning SRC_OVER.";
                    }
                    {
                        this.$this_toCommonAlphaComposite = alphaComposite;
                        super(0);
                    }
                }), (int)1, null);
                alphaCompositeRule = AlphaCompositeRule.SRC_OVER;
            }
        }
        AlphaCompositeRule acRule2 = alphaCompositeRule;
        return new CommonAlphaComposite(acRule2, $this$toCommonAlphaComposite.getAlpha());
    }

    @NotNull
    public static final CommonComposite toCommonComposite(@NotNull Composite $this$toCommonComposite) {
        Intrinsics.checkNotNullParameter((Object)$this$toCommonComposite, (String)"$this$toCommonComposite");
        Composite composite = $this$toCommonComposite;
        return composite instanceof AlphaComposite ? (CommonComposite)ConvertKt.toCommonAlphaComposite((AlphaComposite)$this$toCommonComposite) : (CommonComposite)new UnknownComposite("Unknown composite class: " + $this$toCommonComposite.getClass().getCanonicalName());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final double roundToInfinity(double x) {
        double d;
        block5: {
            block4: {
                double d2 = x;
                boolean bl = false;
                if (Double.isNaN(d2)) break block4;
                d2 = x;
                bl = false;
                if (!Double.isInfinite(d2)) break block5;
            }
            d = x;
            return d;
        }
        if (x > 0.0) {
            boolean bl = false;
            d = Math.ceil(x);
            return d;
        }
        boolean bl = false;
        d = Math.floor(x);
        return d;
    }

    @NotNull
    public static final PaintType toPaintType(@NotNull AwtPaintType $this$toPaintType) {
        PaintType paintType;
        Intrinsics.checkNotNullParameter((Object)$this$toPaintType, (String)"$this$toPaintType");
        switch (ConvertKt$WhenMappings.$EnumSwitchMapping$2[$this$toPaintType.ordinal()]) {
            case 1: {
                paintType = PaintType.DRAW;
                break;
            }
            case 2: {
                paintType = PaintType.FILL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return paintType;
    }

    @NotNull
    public static final ImageEventInfo toImageEventInfo(@NotNull AwtImageInfo $this$toImageEventInfo) {
        ImageEventInfo imageEventInfo;
        Intrinsics.checkNotNullParameter((Object)$this$toImageEventInfo, (String)"$this$toImageEventInfo");
        AwtImageInfo awtImageInfo = $this$toImageEventInfo;
        if (awtImageInfo instanceof AwtImageInfo.Point) {
            imageEventInfo = (ImageEventInfo)new ImageEventInfo.Xy(((AwtImageInfo.Point)$this$toImageEventInfo).getX(), ((AwtImageInfo.Point)$this$toImageEventInfo).getY(), null, 4, null);
        } else if (awtImageInfo instanceof AwtImageInfo.Rectangle) {
            imageEventInfo = (ImageEventInfo)new ImageEventInfo.XyWh(((AwtImageInfo.Rectangle)$this$toImageEventInfo).getX(), ((AwtImageInfo.Rectangle)$this$toImageEventInfo).getY(), ((AwtImageInfo.Rectangle)$this$toImageEventInfo).getWidth(), ((AwtImageInfo.Rectangle)$this$toImageEventInfo).getHeight(), ((AwtImageInfo.Rectangle)$this$toImageEventInfo).getArgbBackgroundColor());
        } else if (awtImageInfo instanceof AwtImageInfo.Area) {
            imageEventInfo = (ImageEventInfo)new ImageEventInfo.Ds(((AwtImageInfo.Area)$this$toImageEventInfo).getDx1(), ((AwtImageInfo.Area)$this$toImageEventInfo).getDy1(), ((AwtImageInfo.Area)$this$toImageEventInfo).getDx2(), ((AwtImageInfo.Area)$this$toImageEventInfo).getDy2(), ((AwtImageInfo.Area)$this$toImageEventInfo).getSx1(), ((AwtImageInfo.Area)$this$toImageEventInfo).getSy1(), ((AwtImageInfo.Area)$this$toImageEventInfo).getSx2(), ((AwtImageInfo.Area)$this$toImageEventInfo).getSy2(), ((AwtImageInfo.Area)$this$toImageEventInfo).getArgbBackgroundColor());
        } else if (awtImageInfo instanceof AwtImageInfo.Transformation) {
            imageEventInfo = (ImageEventInfo)new ImageEventInfo.Transformed(((AwtImageInfo.Transformation)$this$toImageEventInfo).getTx());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return imageEventInfo;
    }

    @NotNull
    public static final WindowType getWindowType(@NotNull PWindow $this$windowType) {
        Intrinsics.checkNotNullParameter((Object)$this$windowType, (String)"$this$windowType");
        String string = $this$windowType.getTarget().getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target::class.java.simpleName");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"IdeFrameImpl", (boolean)false, (int)2, null) ? WindowType.IDEA_WINDOW : ($this$windowType.getTarget() instanceof Popup ? WindowType.POPUP : WindowType.WINDOW);
    }

    @NotNull
    public static final Direction toDirection(@NotNull ResizeDirection $this$toDirection) {
        Direction direction;
        Intrinsics.checkNotNullParameter((Object)$this$toDirection, (String)"$this$toDirection");
        switch (ConvertKt$WhenMappings.$EnumSwitchMapping$3[$this$toDirection.ordinal()]) {
            case 1: {
                direction = Direction.NW;
                break;
            }
            case 2: {
                direction = Direction.SW;
                break;
            }
            case 3: {
                direction = Direction.NE;
                break;
            }
            case 4: {
                direction = Direction.SE;
                break;
            }
            case 5: {
                direction = Direction.N;
                break;
            }
            case 6: {
                direction = Direction.W;
                break;
            }
            case 7: {
                direction = Direction.S;
                break;
            }
            case 8: {
                direction = Direction.E;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return direction;
    }
}

