# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['nox_poetry']

package_data = \
{'': ['*']}

install_requires = \
['nox>=2020.8.22', 'packaging>=20.9', 'tomlkit>=0.7.0,<0.8.0']

setup_kwargs = {
    'name': 'nox-poetry',
    'version': '0.8.6',
    'description': 'nox-poetry',
    'long_description': 'nox-poetry\n==========\n\n|Status| |PyPI| |Python Version| |License|\n\n|Read the Docs| |Tests| |Codecov|\n\n|pre-commit| |Black|\n\n.. |Status| image:: https://badgen.net/badge/status/alpha/d8624d\n   :target: https://badgen.net/badge/status/alpha/d8624d\n   :alt: Project Status\n.. |PyPI| image:: https://img.shields.io/pypi/v/nox-poetry.svg\n   :target: https://pypi.org/project/nox-poetry/\n   :alt: PyPI\n.. |Python Version| image:: https://img.shields.io/pypi/pyversions/nox-poetry\n   :target: https://pypi.org/project/nox-poetry\n   :alt: Python Version\n.. |License| image:: https://img.shields.io/pypi/l/nox-poetry\n   :target: https://opensource.org/licenses/MIT\n   :alt: License\n.. |Read the Docs| image:: https://img.shields.io/readthedocs/nox-poetry/latest.svg?label=Read%20the%20Docs\n   :target: https://nox-poetry.readthedocs.io/\n   :alt: Read the documentation at https://nox-poetry.readthedocs.io/\n.. |Tests| image:: https://github.com/cjolowicz/nox-poetry/workflows/Tests/badge.svg\n   :target: https://github.com/cjolowicz/nox-poetry/actions?workflow=Tests\n   :alt: Tests\n.. |Codecov| image:: https://codecov.io/gh/cjolowicz/nox-poetry/branch/main/graph/badge.svg\n   :target: https://codecov.io/gh/cjolowicz/nox-poetry\n   :alt: Codecov\n.. |pre-commit| image:: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white\n   :target: https://github.com/pre-commit/pre-commit\n   :alt: pre-commit\n.. |Black| image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/psf/black\n   :alt: Black\n\n\nUse Poetry_ inside Nox_ sessions\n\nThis package provides a drop-in replacement for the ``nox.session`` decorator,\nand for the ``nox.Session`` object passed to user-defined session functions.\nThis enables ``session.install`` to install packages at the versions specified in the Poetry lock file.\n\n.. code:: python\n\n    from nox_poetry import session\n\n    @session(python=["3.8", "3.9"])\n    def tests(session):\n        session.install("pytest", ".")\n        session.run("pytest")\n\n\n**Disclaimer:** *This project is not affiliated with Nox, and not an official Nox plugin.*\n\n\nInstallation\n------------\n\nInstall ``nox-poetry`` from the Python Package Index:\n\n.. code:: console\n\n   $ pip install nox-poetry\n\n\n**Important:**\nThis package must be installed into the same environment that Nox is run from.\nIf you installed Nox using pipx_,\nuse the following command to install this package into the same environment:\n\n.. code:: console\n\n   $ pipx inject nox nox-poetry\n\n\nUsage\n-----\n\nImport the ``@session`` decorator from ``nox_poetry`` instead of ``nox``.\nThere is nothing else you need to do.\nThe ``session.install`` method automatically honors the Poetry lock file when installing dependencies.\nThis allows you to manage packages used in Nox sessions as development dependencies in Poetry.\n\nThis works because session functions are passed instances of ``nox_poetry.Session``,\na proxy for ``nox.Session`` adding Poetry-related functionality.\nBehind the scenes, nox-poetry uses Poetry to export a `constraints file`_ and build the package.\n\nFor more fine-grained control, additional utilities are available under the ``session.poetry`` attribute:\n\n- ``session.poetry.installroot(distribution_format=[WHEEL|SDIST])``\n- ``session.poetry.build_package(distribution_format=[WHEEL|SDIST])``\n- ``session.poetry.export_requirements()``\n\n\nWhy?\n----\n\nThe example session above performs the following steps:\n\n- Build a wheel from the local package.\n- Install the wheel as well as the ``pytest`` package.\n- Invoke ``pytest`` to run the test suite against the installation.\n\nConsider what would happen in this session\nif we had imported ``@session`` from ``nox`` instead of ``nox_poetry``:\n\n- Package dependencies would only be constrained by the wheel metadata, not by the lock file.\n  In other words, their versions would not be *pinned*.\n- The ``pytest`` dependency would not be constrained at all.\n- Poetry would be installed as a build backend every time.\n\nUnpinned dependencies mean that your checks are not reproducible and deterministic,\nwhich can lead to surprises in Continuous Integration and when collaborating with others.\nYou can solve these issues by declaring ``pytest`` as a development dependency,\nand installing your package and its dependencies using ``poetry install``:\n\n.. code:: python\n\n   @nox.session\n   def tests(session: Session) -> None:\n       """Run the test suite."""\n       session.run("poetry", "install", external=True)\n       session.run("pytest")\n\nUnfortunately, this approach comes with its own set of problems:\n\n- Checks run against an editable installation of your package,\n  i.e. your local copy of the code, instead of the installed wheel your users see.\n  In the best case, any mistakes will still be caught during Continuous Integration.\n  In the worst case, you publish a buggy release because you forgot to commit some changes.\n- The package is installed, as well as all of its core and development dependencies,\n  no matter which tools a session actually runs.\n  Code formatters or linters, for example, don\'t need your package installed at all.\n  Besides being wasteful, it goes against the idea of running checks in isolated environments.\n\n``nox-poetry`` uses a third approach:\n\n- Installations are performed by pip, via the ``session.install`` method.\n- When installing your own package, Poetry is used to build a wheel, which is passed to pip.\n- When installing third-party packages, Poetry is used to export a `constraints file`_,\n  which is passed to pip along with the packages.\n  The constraints file ensures that package versions are pinned by the lock file,\n  without forcing an installation of every listed dependency and sub-dependency.\n\nIn summary, this approach brings the following advantages:\n\n- You can manage tools like ``pytest`` as development dependencies in Poetry.\n- Dependencies are pinned by Poetry\'s lock file, making checks predictable and deterministic.\n- You can run checks against an installed wheel, instead of your local copy of the code.\n- Every tool can run in an isolated environment with minimal dependencies.\n- No need to install your package with all its dependencies if all you need is some linter.\n\n\nContributing\n------------\n\nContributions are very welcome.\nTo learn more, see the `Contributor Guide`_.\n\n\nLicense\n-------\n\n``nox-poetry`` is free and open source software,\ndistributed under the terms of the `MIT license`_.\n\n\nIssues\n------\n\nIf you encounter any problems,\nplease `file an issue`_ along with a detailed description.\n\n\nCredits\n-------\n\nThis project was generated from `@cjolowicz`_\'s `Hypermodern Python Cookiecutter`_ template.\n\n.. _@cjolowicz: https://github.com/cjolowicz\n.. _Cookiecutter: https://github.com/audreyr/cookiecutter\n.. _MIT license: https://opensource.org/licenses/MIT\n.. _Hypermodern Python Cookiecutter: https://github.com/cjolowicz/cookiecutter-hypermodern-python\n.. _MIT: http://opensource.org/licenses/MIT\n.. _Nox: https://nox.thea.codes/\n.. _Poetry: https://python-poetry.org/\n.. _constraints file: https://pip.pypa.io/en/stable/user_guide/#constraints-files\n.. _file an issue: https://github.com/cjolowicz/nox-poetry/issues\n.. _nox.sessions.Session.install: https://nox.thea.codes/en/stable/config.html#nox.sessions.Session.install\n.. _nox.sessions.Session.run: https://nox.thea.codes/en/stable/config.html#nox.sessions.Session.run\n.. _pip install: https://pip.pypa.io/en/stable/reference/pip_install/\n.. _pip: https://pip.pypa.io/\n.. _pipx: https://pipxproject.github.io/pipx/\n.. github-only\n.. _Contributor Guide: CONTRIBUTING.rst\n',
    'author': 'Claudio Jolowicz',
    'author_email': 'mail@claudiojolowicz.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cjolowicz/nox-poetry',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
