# Generated by Django 3.2.4 on 2021-11-26 07:01

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("book", "0012_remove_user_accessrights"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="RepoInfo",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "content",
                    models.JSONField(blank=True, default=list, null=True),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="BookRepository",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("repo_id", models.IntegerField()),
                ("repo_name", models.CharField(max_length=256)),
                (
                    "repo_type",
                    models.CharField(
                        choices=[("github", "GitHub"), ("gitlab", "GitLab")],
                        max_length=6,
                    ),
                ),
                ("export_epub", models.BooleanField()),
                ("export_unpacked_epub", models.BooleanField()),
                ("export_html", models.BooleanField()),
                ("export_unified_html", models.BooleanField()),
                ("export_latex", models.BooleanField()),
                (
                    "book",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="book.book",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Book repositories",
            },
        ),
    ]
