import cdk = require('@aws-cdk/core');
/**
 * Properties for defining a `AWS::Athena::NamedQuery`
 *
 * @stable
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html
 */
export interface CfnNamedQueryProps {
    /**
     * `AWS::Athena::NamedQuery.Database`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-database
     */
    readonly database: string;
    /**
     * `AWS::Athena::NamedQuery.QueryString`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-querystring
     */
    readonly queryString: string;
    /**
     * `AWS::Athena::NamedQuery.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-description
     */
    readonly description?: string;
    /**
     * `AWS::Athena::NamedQuery.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-name
     */
    readonly name?: string;
}
/**
 * A CloudFormation `AWS::Athena::NamedQuery`
 *
 * @cloudformationResource AWS::Athena::NamedQuery
 * @stable
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html
 */
export declare class CfnNamedQuery extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Athena::NamedQuery";
    /**
     * `AWS::Athena::NamedQuery.Database`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-database
     */
    database: string;
    /**
     * `AWS::Athena::NamedQuery.QueryString`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-querystring
     */
    queryString: string;
    /**
     * `AWS::Athena::NamedQuery.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-description
     */
    description: string | undefined;
    /**
     * `AWS::Athena::NamedQuery.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-athena-namedquery.html#cfn-athena-namedquery-name
     */
    name: string | undefined;
    /**
     * Create a new `AWS::Athena::NamedQuery`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNamedQueryProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
