# COPYRIGHT 2020 by Pietro Mandracci

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

""" Physical constants used in this package.

    This module contains physical constants required for use in the package
        
    Documentation is also available in the docstrings.
"""

# +--------------------+
# | Physical constants |
# +--------------------+

K_BOLTZMANN             = 1.3806503E-23         # / J*K**-1
EPSILONZERO             = 8.854187818E-12       # / F*m**-1
ELECTRON_CHARGE         = -1.602176E-19         # / C
ELECTRON_MASS           = 9.109382E-31          # / kg
ATOMIC_UNIT_MASS        = 1.66054E-27           # / kg
ZERO_CELSIUS            = 273.15                # / K           
ATM_PRESSURE_PA         = 1.0133E5              # / Pa          atmospheric pressure in pascal
ATM_PRESSURE_TORR       = 760.0                 # / torr        atmospheric pressure in Torr
ATM_PRESSURE_PSI        = 14.696                # / psi         atmospheric pressure in psi
