Contribution guidelines
=======================

Thanks for your interest in contributing to this project! Please keep the following guidelines in mind when contributing to the project.

* Follow the [PEP 8](https://www.python.org/dev/peps/pep-0008/) style guide.
  * It is recommended that you use an automated linter. For example, you can use [flake8](http://flake8.pycqa.org/en/latest/).
* Add tests for any new features you add, *especially* if those features are meant for developers using this library.
  * You don't need to implement a test for every single line of code, but please maintain good test coverage.
* If you add new classes and features meant for people using the library, write relevant documentation using [Sphinx](http://www.sphinx-doc.org/en/master/).
  * Ensure that the documentation is up-to-date. Outdated documentation is worse than no documentation at all!
* Ensure your contributions pass the test suite.
* Focus on one issue per pull request.
  * That means if you want to add new features, add one new feature per pull request. This makes reviewing and merging new features easier.
  * If you have multiple small improvements to contribute, you should add them into a single pull request instead.
  * Use your best judgement if you're unsure.
