"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .documentupdate import DocumentUpdate, DocumentUpdateTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mixpeek.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


RequestBodyTypedDict = TypeAliasType(
    "RequestBodyTypedDict", Union[DocumentUpdateTypedDict, str]
)


RequestBody = TypeAliasType("RequestBody", Union[DocumentUpdate, str])


class BatchUpdateDocumentsV1CollectionsCollectionIdentifierDocumentsBatchPutRequestTypedDict(
    TypedDict
):
    collection_identifier: str
    r"""The ID of the collection"""
    x_namespace: NotRequired[Nullable[str]]
    r"""Optional namespace for data isolation. This can be a namespace name or namespace ID. Example: 'netflix_prod' or 'ns_1234567890'. To create a namespace, use the /namespaces endpoint."""
    request_body: NotRequired[List[List[RequestBodyTypedDict]]]


class BatchUpdateDocumentsV1CollectionsCollectionIdentifierDocumentsBatchPutRequest(
    BaseModel
):
    collection_identifier: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""The ID of the collection"""

    x_namespace: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="X-Namespace"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = UNSET
    r"""Optional namespace for data isolation. This can be a namespace name or namespace ID. Example: 'netflix_prod' or 'ns_1234567890'. To create a namespace, use the /namespaces endpoint."""

    request_body: Annotated[
        Optional[List[List[RequestBody]]],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["X-Namespace", "RequestBody"]
        nullable_fields = ["X-Namespace"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
