"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class BlobDetailsTypedDict(TypedDict):
    r"""File details for a bucket object, these are automatically generated by the system"""

    filename: NotRequired[Nullable[str]]
    size_bytes: NotRequired[Nullable[int]]
    mime_type: NotRequired[Nullable[str]]
    hash: NotRequired[Nullable[str]]
    s3_object_key: NotRequired[Nullable[str]]


class BlobDetails(BaseModel):
    r"""File details for a bucket object, these are automatically generated by the system"""

    filename: OptionalNullable[str] = UNSET

    size_bytes: OptionalNullable[int] = UNSET

    mime_type: OptionalNullable[str] = UNSET

    hash: OptionalNullable[str] = UNSET

    s3_object_key: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "filename",
            "size_bytes",
            "mime_type",
            "hash",
            "s3_object_key",
        ]
        nullable_fields = [
            "filename",
            "size_bytes",
            "mime_type",
            "hash",
            "s3_object_key",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
