"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .blobdetails import BlobDetails, BlobDetailsTypedDict
from .bucketschemafieldtype import BucketSchemaFieldType
from .taskstatus import TaskStatus
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any, Optional
from typing_extensions import NotRequired, TypedDict


class BlobModelMetadataTypedDict(TypedDict):
    pass


class BlobModelMetadata(BaseModel):
    pass


class BlobModelTypedDict(TypedDict):
    r"""Model for a blob within a bucket object"""

    property: str
    r"""Property name of the blob"""
    type: BucketSchemaFieldType
    r"""Enum for field types in bucket schemas"""
    data: Any
    r"""Data for the blob"""
    blob_id: NotRequired[str]
    r"""Unique identifier for the blob"""
    key_prefix: NotRequired[Nullable[str]]
    r"""Storage key/path of the blob, this will be used to retrieve the blob from the storage. It is similar to a file path. If not provided, it will be placed in the root of the bucket."""
    metadata: NotRequired[Nullable[BlobModelMetadataTypedDict]]
    r"""Metadata for the blob, this will only be applied to the documents that use this blob"""
    details: NotRequired[BlobDetailsTypedDict]
    r"""File details for a bucket object, these are automatically generated by the system"""
    status: NotRequired[TaskStatus]
    error: NotRequired[Nullable[str]]
    r"""Error message if the blob failed to be ingested"""


class BlobModel(BaseModel):
    r"""Model for a blob within a bucket object"""

    property: str
    r"""Property name of the blob"""

    type: BucketSchemaFieldType
    r"""Enum for field types in bucket schemas"""

    data: Any
    r"""Data for the blob"""

    blob_id: Optional[str] = None
    r"""Unique identifier for the blob"""

    key_prefix: OptionalNullable[str] = UNSET
    r"""Storage key/path of the blob, this will be used to retrieve the blob from the storage. It is similar to a file path. If not provided, it will be placed in the root of the bucket."""

    metadata: OptionalNullable[BlobModelMetadata] = UNSET
    r"""Metadata for the blob, this will only be applied to the documents that use this blob"""

    details: Optional[BlobDetails] = None
    r"""File details for a bucket object, these are automatically generated by the system"""

    status: Optional[TaskStatus] = None

    error: OptionalNullable[str] = UNSET
    r"""Error message if the blob failed to be ingested"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "blob_id",
            "key_prefix",
            "metadata",
            "details",
            "status",
            "error",
        ]
        nullable_fields = ["key_prefix", "metadata", "error"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
