"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class MetadataTypedDict(TypedDict):
    pass


class Metadata(BaseModel):
    pass


class BucketUpdateRequestTypedDict(TypedDict):
    r"""Request model for updating an existing bucket"""

    bucket_name: NotRequired[Nullable[str]]
    r"""Human-readable name for the bucket"""
    description: NotRequired[Nullable[str]]
    r"""Description of the bucket"""
    metadata: NotRequired[Nullable[MetadataTypedDict]]
    r"""Additional metadata for the bucket"""


class BucketUpdateRequest(BaseModel):
    r"""Request model for updating an existing bucket"""

    bucket_name: OptionalNullable[str] = UNSET
    r"""Human-readable name for the bucket"""

    description: OptionalNullable[str] = UNSET
    r"""Description of the bucket"""

    metadata: OptionalNullable[Metadata] = UNSET
    r"""Additional metadata for the bucket"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["bucket_name", "description", "metadata"]
        nullable_fields = ["bucket_name", "description", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
