"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .invalidationevent import InvalidationEvent, InvalidationEventTypedDict
from .invalidationstrategy import InvalidationStrategy
from .retrievercacheconfig import RetrieverCacheConfig, RetrieverCacheConfigTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class CollectionCacheConfigInputTypedDict(TypedDict):
    r"""Configuration for collection-level caching"""

    enabled: NotRequired[bool]
    r"""Whether caching is enabled"""
    ttl_seconds: NotRequired[int]
    r"""Time-to-live for cache entries in seconds"""
    invalidation_strategy: NotRequired[InvalidationStrategy]
    r"""Strategies for cache invalidation"""
    max_entries_per_key: NotRequired[int]
    r"""Maximum number of results to cache per key"""
    score_threshold: NotRequired[Nullable[float]]
    r"""Minimum score threshold for caching results"""
    invalidation_events: NotRequired[List[InvalidationEventTypedDict]]
    r"""Events that trigger cache invalidation"""
    retriever_configs: NotRequired[Dict[str, RetrieverCacheConfigTypedDict]]
    r"""Retriever-specific cache configurations"""


class CollectionCacheConfigInput(BaseModel):
    r"""Configuration for collection-level caching"""

    enabled: Optional[bool] = True
    r"""Whether caching is enabled"""

    ttl_seconds: Optional[int] = 604800
    r"""Time-to-live for cache entries in seconds"""

    invalidation_strategy: Optional[InvalidationStrategy] = None
    r"""Strategies for cache invalidation"""

    max_entries_per_key: Optional[int] = 5
    r"""Maximum number of results to cache per key"""

    score_threshold: OptionalNullable[float] = UNSET
    r"""Minimum score threshold for caching results"""

    invalidation_events: Optional[List[InvalidationEvent]] = None
    r"""Events that trigger cache invalidation"""

    retriever_configs: Optional[Dict[str, RetrieverCacheConfig]] = None
    r"""Retriever-specific cache configurations"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "enabled",
            "ttl_seconds",
            "invalidation_strategy",
            "max_entries_per_key",
            "score_threshold",
            "invalidation_events",
            "retriever_configs",
        ]
        nullable_fields = ["score_threshold"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
