"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .bucketschema_output import BucketSchemaOutput, BucketSchemaOutputTypedDict
from .collectioncacheconfig_output import (
    CollectionCacheConfigOutput,
    CollectionCacheConfigOutputTypedDict,
)
from .featureextractorconfig import (
    FeatureExtractorConfig,
    FeatureExtractorConfigTypedDict,
)
from .singlelineageentry import SingleLineageEntry, SingleLineageEntryTypedDict
from .taskstatus import TaskStatus
from .taxonomyapplicationconfig import (
    TaxonomyApplicationConfig,
    TaxonomyApplicationConfigTypedDict,
)
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CollectionModelMetadataTypedDict(TypedDict):
    pass


class CollectionModelMetadata(BaseModel):
    pass


class CollectionModelTypedDict(TypedDict):
    r"""Collection model defining the high-level structure and behavior of a collection.
    Collections are created and modified through feature extractors, which define
    their own document handling behavior (create/enrich/replace) through their
    document_output_handling settings.
    """

    collection_name: str
    r"""Name for the collection"""
    feature_extractors: List[FeatureExtractorConfigTypedDict]
    r"""List of feature extractor configurations used to create the collection"""
    output_schema: BucketSchemaOutputTypedDict
    r"""Schema definition for bucket objects"""
    collection_id: NotRequired[str]
    r"""Unique identifier for the collection"""
    description: NotRequired[Nullable[str]]
    r"""Description for the collection"""
    metadata: NotRequired[Nullable[CollectionModelMetadataTypedDict]]
    r"""Optional metadata for the collection"""
    enabled: NotRequired[bool]
    r"""Enable or disable processing of this collection"""
    source_lineage: NotRequired[List[SingleLineageEntryTypedDict]]
    r"""Ordered list of lineage entries, from source to this collection"""
    status: NotRequired[Nullable[TaskStatus]]
    r"""Status of the feature extractors in this collection"""
    taxonomy_applications: NotRequired[List[TaxonomyApplicationConfigTypedDict]]
    r"""List of taxonomy application configurations"""
    cache_config: NotRequired[Nullable[CollectionCacheConfigOutputTypedDict]]
    r"""Configuration for collection-level caching"""


class CollectionModel(BaseModel):
    r"""Collection model defining the high-level structure and behavior of a collection.
    Collections are created and modified through feature extractors, which define
    their own document handling behavior (create/enrich/replace) through their
    document_output_handling settings.
    """

    collection_name: str
    r"""Name for the collection"""

    feature_extractors: List[FeatureExtractorConfig]
    r"""List of feature extractor configurations used to create the collection"""

    output_schema: BucketSchemaOutput
    r"""Schema definition for bucket objects"""

    collection_id: Optional[str] = None
    r"""Unique identifier for the collection"""

    description: OptionalNullable[str] = UNSET
    r"""Description for the collection"""

    metadata: OptionalNullable[CollectionModelMetadata] = UNSET
    r"""Optional metadata for the collection"""

    enabled: Optional[bool] = True
    r"""Enable or disable processing of this collection"""

    source_lineage: Optional[List[SingleLineageEntry]] = None
    r"""Ordered list of lineage entries, from source to this collection"""

    status: OptionalNullable[TaskStatus] = UNSET
    r"""Status of the feature extractors in this collection"""

    taxonomy_applications: Optional[List[TaxonomyApplicationConfig]] = None
    r"""List of taxonomy application configurations"""

    cache_config: OptionalNullable[CollectionCacheConfigOutput] = UNSET
    r"""Configuration for collection-level caching"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "collection_id",
            "description",
            "metadata",
            "enabled",
            "source_lineage",
            "status",
            "taxonomy_applications",
            "cache_config",
        ]
        nullable_fields = ["description", "metadata", "status", "cache_config"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
