"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .bucketschemafieldtype import BucketSchemaFieldType
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any
from typing_extensions import NotRequired, TypedDict


class CreateBlobRequestMetadataTypedDict(TypedDict):
    pass


class CreateBlobRequestMetadata(BaseModel):
    pass


class CreateBlobRequestTypedDict(TypedDict):
    r"""Request model for creating a new blob"""

    property: str
    r"""Property name in the schema that this blob belongs to"""
    type: BucketSchemaFieldType
    r"""Enum for field types in bucket schemas"""
    data: Any
    r"""Data for the blob, this will only be applied to the documents that use this blob"""
    key_prefix: NotRequired[Nullable[str]]
    r"""Optional prefix for the blob key"""
    metadata: NotRequired[Nullable[CreateBlobRequestMetadataTypedDict]]
    r"""Metadata for the blob, this will only be applied to the documents that use this blob"""


class CreateBlobRequest(BaseModel):
    r"""Request model for creating a new blob"""

    property: str
    r"""Property name in the schema that this blob belongs to"""

    type: BucketSchemaFieldType
    r"""Enum for field types in bucket schemas"""

    data: Any
    r"""Data for the blob, this will only be applied to the documents that use this blob"""

    key_prefix: OptionalNullable[str] = UNSET
    r"""Optional prefix for the blob key"""

    metadata: OptionalNullable[CreateBlobRequestMetadata] = UNSET
    r"""Metadata for the blob, this will only be applied to the documents that use this blob"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["key_prefix", "metadata"]
        nullable_fields = ["key_prefix", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
