"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .collectioncacheconfig_input import (
    CollectionCacheConfigInput,
    CollectionCacheConfigInputTypedDict,
)
from .documenthandlingconfig import (
    DocumentHandlingConfig,
    DocumentHandlingConfigTypedDict,
)
from .featureextractorconfig import (
    FeatureExtractorConfig,
    FeatureExtractorConfigTypedDict,
)
from .sourceconfig_input import SourceConfigInput, SourceConfigInputTypedDict
from .taxonomyapplicationconfig import (
    TaxonomyApplicationConfig,
    TaxonomyApplicationConfigTypedDict,
)
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CreateCollectionRequestMetadataTypedDict(TypedDict):
    pass


class CreateCollectionRequestMetadata(BaseModel):
    pass


class CreateCollectionRequestTypedDict(TypedDict):
    r"""Request model for creating a new collection"""

    collection_name: str
    r"""Name for the collection"""
    source: SourceConfigInputTypedDict
    r"""Configuration for a collection source"""
    feature_extractors: List[FeatureExtractorConfigTypedDict]
    r"""List of feature extractor configurations to use"""
    description: NotRequired[Nullable[str]]
    r"""Description for the collection"""
    taxonomy_applications: NotRequired[List[TaxonomyApplicationConfigTypedDict]]
    r"""List of taxonomy application configurations. there are two options: on ingestion store the taxonomy application results to this collection, or on demand compute the taxonomy application results at query time"""
    enabled: NotRequired[bool]
    r"""Enable or disable processing of this collection"""
    metadata: NotRequired[Nullable[CreateCollectionRequestMetadataTypedDict]]
    r"""Optional metadata for the collection"""
    document_handling: NotRequired[Nullable[DocumentHandlingConfigTypedDict]]
    r"""Configuration for how documents are handled by this extractor"""
    cache_config: NotRequired[Nullable[CollectionCacheConfigInputTypedDict]]
    r"""Configuration for collection-level caching"""


class CreateCollectionRequest(BaseModel):
    r"""Request model for creating a new collection"""

    collection_name: str
    r"""Name for the collection"""

    source: SourceConfigInput
    r"""Configuration for a collection source"""

    feature_extractors: List[FeatureExtractorConfig]
    r"""List of feature extractor configurations to use"""

    description: OptionalNullable[str] = UNSET
    r"""Description for the collection"""

    taxonomy_applications: Optional[List[TaxonomyApplicationConfig]] = None
    r"""List of taxonomy application configurations. there are two options: on ingestion store the taxonomy application results to this collection, or on demand compute the taxonomy application results at query time"""

    enabled: Optional[bool] = True
    r"""Enable or disable processing of this collection"""

    metadata: OptionalNullable[CreateCollectionRequestMetadata] = UNSET
    r"""Optional metadata for the collection"""

    document_handling: OptionalNullable[DocumentHandlingConfig] = UNSET
    r"""Configuration for how documents are handled by this extractor"""

    cache_config: OptionalNullable[CollectionCacheConfigInput] = UNSET
    r"""Configuration for collection-level caching"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "taxonomy_applications",
            "enabled",
            "metadata",
            "document_handling",
            "cache_config",
        ]
        nullable_fields = [
            "description",
            "metadata",
            "document_handling",
            "cache_config",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
