"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .createblobrequest import CreateBlobRequest, CreateBlobRequestTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class CreateObjectRequestMetadataTypedDict(TypedDict):
    r"""Additional metadata for the object, this will be appended in all downstream documents of the your connected collections."""


class CreateObjectRequestMetadata(BaseModel):
    r"""Additional metadata for the object, this will be appended in all downstream documents of the your connected collections."""


class CreateObjectRequestTypedDict(TypedDict):
    r"""Request model for creating a bucket object"""

    key_prefix: NotRequired[Nullable[str]]
    r"""Storage key/path prefix of the object, this will be used to retrieve the object from the storage. It's at the root of the object."""
    blobs: NotRequired[List[CreateBlobRequestTypedDict]]
    r"""List of blobs to be created in this object"""
    metadata: NotRequired[CreateObjectRequestMetadataTypedDict]
    r"""Additional metadata for the object, this will be appended in all downstream documents of the your connected collections."""
    skip_duplicates: NotRequired[bool]
    r"""Skip duplicate blobs, if a blob with the same hash already exists, it will be skipped."""


class CreateObjectRequest(BaseModel):
    r"""Request model for creating a bucket object"""

    key_prefix: OptionalNullable[str] = UNSET
    r"""Storage key/path prefix of the object, this will be used to retrieve the object from the storage. It's at the root of the object."""

    blobs: Optional[List[CreateBlobRequest]] = None
    r"""List of blobs to be created in this object"""

    metadata: Optional[CreateObjectRequestMetadata] = None
    r"""Additional metadata for the object, this will be appended in all downstream documents of the your connected collections."""

    skip_duplicates: Optional[bool] = False
    r"""Skip duplicate blobs, if a blob with the same hash already exists, it will be skipped."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["key_prefix", "blobs", "metadata", "skip_duplicates"]
        nullable_fields = ["key_prefix"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
