"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class DocumentResponseMetadataTypedDict(TypedDict):
    pass


class DocumentResponseMetadata(BaseModel):
    pass


class DocumentResponseTypedDict(TypedDict):
    r"""Model for document response"""

    document_id: str
    r"""Unique identifier for the document"""
    collection_id: str
    r"""ID of the collection this document belongs to"""
    internal_id: str
    r"""Internal organization ID"""
    namespace_id: str
    r"""Namespace ID"""
    created_at: NotRequired[datetime]
    updated_at: NotRequired[Nullable[datetime]]
    metadata: NotRequired[DocumentResponseMetadataTypedDict]
    vectors: NotRequired[Dict[str, List[float]]]


class DocumentResponse(BaseModel):
    r"""Model for document response"""

    document_id: str
    r"""Unique identifier for the document"""

    collection_id: str
    r"""ID of the collection this document belongs to"""

    internal_id: str
    r"""Internal organization ID"""

    namespace_id: str
    r"""Namespace ID"""

    created_at: Optional[datetime] = None

    updated_at: OptionalNullable[datetime] = UNSET

    metadata: Optional[DocumentResponseMetadata] = None

    vectors: Optional[Dict[str, List[float]]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["created_at", "updated_at", "metadata", "vectors"]
        nullable_fields = ["updated_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
