"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .documentinputhandling import DocumentInputHandling
from .documentoutputhandling import DocumentOutputHandling
from .documentoutputtype import DocumentOutputType
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, Optional
from typing_extensions import NotRequired, TypedDict


class ParametersTypedDict(TypedDict):
    r"""Custom parameters for the extractor"""


class Parameters(BaseModel):
    r"""Custom parameters for the extractor"""


class FeatureExtractorConfigTypedDict(TypedDict):
    r"""Configuration for a feature extractor that is selected for use within a collection.
    This model represents a selected feature extractor along with its specific configuration
    for a particular collection.
    This gets stored in the collection settings.
    """

    feature_extractor_name: str
    r"""Name of the feature extractor"""
    version: str
    r"""Version of the feature extractor"""
    parameters: NotRequired[ParametersTypedDict]
    r"""Custom parameters for the extractor"""
    input_mapping: NotRequired[Dict[str, str]]
    r"""Maps pipeline inputs to extractor inputs (source -> target)"""
    output_mapping: NotRequired[Dict[str, str]]
    r"""Maps extractor outputs to pipeline outputs (source -> target)"""
    document_output_type: NotRequired[Nullable[DocumentOutputType]]
    r"""Type of document output produced by the extractor"""
    document_input_handling: NotRequired[Nullable[DocumentInputHandling]]
    r"""How documents are provided to the extractor"""
    document_output_handling: NotRequired[Nullable[DocumentOutputHandling]]
    r"""How extractor output is handled for documents"""


class FeatureExtractorConfig(BaseModel):
    r"""Configuration for a feature extractor that is selected for use within a collection.
    This model represents a selected feature extractor along with its specific configuration
    for a particular collection.
    This gets stored in the collection settings.
    """

    feature_extractor_name: str
    r"""Name of the feature extractor"""

    version: str
    r"""Version of the feature extractor"""

    parameters: Optional[Parameters] = None
    r"""Custom parameters for the extractor"""

    input_mapping: Optional[Dict[str, str]] = None
    r"""Maps pipeline inputs to extractor inputs (source -> target)"""

    output_mapping: Optional[Dict[str, str]] = None
    r"""Maps extractor outputs to pipeline outputs (source -> target)"""

    document_output_type: OptionalNullable[DocumentOutputType] = UNSET
    r"""Type of document output produced by the extractor"""

    document_input_handling: OptionalNullable[DocumentInputHandling] = UNSET
    r"""How documents are provided to the extractor"""

    document_output_handling: OptionalNullable[DocumentOutputHandling] = UNSET
    r"""How extractor output is handled for documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "parameters",
            "input_mapping",
            "output_mapping",
            "document_output_type",
            "document_input_handling",
            "document_output_handling",
        ]
        nullable_fields = [
            "document_output_type",
            "document_input_handling",
            "document_output_handling",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
