"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .documentinputhandling import DocumentInputHandling
from .documentoutputhandling import DocumentOutputHandling
from .documentoutputtype import DocumentOutputType
from .vectorindexdefinition import VectorIndexDefinition, VectorIndexDefinitionTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import ConfigDict, model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class InputSchemaTypedDict(TypedDict):
    r"""Schema for input data"""


class InputSchema(BaseModel):
    r"""Schema for input data"""


class OutputSchemaTypedDict(TypedDict):
    r"""Schema for output data"""


class OutputSchema(BaseModel):
    r"""Schema for output data"""


class ParameterSchemaTypedDict(TypedDict):
    r"""Schema for parameters"""


class ParameterSchema(BaseModel):
    r"""Schema for parameters"""


class DefaultParametersTypedDict(TypedDict):
    r"""Default parameters"""


class DefaultParameters(BaseModel):
    r"""Default parameters"""


class FeatureExtractorDefinitionTypedDict(TypedDict):
    r"""Definition of a feature extractor."""

    feature_extractor_name: str
    r"""Name of the feature extractor"""
    description: str
    r"""Description of the feature extractor"""
    version: str
    r"""Version of the feature extractor"""
    module_path: str
    r"""Python module path for the feature extractor"""
    feature_id: NotRequired[str]
    r"""Unique identifier for the feature extractor"""
    input_schema: NotRequired[InputSchemaTypedDict]
    r"""Schema for input data"""
    output_schema: NotRequired[OutputSchemaTypedDict]
    r"""Schema for output data"""
    parameter_schema: NotRequired[ParameterSchemaTypedDict]
    r"""Schema for parameters"""
    supported_input_types: NotRequired[List[str]]
    r"""Supported input types"""
    max_inputs: NotRequired[Dict[str, int]]
    r"""Maximum number of inputs of each type"""
    default_parameters: NotRequired[DefaultParametersTypedDict]
    r"""Default parameters"""
    document_output_type: NotRequired[DocumentOutputType]
    r"""Enum for document output types"""
    document_input_handling: NotRequired[DocumentInputHandling]
    r"""How documents are provided to the feature extractor"""
    document_output_handling: NotRequired[DocumentOutputHandling]
    r"""Enum for document output handling types"""
    required_vector_indexes: NotRequired[Nullable[List[VectorIndexDefinitionTypedDict]]]
    r"""Vector indexes required by the extractor"""
    required_payload_indexes: NotRequired[Nullable[List[Any]]]
    r"""Payload indexes required by the extractor"""


class FeatureExtractorDefinition(BaseModel):
    r"""Definition of a feature extractor."""

    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    feature_extractor_name: str
    r"""Name of the feature extractor"""

    description: str
    r"""Description of the feature extractor"""

    version: str
    r"""Version of the feature extractor"""

    module_path: str
    r"""Python module path for the feature extractor"""

    feature_id: Optional[str] = ""
    r"""Unique identifier for the feature extractor"""

    input_schema: Optional[InputSchema] = None
    r"""Schema for input data"""

    output_schema: Optional[OutputSchema] = None
    r"""Schema for output data"""

    parameter_schema: Optional[ParameterSchema] = None
    r"""Schema for parameters"""

    supported_input_types: Optional[List[str]] = None
    r"""Supported input types"""

    max_inputs: Optional[Dict[str, int]] = None
    r"""Maximum number of inputs of each type"""

    default_parameters: Optional[DefaultParameters] = None
    r"""Default parameters"""

    document_output_type: Optional[DocumentOutputType] = None
    r"""Enum for document output types"""

    document_input_handling: Optional[DocumentInputHandling] = None
    r"""How documents are provided to the feature extractor"""

    document_output_handling: Optional[DocumentOutputHandling] = None
    r"""Enum for document output handling types"""

    required_vector_indexes: OptionalNullable[List[VectorIndexDefinition]] = UNSET
    r"""Vector indexes required by the extractor"""

    required_payload_indexes: OptionalNullable[List[Any]] = UNSET
    r"""Payload indexes required by the extractor"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "feature_id",
            "input_schema",
            "output_schema",
            "parameter_schema",
            "supported_input_types",
            "max_inputs",
            "default_parameters",
            "document_output_type",
            "document_input_handling",
            "document_output_handling",
            "required_vector_indexes",
            "required_payload_indexes",
        ]
        nullable_fields = ["required_vector_indexes", "required_payload_indexes"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        for k, v in serialized.items():
            m[k] = v

        return m
