"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .filteroperator import FilterOperator
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Any, Optional
from typing_extensions import NotRequired, TypedDict


class FilterConditionTypedDict(TypedDict):
    r"""Represents a single filter condition.

    Attributes:
    field: The field to filter on
    operator: The comparison operator
    value: The value to compare against
    """

    field: str
    r"""Field name to filter on"""
    operator: NotRequired[FilterOperator]
    r"""Supported filter operators across database implementations."""
    value: NotRequired[Nullable[Any]]
    r"""Value to compare against"""


class FilterCondition(BaseModel):
    r"""Represents a single filter condition.

    Attributes:
    field: The field to filter on
    operator: The comparison operator
    value: The value to compare against
    """

    field: str
    r"""Field name to filter on"""

    operator: Optional[FilterOperator] = None
    r"""Supported filter operators across database implementations."""

    value: OptionalNullable[Any] = UNSET
    r"""Value to compare against"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["operator", "value"]
        nullable_fields = ["value"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
