"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .aggregationtype import AggregationType
from .usagetimerange import UsageTimeRange
from datetime import datetime
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class GetUsageRequestModelTypedDict(TypedDict):
    r"""Request model for customizing usage data retrieval"""

    time_range: NotRequired[UsageTimeRange]
    r"""Time ranges for usage data"""
    custom_start_date: NotRequired[Nullable[datetime]]
    r"""Custom start date if time_range is 'custom'"""
    custom_end_date: NotRequired[Nullable[datetime]]
    r"""Custom end date if time_range is 'custom'"""
    include_namespace_breakdown: NotRequired[bool]
    r"""Whether to include usage breakdown by namespace"""
    history_aggregation: NotRequired[Nullable[AggregationType]]
    r"""Aggregation level for historical data"""
    namespaces: NotRequired[Nullable[List[str]]]
    r"""Filter to specific namespaces (all if not specified)"""


class GetUsageRequestModel(BaseModel):
    r"""Request model for customizing usage data retrieval"""

    time_range: Optional[UsageTimeRange] = None
    r"""Time ranges for usage data"""

    custom_start_date: OptionalNullable[datetime] = UNSET
    r"""Custom start date if time_range is 'custom'"""

    custom_end_date: OptionalNullable[datetime] = UNSET
    r"""Custom end date if time_range is 'custom'"""

    include_namespace_breakdown: Optional[bool] = True
    r"""Whether to include usage breakdown by namespace"""

    history_aggregation: OptionalNullable[AggregationType] = UNSET
    r"""Aggregation level for historical data"""

    namespaces: OptionalNullable[List[str]] = UNSET
    r"""Filter to specific namespaces (all if not specified)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "time_range",
            "custom_start_date",
            "custom_end_date",
            "include_namespace_breakdown",
            "history_aggregation",
            "namespaces",
        ]
        nullable_fields = [
            "custom_start_date",
            "custom_end_date",
            "history_aggregation",
            "namespaces",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
