"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .interactiontype import InteractionType
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List
from typing_extensions import NotRequired, TypedDict


class InteractionResponseMetadataTypedDict(TypedDict):
    pass


class InteractionResponseMetadata(BaseModel):
    pass


class InteractionResponseTypedDict(TypedDict):
    feature_id: str
    r"""ID of the item that was interacted with"""
    interaction_type: List[InteractionType]
    r"""Type of interaction or feedback"""
    interaction_id: str
    r"""Unique identifier for this interaction"""
    position: NotRequired[Nullable[int]]
    r"""Position in search results where interaction occurred"""
    metadata: NotRequired[Nullable[InteractionResponseMetadataTypedDict]]
    r"""Additional context about the interaction"""
    user_id: NotRequired[Nullable[str]]
    r"""Customer's authenticated user identifier - persists across sessions"""
    session_id: NotRequired[Nullable[str]]
    r"""Temporary identifier for a single search journey/session (typically 30min-1hr) - tracks anonymous and authenticated users"""


class InteractionResponse(BaseModel):
    feature_id: str
    r"""ID of the item that was interacted with"""

    interaction_type: List[InteractionType]
    r"""Type of interaction or feedback"""

    interaction_id: str
    r"""Unique identifier for this interaction"""

    position: OptionalNullable[int] = UNSET
    r"""Position in search results where interaction occurred"""

    metadata: OptionalNullable[InteractionResponseMetadata] = UNSET
    r"""Additional context about the interaction"""

    user_id: OptionalNullable[str] = UNSET
    r"""Customer's authenticated user identifier - persists across sessions"""

    session_id: OptionalNullable[str] = UNSET
    r"""Temporary identifier for a single search journey/session (typically 30min-1hr) - tracks anonymous and authenticated users"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["position", "metadata", "user_id", "session_id"]
        nullable_fields = ["position", "metadata", "user_id", "session_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
