"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .logicaloperator_input import LogicalOperatorInput, LogicalOperatorInputTypedDict
from .sortoption import SortOption, SortOptionTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class ListBucketsRequestTypedDict(TypedDict):
    r"""Request model for listing buckets"""

    filters: NotRequired[Nullable[LogicalOperatorInputTypedDict]]
    r"""Filters to apply to the bucket list"""
    sort: NotRequired[Nullable[SortOptionTypedDict]]
    r"""Sort options for the bucket list"""
    search: NotRequired[Nullable[str]]
    r"""Search term to filter buckets by name or description"""


class ListBucketsRequest(BaseModel):
    r"""Request model for listing buckets"""

    filters: OptionalNullable[LogicalOperatorInput] = UNSET
    r"""Filters to apply to the bucket list"""

    sort: OptionalNullable[SortOption] = UNSET
    r"""Sort options for the bucket list"""

    search: OptionalNullable[str] = UNSET
    r"""Search term to filter buckets by name or description"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["filters", "sort", "search"]
        nullable_fields = ["filters", "sort", "search"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
