"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .filtercondition import FilterCondition, FilterConditionTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class LogicalOperatorInputTypedDict(TypedDict):
    r"""Represents a logical operation (AND, OR, NOT) on filter conditions.

    Attributes:
    AND: List of conditions that must all be true
    OR: List of conditions where at least one must be true
    NOT: List of conditions that must all be false
    case_sensitive: Whether string comparisons are case sensitive
    """

    and_: NotRequired[Nullable[List[AndTypedDict]]]
    r"""Logical AND operation - all conditions must be true"""
    or_: NotRequired[Nullable[List[OrTypedDict]]]
    r"""Logical OR operation - at least one condition must be true"""
    not_: NotRequired[Nullable[List[NotTypedDict]]]
    r"""Logical NOT operation - all conditions must be false"""
    case_sensitive: NotRequired[Nullable[bool]]
    r"""Whether to perform case-sensitive matching"""


class LogicalOperatorInput(BaseModel):
    r"""Represents a logical operation (AND, OR, NOT) on filter conditions.

    Attributes:
    AND: List of conditions that must all be true
    OR: List of conditions where at least one must be true
    NOT: List of conditions that must all be false
    case_sensitive: Whether string comparisons are case sensitive
    """

    and_: Annotated[OptionalNullable[List[And]], pydantic.Field(alias="AND")] = UNSET
    r"""Logical AND operation - all conditions must be true"""

    or_: Annotated[OptionalNullable[List[Or]], pydantic.Field(alias="OR")] = UNSET
    r"""Logical OR operation - at least one condition must be true"""

    not_: Annotated[OptionalNullable[List[Not]], pydantic.Field(alias="NOT")] = UNSET
    r"""Logical NOT operation - all conditions must be false"""

    case_sensitive: OptionalNullable[bool] = UNSET
    r"""Whether to perform case-sensitive matching"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["AND", "OR", "NOT", "case_sensitive"]
        nullable_fields = ["AND", "OR", "NOT", "case_sensitive"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


AndTypedDict = TypeAliasType(
    "AndTypedDict", Union[FilterConditionTypedDict, "LogicalOperatorInputTypedDict"]
)


And = TypeAliasType("And", Union[FilterCondition, "LogicalOperatorInput"])


OrTypedDict = TypeAliasType(
    "OrTypedDict", Union[FilterConditionTypedDict, "LogicalOperatorInputTypedDict"]
)


Or = TypeAliasType("Or", Union[FilterCondition, "LogicalOperatorInput"])


NotTypedDict = TypeAliasType(
    "NotTypedDict", Union[FilterConditionTypedDict, "LogicalOperatorInputTypedDict"]
)


Not = TypeAliasType("Not", Union[FilterCondition, "LogicalOperatorInput"])
