"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class RetrieverCacheConfigTypedDict(TypedDict):
    r"""Configuration for retriever-specific caching"""

    enabled: NotRequired[bool]
    r"""Whether caching is enabled for this retriever"""
    ttl_seconds: NotRequired[Nullable[int]]
    r"""Optional retriever-specific TTL override"""
    score_threshold: NotRequired[Nullable[float]]
    r"""Optional retriever-specific score threshold"""


class RetrieverCacheConfig(BaseModel):
    r"""Configuration for retriever-specific caching"""

    enabled: Optional[bool] = True
    r"""Whether caching is enabled for this retriever"""

    ttl_seconds: OptionalNullable[int] = UNSET
    r"""Optional retriever-specific TTL override"""

    score_threshold: OptionalNullable[float] = UNSET
    r"""Optional retriever-specific score threshold"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["enabled", "ttl_seconds", "score_threshold"]
        nullable_fields = ["ttl_seconds", "score_threshold"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
