"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .logicaloperator_input import LogicalOperatorInput, LogicalOperatorInputTypedDict
from .sortoption import SortOption, SortOptionTypedDict
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class RetrieverQueryRequestInputsTypedDict(TypedDict):
    r"""Input values for the retriever query. These map to the required inputs defined in the retriever's first stage."""


class RetrieverQueryRequestInputs(BaseModel):
    r"""Input values for the retriever query. These map to the required inputs defined in the retriever's first stage."""


class RetrieverQueryRequestTypedDict(TypedDict):
    r"""Query parameters for executing a retriever pipeline.

    This model defines all the parameters that can be provided when running a
    search using a predefined retriever pipeline. It allows for customizing the
    query inputs, filtering, sorting, pagination, and result formatting.
    """

    inputs: RetrieverQueryRequestInputsTypedDict
    r"""Input values for the retriever query. These map to the required inputs defined in the retriever's first stage."""
    filters: NotRequired[Nullable[LogicalOperatorInputTypedDict]]
    r"""Logical operations for filtering results. Can include AND, OR, NOT conditions with field comparisons."""
    sorts: NotRequired[Nullable[List[SortOptionTypedDict]]]
    r"""Controls the ordering of results. Can sort by score (default) or any other document field. This sorts the results from the last stage."""
    limit: NotRequired[int]
    r"""Maximum number of results to return. Overrides the default pagination limit in the retriever definition."""
    offset: NotRequired[int]
    r"""Number of results to skip. Use with limit for pagination. For large offsets, consider using session_id for cursor-based pagination."""
    select: NotRequired[Nullable[List[str]]]
    r"""Specific fields to include in the response. If not specified, returns all fields."""
    session_id: NotRequired[Nullable[str]]
    r"""Session identifier for interaction tracking."""
    return_urls: NotRequired[bool]
    r"""When true, generates pre-signed URLs for any media assets in the results. May increase response time slightly."""


class RetrieverQueryRequest(BaseModel):
    r"""Query parameters for executing a retriever pipeline.

    This model defines all the parameters that can be provided when running a
    search using a predefined retriever pipeline. It allows for customizing the
    query inputs, filtering, sorting, pagination, and result formatting.
    """

    inputs: RetrieverQueryRequestInputs
    r"""Input values for the retriever query. These map to the required inputs defined in the retriever's first stage."""

    filters: OptionalNullable[LogicalOperatorInput] = UNSET
    r"""Logical operations for filtering results. Can include AND, OR, NOT conditions with field comparisons."""

    sorts: OptionalNullable[List[SortOption]] = UNSET
    r"""Controls the ordering of results. Can sort by score (default) or any other document field. This sorts the results from the last stage."""

    limit: Optional[int] = 10
    r"""Maximum number of results to return. Overrides the default pagination limit in the retriever definition."""

    offset: Optional[int] = 0
    r"""Number of results to skip. Use with limit for pagination. For large offsets, consider using session_id for cursor-based pagination."""

    select: OptionalNullable[List[str]] = UNSET
    r"""Specific fields to include in the response. If not specified, returns all fields."""

    session_id: OptionalNullable[str] = UNSET
    r"""Session identifier for interaction tracking."""

    return_urls: Optional[bool] = False
    r"""When true, generates pre-signed URLs for any media assets in the results. May increase response time slightly."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "filters",
            "sorts",
            "limit",
            "offset",
            "select",
            "session_id",
            "return_urls",
        ]
        nullable_fields = ["filters", "sorts", "select", "session_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
