"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .bucketschemafield_output import (
    BucketSchemaFieldOutput,
    BucketSchemaFieldOutputTypedDict,
)
from .bucketschemafieldtype import BucketSchemaFieldType
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import ConfigDict, model_serializer
from typing import Any, Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class RetrieverSchemaFieldOutputTypedDict(TypedDict):
    r"""Schema field definition for retriever inputs"""

    type: BucketSchemaFieldType
    r"""Enum for field types in bucket schemas"""
    default: NotRequired[Nullable[Any]]
    items: NotRequired[Nullable[BucketSchemaFieldOutputTypedDict]]
    properties: NotRequired[Nullable[Dict[str, BucketSchemaFieldOutputTypedDict]]]
    example: NotRequired[Nullable[Any]]
    description: NotRequired[Nullable[str]]
    enum: NotRequired[Nullable[List[Any]]]
    required: NotRequired[bool]
    r"""Whether this field is required for the retriever"""


class RetrieverSchemaFieldOutput(BaseModel):
    r"""Schema field definition for retriever inputs"""

    model_config = ConfigDict(
        populate_by_name=True, arbitrary_types_allowed=True, extra="allow"
    )
    __pydantic_extra__: Dict[str, Any] = pydantic.Field(init=False)

    type: BucketSchemaFieldType
    r"""Enum for field types in bucket schemas"""

    default: OptionalNullable[Any] = UNSET

    items: OptionalNullable[BucketSchemaFieldOutput] = UNSET

    properties: OptionalNullable[Dict[str, BucketSchemaFieldOutput]] = UNSET

    example: OptionalNullable[Any] = UNSET

    description: OptionalNullable[str] = UNSET

    enum: OptionalNullable[List[Any]] = UNSET

    required: Optional[bool] = True
    r"""Whether this field is required for the retriever"""

    @property
    def additional_properties(self):
        return self.__pydantic_extra__

    @additional_properties.setter
    def additional_properties(self, value):
        self.__pydantic_extra__ = value  # pyright: ignore[reportIncompatibleVariableOverride]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "default",
            "items",
            "properties",
            "example",
            "description",
            "enum",
            "required",
        ]
        nullable_fields = [
            "default",
            "items",
            "properties",
            "example",
            "description",
            "enum",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        for k, v in serialized.items():
            m[k] = v

        return m
