"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .bucketschema_output import BucketSchemaOutput, BucketSchemaOutputTypedDict
from .featureextractorconfig import (
    FeatureExtractorConfig,
    FeatureExtractorConfigTypedDict,
)
from .sourceconfig_output import SourceConfigOutput, SourceConfigOutputTypedDict
from .sourcetype import SourceType
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class SingleLineageEntryTypedDict(TypedDict):
    r"""A single entry in the collection lineage path"""

    source_type: SourceType
    r"""Types of entries in a collection lineage"""
    output_schema: BucketSchemaOutputTypedDict
    r"""Schema definition for bucket objects"""
    collection_id: NotRequired[Nullable[str]]
    r"""ID of this entry (collection_id)"""
    bucket_id: NotRequired[Nullable[str]]
    r"""ID of this entry (bucket_id)"""
    bucket_config: NotRequired[Nullable[SourceConfigOutputTypedDict]]
    r"""Bucket details if this is a bucket or using a bucket source"""
    collection_config: NotRequired[Nullable[SourceConfigOutputTypedDict]]
    r"""Collection details if this is a collection or using a collection source"""
    feature_extractors: NotRequired[List[FeatureExtractorConfigTypedDict]]
    r"""Feature extractors applied"""


class SingleLineageEntry(BaseModel):
    r"""A single entry in the collection lineage path"""

    source_type: SourceType
    r"""Types of entries in a collection lineage"""

    output_schema: BucketSchemaOutput
    r"""Schema definition for bucket objects"""

    collection_id: OptionalNullable[str] = UNSET
    r"""ID of this entry (collection_id)"""

    bucket_id: OptionalNullable[str] = UNSET
    r"""ID of this entry (bucket_id)"""

    bucket_config: OptionalNullable[SourceConfigOutput] = UNSET
    r"""Bucket details if this is a bucket or using a bucket source"""

    collection_config: OptionalNullable[SourceConfigOutput] = UNSET
    r"""Collection details if this is a collection or using a collection source"""

    feature_extractors: Optional[List[FeatureExtractorConfig]] = None
    r"""Feature extractors applied"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "collection_id",
            "bucket_id",
            "bucket_config",
            "collection_config",
            "feature_extractors",
        ]
        nullable_fields = [
            "collection_id",
            "bucket_id",
            "bucket_config",
            "collection_config",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
