"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .logicaloperator_input import LogicalOperatorInput, LogicalOperatorInputTypedDict
from .sourcetype import SourceType
from mixpeek.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class SourceConfigInputTypedDict(TypedDict):
    r"""Configuration for a collection source"""

    type: SourceType
    r"""Types of entries in a collection lineage"""
    bucket_id: NotRequired[Nullable[str]]
    r"""ID of the source bucket"""
    prefix_key: NotRequired[Nullable[str]]
    r"""Optional prefix to filter bucket objects"""
    collection_id: NotRequired[Nullable[str]]
    r"""ID of the source collection"""
    filters: NotRequired[Nullable[LogicalOperatorInputTypedDict]]
    r"""Optional filters to apply to the source collection"""


class SourceConfigInput(BaseModel):
    r"""Configuration for a collection source"""

    type: SourceType
    r"""Types of entries in a collection lineage"""

    bucket_id: OptionalNullable[str] = UNSET
    r"""ID of the source bucket"""

    prefix_key: OptionalNullable[str] = UNSET
    r"""Optional prefix to filter bucket objects"""

    collection_id: OptionalNullable[str] = UNSET
    r"""ID of the source collection"""

    filters: OptionalNullable[LogicalOperatorInput] = UNSET
    r"""Optional filters to apply to the source collection"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["bucket_id", "prefix_key", "collection_id", "filters"]
        nullable_fields = ["bucket_id", "prefix_key", "collection_id", "filters"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
